/*
 * Decompiled with CFR 0.152.
 */
package sqlj.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sqlj.framework.error.JSError;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.OptionGroup;
import sqlj.framework.options.PropertyList;
import sqlj.framework.options.PropertyListImpl;
import sqlj.mesg.OptionDesc;
import sqlj.mesg.SemanticErrors;
import sqlj.mesg.TranslatorErrors;
import sqlj.runtime.profile.util.CustomizerHarness;
import sqlj.runtime.profile.util.SerProfileToClass;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.tools.ClassMapper;
import sqlj.tools.LogMapper;
import sqlj.tools.SqljOptions;
import sqlj.translator.Main;
import sqlj.util.Disposable;
import sqlj.util.ParseException;
import sqlj.util.io.ErrorLogger;
import sqlj.util.io.OracleOutputStreamWriter;

public class Sqlj {
    private static final String[] booleanOptions = new String[]{"help", "version", "compile", "profile", "status", "linemap", "ser2class", "compiler-encoding-flag", "compiler-pipe-output-flag"};
    private static final String[] otherOptions = new String[]{"props", "encoding", "d", "default-customizer", "compiler-executable", "compiler-output-file"};
    private static ErrorLogger log;
    private static Main theMain;
    private static OptionGroup options;
    private static PrintWriter errorStream;
    private static PrintWriter statusStream;
    private static SqljOptions frontEndOptions;
    private static String passfile;
    private static boolean isPass1;
    private static boolean isPass2;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_TRANSLATE_ERROR = 1;
    public static final int STATUS_COMPILE_ERROR = 2;
    public static final int STATUS_CUSTOMIZE_ERROR = 3;
    public static final int STATUS_INSTRUMENT_ERROR = 4;
    public static final int STATUS_SER2CLASS_ERROR = 5;
    public static final int STATUS_CALL_JAVA_COMPILE = 90;
    public static final int STATUS_CALL_SER2CLASS_COMPILE = 91;
    private static boolean translationSuccessful;
    private static boolean compilationSuccessful;
    private static boolean customizationSuccessful;
    private static boolean instrumentationSuccessful;
    private static boolean ser2classSuccessful;
    private static Boolean m_compile_files;
    private static Boolean m_profile_files;
    private static Boolean m_sqlj_files;
    private static Vector files;
    private static boolean m_wantsHelp;
    private static boolean m_wantsShortcutHelp;
    private static boolean m_wantsLongHelp;
    private static boolean m_wantsVersion;
    private static boolean m_wantsProfileHelp;
    private static boolean m_wantsCompileHelp;
    private static PropertyListImpl compileOptions;
    private static PropertyListImpl profileOptions;
    private static final boolean FORCE_FILE_FOUND = true;
    private static final String COMMAND_LINE;
    private static final String PROPERTY_FILE = "sqlj.properties";
    private static final String SQLJ_PROP_PREFIX = "sqlj.";
    private static final String COMPILE_PROP_PREFIX = "compile.";
    private static final String PROFILE_PROP_PREFIX = "profile.";
    private static String[] prefixes;
    private static int[] prefixes_len;
    private static Boolean noValue;

    public static void main(String[] stringArray) {
        System.exit(Sqlj.statusMain(stringArray));
    }

    public static int statusMain(String[] stringArray) {
        if (stringArray.length >= 1 && (stringArray[0].startsWith("-pass1=") || stringArray[0].startsWith("-pass2=") || stringArray[0].startsWith("-fail2="))) {
            passfile = stringArray[0].substring(7);
            if (stringArray[0].startsWith("-pass1=")) {
                isPass1 = true;
                String[] stringArray2 = new String[stringArray.length - 1];
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    stringArray2[i2 - 1] = stringArray[i2];
                }
                stringArray = stringArray2;
            } else {
                isPass2 = true;
                translationSuccessful = true;
                compilationSuccessful = stringArray[0].startsWith("-pass2=");
                stringArray = Sqlj.restoreState(passfile);
            }
        }
        Sqlj.initializeErrors();
        SemanticAnalyzerFactory.captureInterestingOptions();
        try {
            try {
                Sqlj.processOptions(stringArray);
                if (isPass2) {
                } else if (!Sqlj.hasProfileFiles()) {
                    if (!Sqlj.wantsInfo()) {
                        if (Sqlj.hasSqljFiles()) {
                            if (frontEndOptions.getBoolean("status")) {
                                statusStream.println(TranslatorErrors.translatingFiles(files.size()));
                            }
                            theMain.runTranslation(files);
                        } else {
                            for (int i3 = 0; i3 < files.size(); ++i3) {
                                String string = (String)files.elementAt(i3);
                                if (string.endsWith(".java")) continue;
                                log.addEntry(new JSError(TranslatorErrors.illegal_input_extension(string)));
                            }
                        }
                    }
                } else if (Sqlj.hasCompileFiles()) {
                    log.addEntry(new JSError(TranslatorErrors.eitherSourceOrSer()));
                }
            }
            catch (InvalidOptionException invalidOptionException) {
            }
            catch (ParseException parseException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            errorStream.println(TranslatorErrors.unexpected_error());
            throwable.printStackTrace(errorStream);
            log.addEntry(new JSError(TranslatorErrors.exceptionCaught(throwable.toString())));
        }
        finally {
            Sqlj.finishTranslation();
        }
        try {
            if (isPass2) {
                Sqlj.runPostCompilation();
            } else if (m_wantsCompileHelp) {
                Sqlj.runCompilation(new String[]{"-help"}, stringArray);
            } else if (translationSuccessful && frontEndOptions.getBoolean("compile") && Sqlj.hasCompileFiles() && !Sqlj.wantsInfo()) {
                Sqlj.runCompilation(Sqlj.sqlj2java(files), stringArray);
            }
            if (isPass1 && frontEndOptions.getBoolean("compile") && Sqlj.hasCompileFiles()) {
                if (translationSuccessful) {
                    return 90;
                }
                File file = new File(passfile + ".run");
                try {
                    file.delete();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return 1;
            }
            if (m_wantsProfileHelp) {
                customizationSuccessful = Sqlj.runProfileCustomization(new String[]{"-help"});
            } else if (Sqlj.hasProfileFiles()) {
                Object[] objectArray = new String[files.size()];
                files.copyInto(objectArray);
                customizationSuccessful = Sqlj.runProfileCustomization((String[])objectArray);
            } else {
                customizationSuccessful = frontEndOptions.getBoolean("profile") && Sqlj.hasCompileFiles() && compilationSuccessful ? Sqlj.runProfileCustomization(null) : true;
            }
            if (frontEndOptions.getBoolean("linemap") && Sqlj.hasCompileFiles() && (!frontEndOptions.getBoolean("compile") || compilationSuccessful)) {
                if (!frontEndOptions.getBoolean("compile")) {
                    Main.classFilesTable = new Hashtable();
                    Enumeration enumeration = files.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (!string.endsWith(".java") && !string.endsWith(".sqlj")) continue;
                        string = string.substring(0, string.length() - 5);
                        Main.classFilesTable.put(string + ".java", string + ".class");
                    }
                }
                instrumentationSuccessful = Sqlj.runClassInstrumentation();
            } else {
                instrumentationSuccessful = true;
            }
            if (frontEndOptions.getBoolean("ser2class")) {
                if (Sqlj.hasProfileFiles()) {
                    Object[] objectArray = new String[files.size()];
                    files.copyInto(objectArray);
                    ser2classSuccessful = Sqlj.runSerToClassConversion((String[])objectArray);
                } else {
                    ser2classSuccessful = Sqlj.hasCompileFiles() && compilationSuccessful ? Sqlj.runSerToClassConversion(null) : true;
                }
            } else {
                ser2classSuccessful = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            errorStream.println("Exception: " + exception);
        }
        if (Sqlj.hasCompileFiles()) {
            if (!translationSuccessful) {
                return 1;
            }
            if (!compilationSuccessful && frontEndOptions.getBoolean("compile")) {
                return 2;
            }
        }
        if (!customizationSuccessful) {
            return 3;
        }
        if (!instrumentationSuccessful) {
            return 4;
        }
        if (!ser2classSuccessful) {
            return 5;
        }
        if (m_wantsHelp && files.size() == 0) {
            return 1;
        }
        return 0;
    }

    private static void initializeErrors() {
        log = new ErrorLogger();
        errorStream = null;
        statusStream = null;
        try {
            statusStream = errorStream = new PrintWriter((Writer)new OracleOutputStreamWriter(System.out), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.addEntry(new JSError(TranslatorErrors.unsupported_file_encoding(System.getProperty("file.encoding", "null"))));
            errorStream = new PrintWriter(System.out, true);
            statusStream = new PrintWriter(System.err, true);
        }
        catch (IOException iOException) {
            errorStream = new PrintWriter(System.out, true);
            statusStream = new PrintWriter(System.err, true);
        }
        catch (Exception exception) {
            errorStream = new PrintWriter(System.out, true);
            statusStream = new PrintWriter(System.out, true);
        }
    }

    private static void processOptions(String[] stringArray) throws InvalidOptionException {
        int n2;
        options = new OptionGroup();
        String[] stringArray2 = new String[booleanOptions.length + otherOptions.length];
        for (n2 = 0; n2 < booleanOptions.length; ++n2) {
            stringArray2[n2] = booleanOptions[n2];
        }
        n2 = 0;
        int n3 = booleanOptions.length;
        while (n2 < otherOptions.length) {
            stringArray2[n3] = otherOptions[n2];
            ++n2;
            ++n3;
        }
        frontEndOptions = new SqljOptions(stringArray2, log);
        options.addElement(frontEndOptions);
        theMain = new Main();
        theMain.prepareTranslation(options, log);
        Sqlj.procOptions(stringArray);
        if (frontEndOptions.getBoolean("status")) {
            Main.immediateStream = errorStream;
        }
        if (m_wantsVersion) {
            Sqlj.printVersion(errorStream);
        }
        if (m_wantsHelp) {
            Sqlj.printHelp(errorStream);
        }
        if (m_wantsShortcutHelp) {
            Sqlj.printShortcutHelp(errorStream);
        }
        if (m_wantsLongHelp) {
            Sqlj.printLongHelp(errorStream);
        }
    }

    private static void finishTranslation() {
        Disposable.disposer.dispose();
        log.printLog(errorStream);
        errorStream.flush();
        String string = "";
        switch (log.errorCount()) {
            case 0: {
                translationSuccessful = true;
                break;
            }
            case 1: {
                string = TranslatorErrors.oneError();
                break;
            }
            default: {
                string = log.errorCount() + " " + TranslatorErrors.errors();
            }
        }
        switch (log.warningCount()) {
            case 0: {
                break;
            }
            case 1: {
                if (string.length() > 0) {
                    string = string + " " + TranslatorErrors.andOneWarning();
                    break;
                }
                string = TranslatorErrors.oneWarning();
                break;
            }
            default: {
                string = string.length() > 0 ? string + " " + TranslatorErrors.and() + " " + log.warningCount() + " " + TranslatorErrors.warnings() : log.warningCount() + " " + TranslatorErrors.warnings();
            }
        }
        if (string.length() > 0) {
            errorStream.println(TranslatorErrors.total() + " " + string + ".");
        }
    }

    private static void runCompilation(String[] stringArray, String[] stringArray2) {
        int n2;
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(frontEndOptions.getOption("compiler-executable"));
        stringBuffer.append(" ");
        if (frontEndOptions.getBoolean("compiler-pipe-output-flag")) {
            stringBuffer.append("-J-Djavac.pipe.output=true ");
        }
        if ((string2 = frontEndOptions.getOption("encoding")) != null && !string2.equals("") && frontEndOptions.getBoolean("compiler-encoding-flag")) {
            stringBuffer.append("-encoding ");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        if ((string = frontEndOptions.getOption("d")) != null && !string.equals("")) {
            stringBuffer.append("-d ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        String[] stringArray3 = Sqlj.optionsToStrings(compileOptions);
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            if (stringArray3[n2].startsWith("-classpath=")) {
                stringBuffer.append("-classpath ");
                stringBuffer.append(stringArray3[n2].substring(11));
            } else {
                stringBuffer.append(stringArray3[n2]);
            }
            stringBuffer.append(" ");
        }
        for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
            stringBuffer.append(stringArray[n2]);
            stringBuffer.append(" ");
        }
        if (stringArray.length > 0) {
            stringBuffer.append(stringArray[stringArray.length - 1]);
        }
        if (frontEndOptions.getBoolean("status")) {
            statusStream.println(TranslatorErrors.compilingFiles(stringArray.length));
        }
        compilationSuccessful = false;
        if (isPass1) {
            Sqlj.writeState(passfile, stringArray2);
            Sqlj.writeJavaCRunline(passfile, stringBuffer.toString());
        } else {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(stringBuffer.toString());
                process.waitFor();
            }
            catch (IOException iOException) {
                errorStream.println(TranslatorErrors.errorInCompilation(iOException.getMessage()));
            }
            catch (InterruptedException interruptedException) {
                errorStream.println(TranslatorErrors.errorInCompilation(interruptedException.getMessage()));
            }
            try {
                if (process != null) {
                    InputStream inputStream;
                    int n3 = process.exitValue();
                    String string3 = frontEndOptions.getOption("compiler-output-file");
                    File file = null;
                    if (string3 != null && !string3.equals("")) {
                        file = new File(string3);
                        inputStream = new FileInputStream(file);
                    } else {
                        inputStream = process.getInputStream();
                    }
                    compilationSuccessful = LogMapper.main(inputStream, System.out);
                    if (n3 != 0) {
                        compilationSuccessful = false;
                    }
                    inputStream.close();
                    if (file != null) {
                        file.delete();
                    }
                }
            }
            catch (IOException iOException) {
                errorStream.println(TranslatorErrors.errorInCompilation(iOException.getMessage()));
            }
        }
    }

    private static void runPostCompilation() {
        try {
            File file = new File(passfile + ".log");
            FileInputStream fileInputStream = new FileInputStream(file);
            LogMapper.main(fileInputStream, System.out);
            ((InputStream)fileInputStream).close();
            file.delete();
        }
        catch (IOException iOException) {
            errorStream.println(TranslatorErrors.errorInCompilation(iOException.getMessage()));
        }
        catch (SecurityException securityException) {
            errorStream.println(TranslatorErrors.errorInCompilation(securityException.getMessage()));
        }
    }

    private static String[] getSerFiles() {
        if (Main.serFilesVector != null) {
            String[] stringArray = new String[Main.serFilesVector.size()];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file = (File)Main.serFilesVector.elementAt(i2);
                stringArray[i2] = file.toString();
            }
            return stringArray;
        }
        return new String[0];
    }

    private static boolean runProfileCustomization(String[] stringArray) {
        int n2;
        String string;
        if (stringArray == null) {
            stringArray = Sqlj.getSerFiles();
        }
        if (stringArray.length == 0) {
            return true;
        }
        String[] stringArray2 = Sqlj.optionsToStrings(profileOptions);
        if (stringArray.length == 1 && stringArray[0].equals("-help")) {
            stringArray = new String[stringArray2.length + 1];
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                stringArray[i2] = stringArray2[i2];
            }
            stringArray[stringArray2.length] = "-help";
            stringArray2 = stringArray;
            stringArray = new String[]{};
        }
        boolean bl = (string = frontEndOptions.getOption("default-customizer")) != null && !string.equals("");
        Hashtable hashtable = SemanticAnalyzerFactory.getInterestingOptions();
        int n3 = hashtable == null ? 0 : hashtable.size();
        String[] stringArray3 = new String[n3 + stringArray2.length + stringArray.length + (bl ? 1 : 0)];
        int n4 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            stringArray3[n4] = "-" + string2 + (string3 == null || string3.equals("") ? "" : "=" + string3);
            ++n4;
        }
        boolean bl2 = false;
        if (bl) {
            stringArray3[n4] = "-customizer=" + string;
            ++n4;
            bl2 = true;
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (stringArray2[n2].equals("-print")) {
                stringArray2[n2] = "-customizer=sqlj.runtime.profile.util.ProfilePrinter";
                bl2 = true;
            } else if (stringArray2[n2].equals("-debug")) {
                stringArray2[n2] = "-customizer=sqlj.runtime.profile.util.AuditorInstaller";
                bl2 = true;
            } else if (stringArray2[n2].equals("-help") || stringArray2[n2].startsWith("-customizer=")) {
                bl2 = true;
            }
            stringArray3[n2 + n4] = stringArray2[n2];
        }
        if (bl2) {
            if (frontEndOptions.getBoolean("status")) {
                statusStream.println(TranslatorErrors.customizingProfiles(stringArray.length));
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray3[stringArray2.length + n2 + n4] = stringArray[n2];
            }
            n2 = CustomizerHarness.mainStatus(stringArray3);
            return n2 == 0;
        }
        return true;
    }

    private static boolean runClassInstrumentation() {
        boolean bl = true;
        if (Main.classFilesTable.size() == 0) {
            return true;
        }
        if (frontEndOptions.getBoolean("status")) {
            statusStream.println(TranslatorErrors.instrumentingClassfiles(Main.classFilesTable.size()));
        }
        Enumeration enumeration = Main.classFilesTable.keys();
        while (enumeration.hasMoreElements()) {
            int n2;
            String string = (String)enumeration.nextElement();
            String string2 = (String)Main.classFilesTable.get(string);
            if (frontEndOptions.getBoolean("status")) {
                statusStream.println(TranslatorErrors.instrumentingClassfile(string2, string));
            }
            if ((n2 = ClassMapper.mainStatus(string2, string)) == 0) continue;
            bl = false;
        }
        return bl;
    }

    private static boolean runSerToClassConversion(String[] stringArray) {
        boolean bl = true;
        if (stringArray == null) {
            stringArray = Sqlj.getSerFiles();
        }
        if (stringArray.length == 0) {
            return bl;
        }
        if (frontEndOptions.getBoolean("status")) {
            statusStream.println(TranslatorErrors.convertSerToClass(stringArray.length));
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].endsWith(".ser")) {
                int n2 = SerProfileToClass.mainStatus(new String[]{"-rj", "-rs", stringArray[i2]});
                if (n2 == 0) continue;
                bl = false;
                continue;
            }
            bl = false;
            errorStream.println("Unable to convert " + stringArray[i2] + " to a class file.");
        }
        return bl;
    }

    private static String[] sqlj2java(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = (String)vector.elementAt(i2);
            stringArray[i2] = string.endsWith(".sqlj") ? (String)Main.javaFilesTable.get(string) : string;
        }
        return stringArray;
    }

    private static void hasXXXFiles() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < files.size(); ++i2) {
            String string = (String)files.elementAt(i2);
            if (string.endsWith(".sqlj")) {
                bl2 = true;
                bl3 = true;
                continue;
            }
            if (!bl2 && string.endsWith(".java")) {
                bl2 = true;
                continue;
            }
            if (bl || !string.endsWith(".ser") && !string.endsWith(".jar")) continue;
            bl = true;
        }
        m_compile_files = new Boolean(bl2);
        m_profile_files = new Boolean(bl);
        m_sqlj_files = new Boolean(bl3);
    }

    private static boolean hasCompileFiles() {
        if (m_compile_files == null) {
            Sqlj.hasXXXFiles();
        }
        return m_compile_files;
    }

    private static boolean hasProfileFiles() {
        if (m_profile_files == null) {
            Sqlj.hasXXXFiles();
        }
        return m_profile_files;
    }

    private static boolean hasSqljFiles() {
        if (m_sqlj_files == null) {
            Sqlj.hasXXXFiles();
        }
        return m_sqlj_files;
    }

    private static boolean wantsInfo() {
        return m_wantsHelp || m_wantsShortcutHelp || m_wantsLongHelp || m_wantsVersion || m_wantsProfileHelp || m_wantsCompileHelp;
    }

    private static String[] optionsToStrings(PropertyListImpl propertyListImpl) {
        Object[] objectArray;
        if (propertyListImpl == null) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = propertyListImpl.propertyNames();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            String string = propertyListImpl.getProperty((String)objectArray);
            vector.addElement("-" + (String)objectArray + (string == null || string.equals("") ? "" : "=" + string));
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void procOptions(String[] stringArray) throws InvalidOptionException {
        int n2;
        PropertyListImpl[] propertyListImplArray = new PropertyListImpl[]{new PropertyListImpl(), new PropertyListImpl(), new PropertyListImpl()};
        propertyListImplArray = Sqlj.importProps("java.home", propertyListImplArray);
        propertyListImplArray = Sqlj.importProps("user.home", propertyListImplArray);
        propertyListImplArray = Sqlj.importProps("user.dir", propertyListImplArray);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals("-P-help")) {
                m_wantsProfileHelp = true;
                continue;
            }
            if (stringArray[n2].equals("-C-help")) {
                m_wantsCompileHelp = true;
                continue;
            }
            propertyListImplArray = Sqlj.procOption(stringArray[n2], propertyListImplArray);
        }
        options.setOptions(propertyListImplArray[0], log);
        Sqlj.handleUnusedOptions(propertyListImplArray[0]);
        compileOptions = propertyListImplArray[1];
        profileOptions = propertyListImplArray[2];
        n2 = 0;
        for (int i2 = 0; i2 < booleanOptions.length; ++i2) {
            try {
                frontEndOptions.getBooleanOption(booleanOptions[i2]);
                continue;
            }
            catch (InvalidOptionException invalidOptionException) {
                log.addEntry(new JSError(SemanticErrors.illegalBooleanOptionEntry(booleanOptions[i2], invalidOptionException.getMessage())));
                n2 = 1;
            }
        }
        if (n2 != 0) {
            throw new InvalidOptionException();
        }
        if (!Sqlj.wantsInfo() && files.size() == 0) {
            m_wantsHelp = true;
        }
    }

    private static void handleUnusedOptions(PropertyList propertyList) throws InvalidOptionException {
        boolean bl = false;
        Enumeration enumeration = propertyList.propertyNames(false);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = propertyList.getPropertyLocation(string);
            log.addEntry(new JSError(TranslatorErrors.unknown_option(string, string2)));
            bl = true;
        }
        if (bl) {
            throw new InvalidOptionException();
        }
    }

    private static PropertyListImpl[] importProps(String string, PropertyListImpl[] propertyListImplArray) throws InvalidOptionException {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            propertyListImplArray = Sqlj.procProps(new File(string2, PROPERTY_FILE), false, propertyListImplArray);
        }
        return propertyListImplArray;
    }

    private static PropertyListImpl[] procProps(File file, boolean bl, PropertyListImpl[] propertyListImplArray) throws InvalidOptionException {
        Properties properties = new Properties();
        boolean bl2 = false;
        try {
            if (file.isFile()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
                for (int i2 = 0; i2 < 3; ++i2) {
                    propertyListImplArray[i2] = new PropertyListImpl(propertyListImplArray[i2]);
                }
                Sqlj.loadProps(properties, file.getPath(), propertyListImplArray);
            } else {
                bl2 = bl;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl2 = bl;
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        if (bl2) {
            log.addEntry(new JSError(TranslatorErrors.bad_property_file(file.getPath())));
            throw new InvalidOptionException();
        }
        return propertyListImplArray;
    }

    private static void loadProps(Properties properties, String string, PropertyListImpl[] propertyListImplArray) {
        Enumeration<?> enumeration = properties.propertyNames();
        block0: while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            for (int i2 = 0; i2 < prefixes.length; ++i2) {
                if (!string2.startsWith(prefixes[i2])) continue;
                propertyListImplArray[i2].addProperty(string2.substring(prefixes_len[i2]), properties.getProperty(string2), string);
                continue block0;
            }
        }
    }

    private static PropertyListImpl[] procOption(String string, PropertyListImpl[] propertyListImplArray) throws InvalidOptionException {
        if (string.startsWith("-C-")) {
            string = string.substring(3);
            propertyListImplArray[1].addProperty(string, COMMAND_LINE);
        } else if (string.startsWith("-P-")) {
            string = string.substring(3);
            propertyListImplArray[2].addProperty(string, COMMAND_LINE);
        } else if (string.startsWith("-")) {
            if (Sqlj.isFlagOption(string = string.substring(1), "help")) {
                m_wantsHelp = true;
            } else if (Sqlj.isFlagOption(string, "help-alias")) {
                m_wantsShortcutHelp = true;
            } else if (Sqlj.isFlagOption(string, "help-long")) {
                m_wantsLongHelp = true;
            } else if (Sqlj.isFlagOption(string, "version")) {
                m_wantsVersion = true;
            } else if (Sqlj.isValueOption(string, "props")) {
                String string2 = Sqlj.getOptionValue(string, "props");
                propertyListImplArray = Sqlj.procProps(new File(string2), true, propertyListImplArray);
            } else {
                propertyListImplArray[0].addProperty(string, COMMAND_LINE);
            }
        } else {
            files.addElement(string);
        }
        return propertyListImplArray;
    }

    private static boolean isFlagOption(String string, String string2) {
        return string.equals(string2);
    }

    private static boolean isValueOption(String string, String string2) {
        if (string.startsWith(string2)) {
            int n2 = string2.length();
            return string.length() == n2 || string.charAt(n2) == '=';
        }
        return false;
    }

    private static String getOptionValue(String string, String string2) {
        int n2 = string2.length();
        return string.length() > n2 ? string.substring(n2 + 1) : "";
    }

    private static void writeState(String string, String[] stringArray) {
        try {
            File file = new File(string + ".ser");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject("GBase Embedded SQLJ version 1.01.JC2 built in December 2001");
            objectOutputStream.writeObject(stringArray);
            objectOutputStream.writeObject(Main.serFilesVector);
            objectOutputStream.writeObject(Main.javaFilesTable);
            objectOutputStream.writeObject(Main.classFilesTable);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Unable to write translation state to " + string + ".ser: " + iOException);
        }
    }

    private static void writeJavaCRunline(String string, String string2) {
        try {
            File file = new File(string + ".run");
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println(string2);
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Unable to write Java compiler command line to " + string + ".run: " + iOException);
        }
    }

    private static String[] restoreState(String string) {
        String[] stringArray = null;
        try {
            File file = new File(string + ".ser");
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            String string2 = "UNKNOWN";
            try {
                string2 = (String)objectInputStream.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null || !string2.equals("GBase Embedded SQLJ version 1.01.JC2 built in December 2001")) {
                throw new IOException("File or version mismatch in reading SQLJ translation state.");
            }
            stringArray = (String[])objectInputStream.readObject();
            Main.serFilesVector = (Vector)objectInputStream.readObject();
            Main.javaFilesTable = (Hashtable)objectInputStream.readObject();
            Main.classFilesTable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            file.delete();
            file = new File(string + ".run");
            file.delete();
            return stringArray;
        }
        catch (IOException iOException) {
            System.out.println("Unable to write read translation state from " + string + ".ser: " + iOException);
            return stringArray;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Unable to write read translation state from " + string + ".ser: " + classNotFoundException);
            return stringArray;
        }
        catch (SecurityException securityException) {
            System.out.println("Unable to remove file " + string + ".ser or " + string + ".run");
            return stringArray;
        }
    }

    private static void printHelp(PrintWriter printWriter) {
        printWriter.println(TranslatorErrors.sqljHelpMessage());
    }

    private static void printLongHelp(PrintWriter printWriter) {
        printWriter.println(TranslatorErrors.synopsis("sqlj"));
        printWriter.println(TranslatorErrors.options());
        printWriter.println();
        Sqlj.printParams(printWriter, options.getOptionInfo());
    }

    private static void printShortcutHelp(PrintWriter printWriter) {
        printWriter.println(TranslatorErrors.sqljShortcutMessage());
    }

    private static void printParams(PrintWriter printWriter, String[][] stringArray) {
        int n2;
        String[] stringArray2 = new String[]{TranslatorErrors.name(), TranslatorErrors.type(), TranslatorErrors.value(), TranslatorErrors.description(), TranslatorErrors.setFrom()};
        int n3 = 0;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (n3 >= stringArray2[n2].length()) continue;
            n3 = stringArray2[n2].length();
        }
        ++n3;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = (stringArray2[n2] + "                                   ").substring(0, n3);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            printWriter.println(stringArray2[0] + stringArray[n2][0]);
            if (stringArray[n2][1] != null) {
                printWriter.println(stringArray2[1] + stringArray[n2][1]);
            }
            if (stringArray[n2][2] != null) {
                printWriter.println(stringArray2[2] + stringArray[n2][2]);
            }
            if (stringArray[n2][3] != null) {
                printWriter.println(stringArray2[3] + stringArray[n2][3]);
            }
            if (stringArray[n2][4] != null) {
                printWriter.println(stringArray2[4] + stringArray[n2][4]);
            }
            printWriter.println();
        }
    }

    public static void printVersion(PrintWriter printWriter) {
        printWriter.println("GBase Embedded SQLJ version 1.01.JC2 built in December 2001");
    }

    private static ErrorLogger getErrorLogger() {
        return log;
    }

    static {
        passfile = null;
        isPass1 = false;
        isPass2 = false;
        translationSuccessful = false;
        compilationSuccessful = false;
        customizationSuccessful = false;
        instrumentationSuccessful = false;
        ser2classSuccessful = false;
        m_compile_files = null;
        m_profile_files = null;
        m_sqlj_files = null;
        files = new Vector();
        m_wantsHelp = false;
        m_wantsShortcutHelp = false;
        m_wantsLongHelp = false;
        m_wantsVersion = false;
        m_wantsProfileHelp = false;
        m_wantsCompileHelp = false;
        COMMAND_LINE = OptionDesc.command_line();
        prefixes = new String[]{SQLJ_PROP_PREFIX, COMPILE_PROP_PREFIX, PROFILE_PROP_PREFIX};
        prefixes_len = new int[]{SQLJ_PROP_PREFIX.length(), COMPILE_PROP_PREFIX.length(), PROFILE_PROP_PREFIX.length()};
        noValue = new Boolean(false);
    }
}

