/*
 * Decompiled with CFR 0.152.
 */
package sqlj.tools;

import java.io.FileInputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import sqlj.util.io.StringWriter;

public class SourceMapper
extends FilterWriter {
    private Reader m_isr = null;
    private StringWriter m_sw = null;
    private static final int SRC = 0;
    private static final int TGT = 1;
    private int size = 0;
    private int MAX_SIZE = 20;
    private int[][] sline = new int[2][this.MAX_SIZE];
    private int[][] scol = new int[2][this.MAX_SIZE];
    private int[][] eline = new int[2][this.MAX_SIZE];
    private int[][] ecol = new int[2][this.MAX_SIZE];
    private boolean ready = false;
    private boolean CR_SEEN = false;
    private int line_count = 1;
    private int col_count = 0;
    private int prev_col_count = 0;
    private static final int OTHER = 1;
    private static final int USER_CODE = 2;
    private static final int GENERATED_CODE = 3;
    private static final int LINEINFO = 4;
    private int startTokenColumn = 0;
    private int startTokenLine = 0;
    private int startTokenColOnPrevLine = 0;
    private int endTokenColumn = 0;
    private int endTokenLine = 0;
    private int info_line = 0;
    private int info_column = 0;
    private int line_at_info = 0;
    private int column_at_info = 0;
    static String USER_CODE_TAG = "user-code";
    static String GENERATED_CODE_TAG = "generated-code";
    private static String AT_LINEINFO_TAG = "@lineinfo:";
    private Integer m_sline = null;
    private Integer m_scol = null;
    private Integer m_eline = null;
    private Integer m_ecol = null;
    private int line_start;
    private int col_start;
    private int line_end;
    private int col_end;

    public SourceMapper(String string) {
        super(new StringWriter());
        this.size = 0;
        try {
            this.m_sw = null;
            FileInputStream fileInputStream = new FileInputStream(string);
            this.m_isr = new InputStreamReader(fileInputStream);
            this.readAll();
            this.m_isr.close();
            fileInputStream.close();
            this.ready = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SourceMapper(Reader reader) {
        super(new StringWriter());
        try {
            this.m_sw = null;
            this.m_isr = reader;
            this.readAll();
            this.m_isr.close();
            this.ready = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int size() {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: request for mapping with map construction pending");
        }
        return this.size;
    }

    public SourceMapper(Writer writer) {
        super(writer);
        this.m_isr = null;
        this.m_sw = new StringWriter();
    }

    private void allocate() {
        int n2 = this.MAX_SIZE * 2;
        int[][] nArray = new int[2][n2];
        int[][] nArray2 = new int[2][n2];
        int[][] nArray3 = new int[2][n2];
        int[][] nArray4 = new int[2][n2];
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < this.MAX_SIZE; ++i3) {
                nArray[i2][i3] = this.sline[i2][i3];
                nArray2[i2][i3] = this.scol[i2][i3];
                nArray3[i2][i3] = this.eline[i2][i3];
                nArray4[i2][i3] = this.ecol[i2][i3];
            }
        }
        this.sline = nArray;
        this.scol = nArray2;
        this.eline = nArray3;
        this.ecol = nArray4;
        this.MAX_SIZE = n2;
    }

    private void readAll() {
        try {
            int n2 = 1;
            int n3 = 1;
            int n4 = 1;
            int n5 = 1;
            int n6 = 1;
            while (true) {
                if (n2 != 3) {
                    n2 = this.readToken();
                    continue;
                }
                if (this.readToken() == 4) {
                    n3 = this.info_line;
                    n4 = this.info_column;
                    n5 = this.endTokenLine;
                    n6 = this.endTokenColumn;
                }
                while (n2 != 2) {
                    n2 = this.readToken();
                }
                this.readToken();
                if (this.size == this.MAX_SIZE) {
                    this.allocate();
                }
                this.sline[1][this.size] = n5;
                this.scol[1][this.size] = n6;
                this.eline[1][this.size] = this.line_count;
                this.ecol[1][this.size] = this.col_count;
                this.sline[0][this.size] = n3;
                this.scol[0][this.size] = n4;
                this.eline[0][this.size] = this.info_line;
                this.ecol[0][this.size] = this.info_column - 1;
                ++this.size;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private char nextChar() throws IOException {
        int n2 = this.m_isr.read();
        if (n2 < 0) {
            throw new IOException("EOF");
        }
        char c2 = (char)n2;
        ++this.col_count;
        if (c2 == '\r') {
            this.CR_SEEN = true;
            ++this.line_count;
            this.prev_col_count = this.col_count;
            this.col_count = 0;
        } else if (c2 == '\n') {
            if (!this.CR_SEEN) {
                this.prev_col_count = this.col_count;
                ++this.line_count;
            } else {
                this.CR_SEEN = false;
            }
            this.col_count = 0;
        } else {
            this.CR_SEEN = false;
        }
        return c2;
    }

    private int readToken() throws IOException {
        char c2;
        this.startTokenLine = this.line_count;
        this.startTokenColumn = this.col_count;
        if (this.startTokenColumn == 1) {
            this.startTokenColOnPrevLine = this.prev_col_count + 1;
        }
        if ((c2 = this.nextChar()) == '\"') {
            this.readEnclosing(34);
            return this.setOtherTokenEnd();
        }
        if (c2 == '\'') {
            this.readEnclosing(39);
            return this.setOtherTokenEnd();
        }
        if (c2 == '/') {
            c2 = this.nextChar();
            if (c2 == '/') {
                c2 = this.nextChar();
                while (c2 != '\n' && c2 != '\r') {
                    c2 = this.nextChar();
                }
                return this.setOtherTokenEnd();
            }
            if (c2 == '*') {
                c2 = this.nextChar();
                if (c2 == '@' && this.readAtLineinfo(c2)) {
                    c2 = this.nextChar();
                    if ('0' <= c2 && c2 <= '9') {
                        if (this.readLineInfo(c2)) {
                            this.line_at_info = this.line_count;
                            this.column_at_info = this.col_count;
                            return 4;
                        }
                        return this.setOtherTokenEnd();
                    }
                    if (c2 == 'u') {
                        if (this.readUserCode(c2)) {
                            return 2;
                        }
                        return this.setOtherTokenEnd();
                    }
                    if (c2 == 'g') {
                        if (this.readGeneratedCode(c2)) {
                            return 3;
                        }
                        return this.setOtherTokenEnd();
                    }
                    this.readComment(c2);
                    return this.setOtherTokenEnd();
                }
                this.readComment(c2);
                return this.setOtherTokenEnd();
            }
        } else if (c2 == '\\') {
            c2 = this.nextChar();
            if (c2 == 'u') {
                this.readUnicode();
            }
            return this.setOtherTokenEnd();
        }
        return this.setOtherTokenEnd();
    }

    private int setOtherTokenEnd() {
        this.endTokenLine = this.line_count;
        this.endTokenColumn = this.col_count;
        return 1;
    }

    private boolean readLineInfo(char c2) throws IOException {
        this.info_line = 0;
        this.info_column = 0;
        while ('0' <= c2 && c2 <= '9') {
            this.info_line *= 10;
            this.info_line += c2 - 48;
            c2 = this.nextChar();
        }
        if (c2 != '^') {
            this.readComment(c2);
            return false;
        }
        c2 = this.nextChar();
        if (c2 < '0' || '9' < c2) {
            this.readComment(c2);
            return false;
        }
        while ('0' <= c2 && c2 <= '9') {
            this.info_column *= 10;
            this.info_column += c2 - 48;
            c2 = this.nextChar();
        }
        return this.readEndComment(c2);
    }

    private boolean readUserCode(char c2) throws IOException {
        for (int i2 = 0; i2 < USER_CODE_TAG.length(); ++i2) {
            if (USER_CODE_TAG.charAt(i2) != c2) {
                this.readComment(c2);
                return false;
            }
            c2 = this.nextChar();
        }
        return this.readEndComment(c2);
    }

    private boolean readGeneratedCode(char c2) throws IOException {
        for (int i2 = 0; i2 < GENERATED_CODE_TAG.length(); ++i2) {
            if (GENERATED_CODE_TAG.charAt(i2) != c2) {
                this.readComment(c2);
                return false;
            }
            c2 = this.nextChar();
        }
        return this.readEndComment(c2);
    }

    private boolean readAtLineinfo(char c2) throws IOException {
        for (int i2 = 0; i2 < AT_LINEINFO_TAG.length(); ++i2) {
            if (AT_LINEINFO_TAG.charAt(i2) != c2) {
                this.readComment(c2);
                return false;
            }
            if (i2 >= AT_LINEINFO_TAG.length() - 1) continue;
            c2 = this.nextChar();
        }
        return true;
    }

    private void readEnclosing(int n2) throws IOException {
        boolean bl = false;
        char c2 = this.nextChar();
        while (true) {
            if (bl && c2 == 'u') {
                this.readUnicode();
                bl = false;
            } else if (bl) {
                bl = false;
            } else if (c2 == n2) {
                return;
            }
            c2 = this.nextChar();
        }
    }

    private void readUnicode() throws IOException {
        this.nextChar();
        this.nextChar();
        this.nextChar();
        this.nextChar();
    }

    private void readComment(char c2) throws IOException {
        boolean bl = c2 == '*';
        c2 = this.nextChar();
        while (!bl || c2 != '/') {
            bl = c2 == '*';
            c2 = this.nextChar();
        }
        return;
    }

    private boolean readEndComment(char c2) throws IOException {
        if (c2 == '*' && (c2 = this.nextChar()) == '/') {
            return true;
        }
        this.readComment(c2);
        return false;
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(cArray, n2, n3);
        super.write(cArray, n2, n3);
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(n2);
        super.write(n2);
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(string, n2, n3);
        super.write(string, n2, n3);
    }

    @Override
    public void flush() throws IOException {
        if (this.ready) {
            throw new IOException("flush not permitted on this SourceMapper");
        }
        this.m_sw.flush();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.ready) {
            throw new IOException("close not permitted on this SourceMapper");
        }
        this.m_sw.close();
        this.m_isr = new StringReader(this.m_sw.toString());
        this.readAll();
        this.m_isr.close();
        this.ready = true;
        this.m_sw = null;
        this.m_isr = null;
    }

    public int startLine() {
        if (this.m_sline != null) {
            return this.m_sline;
        }
        throw new IllegalArgumentException("startLine(): no line/col info available");
    }

    public int startCol() {
        if (this.m_scol != null) {
            return this.m_scol;
        }
        throw new IllegalArgumentException("startCol(): no line/col info available");
    }

    public int endLine() {
        if (this.m_eline != null) {
            return this.m_eline;
        }
        throw new IllegalArgumentException("endLine(): no line/col info available");
    }

    public int endCol() {
        if (this.m_ecol != null) {
            return this.m_ecol;
        }
        throw new IllegalArgumentException("endCol(): no line/col info available");
    }

    public void srcLineToTgt(int n2, int n3) {
        this.lineRange(0, n2, n3, n2, n3, 1);
    }

    public void srcLineToTgt(int n2, int n3, int n4, int n5) {
        this.lineRange(0, n2, n3, n4, n5, 1);
    }

    public void tgtLineToSrc(int n2, int n3) {
        this.lineRange(1, n2, n3, n2, n3, 0);
    }

    public void tgtLineToSrc(int n2, int n3, int n4, int n5) {
        this.lineRange(1, n2, n3, n4, n5, 0);
    }

    private void lineRange(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: request for mapping with map construction pending");
        }
        if (n5 < n3 || n3 == n5 && n6 < n4) {
            throw new IllegalArgumentException("end line/col < start line/col");
        }
        this.lookupLineCol(n2, n3, n4, n7);
        if (n3 == n5 && n4 == n6) {
            this.m_sline = new Integer(this.line_start);
            this.m_scol = new Integer(this.col_start);
            this.m_eline = new Integer(this.line_end);
            this.m_ecol = new Integer(this.col_end);
            return;
        }
        int n8 = this.line_start;
        int n9 = this.col_start;
        int n10 = this.line_end;
        int n11 = this.col_end;
        this.lookupLineCol(n2, n5, n6, n7);
        this.m_sline = new Integer(n8);
        this.m_scol = new Integer(n9);
        if (n10 > this.line_end || n10 == this.line_end && n11 > this.col_end) {
            this.m_eline = new Integer(n10);
            this.m_ecol = new Integer(n11);
        } else {
            this.m_eline = new Integer(this.line_end);
            this.m_ecol = new Integer(this.col_end);
        }
    }

    private void lookupLineCol(int n2, int n3, int n4, int n5) {
        if (this.size == 0 || n3 < this.sline[n2][0] || n3 == this.sline[n2][0] && n4 < this.scol[n2][0]) {
            this.line_end = this.line_start = n3;
            this.col_end = this.col_start = n4;
            return;
        }
        if (n3 > this.eline[n2][this.size - 1]) {
            this.line_start = n3 - this.eline[n2][this.size - 1] + this.eline[n5][this.size - 1];
            this.col_start = n4;
            this.line_end = this.line_start;
            this.col_end = this.col_start;
            return;
        }
        if (n3 == this.eline[n2][this.size - 1] && n4 > this.ecol[n2][this.size - 1]) {
            this.line_start = this.eline[n5][this.size - 1];
            this.col_start = n4 - this.ecol[n2][this.size - 1] + this.ecol[n5][this.size - 1];
            this.line_end = this.line_start;
            this.col_end = this.col_start;
            return;
        }
        int n6 = this.searchLineCol(n2, n3, n4);
        if (n6 < 0 || n6 >= this.size) {
            throw new IllegalArgumentException("Internal error: line/col not found:" + n3 + "/" + n4);
        }
        if (n3 < this.eline[n2][n6] || n3 == this.eline[n2][n6] && n4 <= this.ecol[n2][n6]) {
            this.line_start = this.sline[n5][n6];
            this.col_start = this.scol[n5][n6];
            this.line_end = this.eline[n5][n6];
            this.col_end = this.ecol[n5][n6];
            return;
        }
        if (this.eline[n2][n6] < n3) {
            this.line_end = this.line_start = n3 - this.eline[n2][n6] + this.eline[n5][n6];
            this.col_end = this.col_start = n4;
            return;
        }
        this.line_end = this.line_start = this.eline[n5][n6];
        this.col_end = this.col_start = n4 - this.ecol[n2][n6] + this.ecol[n5][n6];
    }

    private int searchLineCol(int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = this.size - 1;
        while (true) {
            if (n5 > n6) {
                if (this.size > 0 && (this.eline[n2][this.size - 1] < n3 || this.eline[n2][this.size - 1] == n3 && this.ecol[n2][this.size - 1] < n4)) {
                    return this.size;
                }
                return -1;
            }
            int n7 = (n5 + n6) / 2;
            int n8 = this.sline[n2][n7];
            int n9 = this.scol[n2][n7];
            if ((n8 < n3 || n8 == n3 && n9 <= n4) && (n7 == this.size - 1 || n3 < this.sline[n2][n7 + 1] || n3 == this.sline[n2][n7 + 1] && n4 < this.scol[n2][n7 + 1])) {
                return n7;
            }
            if (n8 > n3 || n8 == n3 && n9 > n4) {
                n6 = n7 - 1;
                continue;
            }
            n5 = n7 + 1;
        }
    }
}

