/*
 * Decompiled with CFR 0.152.
 */
package sqlj.syntax;

import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.checker.SQLToken;
import sqlj.semantics.sql.SQLTokenizer;
import sqlj.syntax.BindExpr;
import sqlj.syntax.Elem;
import sqlj.syntax.IntoBindExpr;
import sqlj.syntax.ReturnBindExpr;
import sqlj.syntax.Token;
import sqlj.util.Parselet;
import sqlj.util.io.ErrorLogger;

public class SQLUnit {
    private Parselet scope;
    private StringBuffer sqlStringBuffer = new StringBuffer();
    private StringBuffer javaCommentText = new StringBuffer();
    Vector bindList = new Vector();
    Vector markerList = null;
    int operType = 1023;
    private Object descriptor;
    private boolean isFetch;
    private boolean isSelect;
    private boolean isExecFunc;
    private boolean isExecFuncDone;
    private boolean isAppendDone;
    boolean debug = false;

    SQLUnit() {
        this.isFetch = false;
        this.isSelect = false;
        this.isExecFunc = false;
        this.isExecFuncDone = false;
        this.isAppendDone = false;
    }

    SQLUnit(Token token) {
        this.isSelect = token.kind == 21;
        this.isFetch = token.kind == 22 || this.isSelect;
        this.addToken(token.specialToken);
    }

    void addToken(Token token) {
        if (token != null) {
            this.addToken(token.specialToken);
            if (this.sqlStringBuffer.length() > 0) {
                String string = this.sqlStringBuffer.toString();
                this.sqlStringBuffer.append(token.image);
                this.javaCommentText.append(token.image);
                if (!this.isExecFuncDone && string.compareToIgnoreCase("EXECUTE FUNCTION") == 0) {
                    this.sqlStringBuffer.replace(0, 16, "SELECT");
                    this.isExecFunc = true;
                    this.isSelect = true;
                    this.isFetch = true;
                    this.isExecFuncDone = true;
                }
                if (string.indexOf(")") > 0 && this.isExecFunc && !this.isAppendDone) {
                    this.isAppendDone = true;
                    this.sqlStringBuffer.append(" FROM gbasedbt.systables WHERE tabid = 1 ");
                }
            } else if (token.kind != 8) {
                this.sqlStringBuffer.append(token.image);
                this.javaCommentText.append(token.image);
            }
        }
    }

    void addQuestionMark(Token token) {
        if (token != null) {
            this.addToken(token.specialToken);
        }
        this.sqlStringBuffer.append(" ? ");
        this.javaCommentText.append(":");
        this.markerList = null;
    }

    public void addSpace() {
        this.sqlStringBuffer.append(" ");
    }

    public void setSQL(String string) {
        this.sqlStringBuffer = new StringBuffer(string);
        this.markerList = null;
    }

    public String getSQL() {
        if (this.debug) {
            System.out.println("[" + this.sqlStringBuffer.toString() + "]");
            this.debug = false;
        }
        return this.sqlStringBuffer.toString();
    }

    void getTextTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.javaCommentText.toString());
    }

    void addBindExpr(BindExpr bindExpr) {
        this.bindList.addElement(bindExpr);
        if (bindExpr != null) {
            bindExpr.getTextTo(this.javaCommentText);
            bindExpr.setScope(this.scope);
        }
    }

    void addIntoBindExpr(Token token, IntoBindExpr intoBindExpr) {
        this.addToken(token.specialToken);
        this.addBindExpr(intoBindExpr);
        this.sqlStringBuffer.append(" ");
    }

    public void prependBindExpr(BindExpr bindExpr) {
        this.insertBindExprAt(bindExpr, 1);
    }

    public void insertBindExprAt(BindExpr bindExpr, int n2) {
        this.bindList.insertElementAt(bindExpr, n2 - 1);
        if (bindExpr != null) {
            bindExpr.setScope(this.scope);
        }
    }

    public Enumeration getBindExprs() {
        return this.bindList.elements();
    }

    public IntoBindExpr getIntoBindExpr() {
        Enumeration enumeration = this.getBindExprs();
        while (enumeration.hasMoreElements()) {
            BindExpr bindExpr = (BindExpr)enumeration.nextElement();
            if (!(bindExpr instanceof IntoBindExpr)) continue;
            return (IntoBindExpr)bindExpr;
        }
        return null;
    }

    public ReturnBindExpr getReturnBindExpr() {
        Enumeration enumeration = this.getBindExprs();
        while (enumeration.hasMoreElements()) {
            BindExpr bindExpr = (BindExpr)enumeration.nextElement();
            if (!(bindExpr instanceof ReturnBindExpr)) continue;
            return (ReturnBindExpr)bindExpr;
        }
        return null;
    }

    public int getNumActualBindExprs() {
        int n2 = 0;
        Enumeration enumeration = this.getBindExprs();
        while (enumeration.hasMoreElements()) {
            if (((BindExpr)enumeration.nextElement()).isVirtual()) continue;
            ++n2;
        }
        return n2;
    }

    public void setOperationType(int n2) {
        this.operType = n2;
    }

    public int getOperationType() {
        return this.operType;
    }

    public int getMarkerPosition(int n2) {
        if (this.markerList == null) {
            this.markerList = new Vector();
            SQLTokenizer sQLTokenizer = new SQLTokenizer(new ErrorLogger(), this.sqlStringBuffer.toString());
            while (sQLTokenizer.hasMoreElements()) {
                SQLToken sQLToken = (SQLToken)sQLTokenizer.nextElement();
                if (sQLToken.tokenType() != 3) continue;
                this.markerList.addElement(new Integer(sQLToken.tokenPosition()));
            }
        }
        try {
            return (Integer)this.markerList.elementAt(n2 - 1);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    Enumeration getTokenList() {
        throw new RuntimeException();
    }

    void setScope(Parselet parselet) {
        this.scope = parselet;
        Enumeration enumeration = this.getBindExprs();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e2 = enumeration.nextElement();
            if (e2 instanceof Parselet) {
                object = (Parselet)e2;
                object.setScope(this.scope);
                continue;
            }
            if (e2 instanceof Elem) {
                object = (Elem)e2;
                ((Elem)object).setScope(this.scope);
                continue;
            }
            if (e2 instanceof BindExpr) {
                object = (BindExpr)e2;
                ((BindExpr)object).setScope(this.scope);
                continue;
            }
            if (!(e2 instanceof SQLUnit)) continue;
            object = (SQLUnit)e2;
            ((SQLUnit)object).setScope(this.scope);
        }
    }

    public void setDescriptor(Object object) {
        this.descriptor = object;
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    boolean isFetchStatement() {
        return this.isFetch;
    }

    boolean isSelectStatement() {
        return this.isSelect;
    }
}

