/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.util.Enumeration;
import java.util.Hashtable;
import sqlj.framework.JSClass;
import sqlj.mesg.SemanticErrors;
import sqlj.semantics.ClassAnalysis;
import sqlj.semantics.SemanticAnalyzer;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.syntax.CursorElem;
import sqlj.syntax.Elem;
import sqlj.syntax.Type;
import sqlj.util.ClassDescriptor;
import sqlj.util.ClassNameResolver;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.Parselet;

class CursorAnalysis
extends ClassAnalysis
implements SemanticAnalyzer {
    private CursorElem cursor_elem;
    private static final String[] reservedMethods = new String[]{"next", "getResultSet", "isClosed", "close", "endFetch"};
    private static String SRRSI = "sqlj.runtime.ResultSetIterator";
    private static String SRRSIPref = SRRSI + ".";
    private static String RSI = "ResultSetIterator";
    private static String RSIPref = RSI + ".";
    private static String SENSITIVE = "SENSITIVE";
    private static String ASENSITIVE = "ASENSITIVE";
    private static String INSENSITIVE = "INSENSITIVE";

    CursorAnalysis(Elem elem, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        super(elem, semanticAnalyzerFactory);
        if (!(elem instanceof CursorElem)) {
            throw new IllegalArgumentException("CursorAnalysis(elem): not a CursorElem");
        }
        this.cursor_elem = (CursorElem)elem;
    }

    private boolean checkReservedMethods(String string) {
        for (int i2 = 0; i2 < reservedMethods.length; ++i2) {
            if (!reservedMethods[i2].equals(string)) continue;
            this.logError(SemanticErrors.badMethod(string));
            return true;
        }
        return false;
    }

    private boolean checkArgType(Type type, String string) {
        if (type == null) {
            this.logError(SemanticErrors.internalError("CursorAnalysis-0"));
            return true;
        }
        JSClass jSClass = null;
        try {
            jSClass = type.getClass(this.elem.getScope());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logError(SemanticErrors.notJavaCursorColumn(string, type.getName()));
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logError(SemanticErrors.internalError("CursorAnalysis-1"));
            return true;
        }
        if (!JSClass.ResultSet_TYPE.hasAccessTo(jSClass)) {
            this.logError(SemanticErrors.inaccessibleJavaTypeForColumn(this.saf.m_tp.printJavaType(jSClass), string));
        }
        if (jSClass.isPrimitive() && !this.saf.m_tp.isCursorColumnType(jSClass)) {
            this.logError(SemanticErrors.notValidCursorColumnType(string, this.saf.m_tp.printJavaType(jSClass)));
        } else if (this.saf.getPortable() && !this.saf.m_tp.isCursorColumnType(jSClass)) {
            this.logWarning(SemanticErrors.notJdbcCursorColumn(string, this.saf.m_tp.printJavaType(jSClass)));
        }
        return false;
    }

    private void checkWithClause() {
        Enumeration enumeration = this.cursor_elem.getWithKeywords();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            Parselet parselet = this.cursor_elem.getWithValue(string);
            ExpressionDescriptor expressionDescriptor = (ExpressionDescriptor)parselet.getDescriptor();
            JSClass jSClass = null;
            try {
                jSClass = expressionDescriptor.getReflection();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (string.equals("sensitivity")) {
                int n2;
                object = expressionDescriptor.getName();
                Object object2 = expressionDescriptor.getValue();
                if (object2 != null && object2 instanceof Integer && ((n2 = ((Integer)object2).intValue()) == 3 || n2 == 1 || n2 == 2) || object != null && (((String)object).equals(SENSITIVE) || ((String)object).equals(ASENSITIVE) || ((String)object).equals(INSENSITIVE) || ((String)object).equals(SRRSIPref + SENSITIVE) || ((String)object).equals(SRRSIPref + ASENSITIVE) || ((String)object).equals(SRRSIPref + INSENSITIVE))) continue;
                boolean bl = true;
                if (object != null && (((String)object).equals(RSIPref + SENSITIVE) || ((String)object).equals(RSIPref + ASENSITIVE) || ((String)object).equals(RSIPref + INSENSITIVE))) {
                    try {
                        ClassNameResolver classNameResolver = this.cursor_elem.getScope().getClassResolver();
                        if (classNameResolver.getClass(RSI).getName().equals(SRRSI)) {
                            bl = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl) continue;
                this.logError(SemanticErrors.invalidSensitivitySetting());
                continue;
            }
            if (string.equals("holdability") || string.equals("returnability")) {
                if (jSClass == JSClass.boolean_TYPE) continue;
                this.logError(SemanticErrors.invalidBooleanSetting(string));
                continue;
            }
            if (string.equals("updateColumns")) {
                if (jSClass != JSClass.String_TYPE) {
                    this.logError(SemanticErrors.updateColumnsNotString());
                }
                object = null;
                try {
                    object = ((ClassDescriptor)this.cursor_elem.getScope().getDescriptor()).getReflection();
                    if (JSClass.ForUpdate_TYPE.isAssignableFrom((JSClass)object)) continue;
                    this.logError(SemanticErrors.updateColumnsNotForUpdate());
                }
                catch (Exception exception) {
                    this.logError(SemanticErrors.internalError("CursorAnalysis-2"));
                }
                continue;
            }
            if (!this.saf.getPortable()) continue;
            this.logWarning(SemanticErrors.nonStandardAttribute(string));
        }
    }

    private void checkNames() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.cursor_elem.getColumnNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.checkReservedMethods(string);
            this.checkSQLJPrefix(string);
            String string2 = string.toUpperCase();
            if (hashtable.get(string2) != null) {
                String string3 = (String)hashtable.get(string2);
                if (string3.equals(string)) {
                    this.logError(SemanticErrors.dupMethod(string));
                } else {
                    this.logError(SemanticErrors.dupMethod(string3, string));
                }
            } else {
                hashtable.put(string2, string);
            }
            this.checkArgType(this.cursor_elem.getColumnType(string), string);
        }
    }

    private void checkPositions() {
        Enumeration enumeration = this.cursor_elem.getColumnTypes();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            this.checkArgType(type, String.valueOf(++n2));
        }
    }

    @Override
    public boolean prepare() {
        super.prepare();
        this.checkWithClause();
        if (this.cursor_elem.isByName()) {
            this.checkNames();
        } else {
            this.checkPositions();
        }
        return !this.unpreparable;
    }
}

