/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.lang.reflect.Modifier;
import java.util.Enumeration;
import sqlj.framework.JSClass;
import sqlj.mesg.SemanticErrors;
import sqlj.semantics.BaseAnalysis;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.syntax.ClassElem;
import sqlj.syntax.Elem;
import sqlj.util.ClassDescriptor;
import sqlj.util.ClassNameResolver;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.Parselet;

class ClassAnalysis
extends BaseAnalysis {
    private ClassElem class_elem;

    ClassAnalysis(Elem elem, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        super(elem, semanticAnalyzerFactory);
        this.class_elem = (ClassElem)elem;
    }

    private String getName() {
        try {
            return ((ClassDescriptor)this.class_elem.getScope().getDescriptor()).getReflection().getName();
        }
        catch (Exception exception) {
            return this.class_elem.getClassName();
        }
    }

    private boolean isInner() {
        return this.class_elem.getScope().getScope().getEnclosingClass() != null;
    }

    private void checkWithTypes() {
        Enumeration enumeration = this.class_elem.getWithKeywords();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Parselet parselet = this.class_elem.getWithValue(string);
            ExpressionDescriptor expressionDescriptor = (ExpressionDescriptor)parselet.getDescriptor();
            JSClass jSClass = null;
            try {
                jSClass = expressionDescriptor.getReflection();
            }
            catch (Exception exception) {
                this.logError("Unable to resolve type of WITH attribute " + string + ".");
            }
        }
    }

    private void checkInterfaces() {
        Enumeration enumeration = this.class_elem.getInterfaces();
        ClassNameResolver classNameResolver = this.class_elem.getScope().getClassResolver();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = false;
            try {
                if (classNameResolver.getClass(string).isInterface()) {
                    bl = true;
                } else {
                    string = classNameResolver.getClass(string).getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) continue;
            this.logError(SemanticErrors.notAnInterface(string));
        }
    }

    @Override
    public boolean prepare() {
        String string = this.class_elem.getClassName();
        this.checkSQLJClassPrefix(string);
        String string2 = this.getBaseName();
        int n2 = this.class_elem.getModifiers();
        boolean bl = this.isInner();
        if (Modifier.isAbstract(n2)) {
            this.logError(SemanticErrors.modifierNotAllowed("abstract"));
        }
        if (Modifier.isInterface(n2)) {
            this.logError(SemanticErrors.modifierNotAllowed("interface"));
        }
        if (Modifier.isNative(n2)) {
            this.logError(SemanticErrors.modifierNotAllowed("native"));
        }
        if (Modifier.isPrivate(n2) && !bl) {
            this.logError(SemanticErrors.innerClassModifier("private"));
        }
        if (Modifier.isPublic(n2) && !bl && string2 != null && !this.class_elem.getClassName().equals(string2)) {
            this.logError(SemanticErrors.fileNameForPublicDeclaration(this.class_elem.getClassName(), string2));
        }
        if (Modifier.isStatic(n2) && !bl) {
            this.logError(SemanticErrors.innerClassModifier("static"));
        }
        if (Modifier.isSynchronized(n2)) {
            this.logError(SemanticErrors.modifierNotAllowed("synchronized"));
        }
        if (Modifier.isTransient(n2)) {
            this.logError(SemanticErrors.modifierNotAllowed("transient"));
        }
        if (Modifier.isVolatile(n2)) {
            this.logError(SemanticErrors.modifierNotAllowed("volatile"));
        }
        this.checkWithTypes();
        this.checkInterfaces();
        return !this.unpreparable;
    }
}

