/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import sqlj.framework.JSClass;
import sqlj.javac.ExpressionNode;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.NameNode;
import sqlj.javac.SimpleNameNode;
import sqlj.javac.Token;

class FieldAccessExpression
extends NameNode {
    private ExpressionNode baseObject;
    private String fieldName;
    private String text;
    private JSClass type;

    FieldAccessExpression(JavaParserImpl javaParserImpl, ExpressionNode expressionNode, Token token, SimpleNameNode simpleNameNode) {
        super(javaParserImpl);
        this.baseObject = expressionNode;
        this.fieldName = simpleNameNode.getText();
        StringBuffer stringBuffer = new StringBuffer();
        token.getTextTo(stringBuffer);
        simpleNameNode.getTextTo(stringBuffer);
        this.text = stringBuffer.toString();
    }

    @Override
    int getRow() {
        return this.baseObject.getRow();
    }

    @Override
    int getColumn() {
        return this.baseObject.getColumn();
    }

    @Override
    ExpressionNode getBaseObject() {
        return this.baseObject;
    }

    @Override
    String getText() {
        return this.fieldName;
    }

    @Override
    public final void getTextTo(StringBuffer stringBuffer) {
        this.baseObject.getTextTo(stringBuffer);
        stringBuffer.append(this.text);
    }

    @Override
    void scopeChanged() {
        this.baseObject.setScope(this.getScope());
    }

    @Override
    JSClass getType() {
        if (this.type == null && (this.type = this.baseObject.lookupField(this.getText())) == null) {
            this.Error(36, this.getText());
        }
        return this.type;
    }

    @Override
    boolean isLeftHandSide() {
        return true;
    }

    @Override
    boolean isFinal() {
        boolean bl;
        try {
            bl = (this.baseObject.getField(this.getText()).getModifiers() & 0x10) != 0;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }
}

