/*
 * Decompiled with CFR 0.152.
 */
package sqlj.framework.ide;

import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.error.LogEntry;
import sqlj.framework.error.Position;
import sqlj.framework.error.Warning;
import sqlj.framework.ide.TranslationLog;

public class TranslationLogWrapper
implements ErrorLog {
    private int m_numWarnings = 0;
    private int m_numErrors = 0;
    private String m_filename = null;
    private TranslationLog m_log;

    public TranslationLogWrapper(TranslationLog translationLog) {
        this.m_log = translationLog;
    }

    @Override
    public void addEntry(LogEntry logEntry) {
        logEntry.setFileName(this.m_filename);
        Position position = logEntry.getPosition();
        if (position == null) {
            position = new Position();
        }
        if (logEntry instanceof JSError) {
            this.incErrorCount();
            this.m_log.logError(logEntry.getMessage(), position.startLine(), position.startCol(), position.endLine(), position.endCol());
        } else if (logEntry instanceof Warning) {
            this.incWarningCount();
            this.m_log.logWarning(logEntry.getMessage(), position.startLine(), position.startCol(), position.endLine(), position.endCol());
        } else if (logEntry instanceof Info) {
            this.m_log.logInfo(logEntry.getMessage(), position.startLine(), position.startCol(), position.endLine(), position.endCol());
        }
    }

    @Override
    public void addEntry(LogEntry logEntry, int n2, int n3) {
        logEntry.setPosition(new Position(n2, n3));
        this.addEntry(logEntry);
    }

    @Override
    public void addEntryRegion(LogEntry logEntry, int n2, int n3, int n4, int n5) {
        logEntry.setRegion(n2, n3, n4, n5);
        this.addEntry(logEntry);
    }

    @Override
    public int errorCount() {
        return this.m_numErrors;
    }

    @Override
    public void incErrorCount() {
        ++this.m_numErrors;
    }

    @Override
    public int warningCount() {
        return this.m_numWarnings;
    }

    @Override
    public void incWarningCount() {
        ++this.m_numWarnings;
    }

    @Override
    public void setFileName(String string) {
        this.m_filename = string;
    }

    @Override
    public String getFileName() {
        return this.m_filename;
    }

    @Override
    public Position getDefaultRegion() {
        return null;
    }
}

