/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.util.Hashtable;
import sqlj.codegen.JSClassType;
import sqlj.codegen.ProfileDecl;
import sqlj.codegen.ProfileKeysJSClass;
import sqlj.codegen.Util;
import sqlj.codegen.engine.AssignmentStatement;
import sqlj.codegen.engine.BaseMethodDecl;
import sqlj.codegen.engine.ClassDecl;
import sqlj.codegen.engine.Expression;
import sqlj.codegen.engine.FieldDecl;
import sqlj.codegen.engine.IfStatement;
import sqlj.codegen.engine.Initializer;
import sqlj.codegen.engine.Modifiers;
import sqlj.codegen.engine.NewArray;
import sqlj.codegen.engine.ObjectExpression;
import sqlj.codegen.engine.ObjectStatement;
import sqlj.codegen.engine.StatementBlock;
import sqlj.codegen.engine.StatementGroup;
import sqlj.codegen.engine.Type;
import sqlj.framework.JSClass;
import sqlj.util.Parselet;

class ProfileKeysDecl
extends ClassDecl {
    private static final String LOADER = "loader";
    private static final String INST = "inst";
    private static final String KEYS = "keys";
    private static final String KEY_NUM = "keyNum";
    static final String GET_KEY = "getKey";
    private static final String PROFILE_SUFFIX = Util.newClassName("Profile");
    private static final String PROFILE_KEYS_SUFFIX = PROFILE_SUFFIX + "Keys";
    private JSClassType.Factory m_typeFactory;
    private NewArray m_keyInit;
    private StatementGroup m_keyAssign;
    private Type m_classType;
    private String m_baseClassName;
    private String m_classQualifier;
    private Hashtable m_profiles = new Hashtable();
    private int m_keyNum = 0;
    private String m_sourceFile;

    public ProfileKeysDecl(String string, String string2, Parselet parselet, String string3) {
        this.m_typeFactory = new JSClassType.Factory.ElemFactory(parselet);
        this.m_baseClassName = string2;
        this.m_classQualifier = string;
        this.m_sourceFile = string3;
        this.name(string2 + PROFILE_KEYS_SUFFIX);
        ProfileKeysJSClass profileKeysJSClass = new ProfileKeysJSClass(string + string2 + PROFILE_KEYS_SUFFIX, parselet);
        this.m_classType = this.m_typeFactory.getType(profileKeysJSClass);
        FieldDecl fieldDecl = new FieldDecl();
        fieldDecl.modifiers(Modifiers.STATIC_PRIVATE);
        fieldDecl.name(INST);
        fieldDecl.type(this.m_classType);
        fieldDecl.initializer(Initializer.NULL);
        this.addBodyDecl(fieldDecl);
        this.addGetKeyMethod();
        FieldDecl fieldDecl2 = new FieldDecl();
        fieldDecl2.modifiers(Modifiers.PRIVATE_FINAL);
        fieldDecl2.name(LOADER);
        fieldDecl2.type(JSClassType.Loader_TYPE);
        fieldDecl2.initializer(new Initializer(new ObjectExpression(JSClassType.RuntimeContext_TYPE.name() + ".getRuntime().getLoaderForClass(getClass())")));
        this.addBodyDecl(fieldDecl2);
        FieldDecl fieldDecl3 = new FieldDecl();
        fieldDecl3.modifiers(Modifiers.PRIVATE);
        fieldDecl3.name(KEYS);
        fieldDecl3.type(JSClassType.ObjectArr_TYPE);
        this.addBodyDecl(fieldDecl3);
        this.addConstructor();
    }

    private void addGetKeyMethod() {
        BaseMethodDecl baseMethodDecl = new BaseMethodDecl(false);
        baseMethodDecl.modifiers(Modifiers.STATIC_PUBLIC);
        baseMethodDecl.name(GET_KEY);
        baseMethodDecl.type(JSClassType.Object_TYPE);
        baseMethodDecl.addException(JSClassType.SQLException_TYPE.name());
        baseMethodDecl.addParameter(JSClassType.int_TYPE, KEY_NUM);
        ObjectExpression objectExpression = new ObjectExpression("inst == null");
        StatementBlock statementBlock = new StatementBlock();
        statementBlock.addStatement(new ObjectStatement("inst = new " + this.m_classType.name() + "();"));
        baseMethodDecl.addStatement(new IfStatement(objectExpression, statementBlock));
        baseMethodDecl.addStatement(new ObjectStatement("return inst.keys[keyNum];"));
        this.addBodyDecl(baseMethodDecl);
    }

    private void addConstructor() {
        BaseMethodDecl baseMethodDecl = new BaseMethodDecl(false);
        baseMethodDecl.modifiers(Modifiers.PRIVATE);
        baseMethodDecl.addException(JSClassType.SQLException_TYPE.name());
        this.m_keyInit = new NewArray(JSClassType.Object_TYPE);
        baseMethodDecl.addStatement(new AssignmentStatement(new ObjectExpression(KEYS), this.m_keyInit));
        this.m_keyAssign = new StatementGroup();
        baseMethodDecl.addStatement(this.m_keyAssign);
        this.addConstructor(baseMethodDecl);
    }

    public boolean hasProfile(JSClassType jSClassType) {
        return this.m_profiles.containsKey(jSClassType.toClass().getName());
    }

    public ProfileDecl getProfileDecl(JSClassType jSClassType) {
        return this.getProfileEntry((JSClassType)jSClassType).m_decl;
    }

    public Expression getProfileKey(JSClassType jSClassType) {
        return this.getProfileEntry((JSClassType)jSClassType).m_key;
    }

    public Entry getProfileEntry(JSClassType jSClassType) {
        JSClass jSClass = jSClassType.toClass();
        Entry entry = (Entry)this.m_profiles.get(jSClass.getName());
        if (entry == null) {
            String string = this.m_baseClassName + PROFILE_SUFFIX + this.m_keyNum;
            String string2 = this.m_classQualifier + string;
            jSClassType = this.m_typeFactory.getType(jSClassType);
            ProfileDecl profileDecl = new ProfileDecl(this.m_classQualifier, string, jSClassType, this.m_sourceFile);
            this.m_keyInit.incrementSize();
            this.m_keyAssign.addStatement(new AssignmentStatement(new ObjectExpression("keys[" + this.m_keyNum + "]"), new ObjectExpression(jSClassType.name() + "." + "getProfileKey" + "(" + LOADER + ", " + Util.stringify(string2) + ")")));
            ObjectExpression objectExpression = new ObjectExpression(this.m_classType.name() + "." + GET_KEY + "(" + this.m_keyNum + ")");
            entry = new Entry(profileDecl, objectExpression);
            this.m_profiles.put(jSClass.getName(), entry);
            ++this.m_keyNum;
        }
        return entry;
    }

    private static class Entry {
        public ProfileDecl m_decl;
        public Expression m_key;

        public Entry(ProfileDecl profileDecl, Expression expression) {
            this.m_decl = profileDecl;
            this.m_key = expression;
        }
    }
}

