/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.util;

import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.TraceOS;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class Trace {
    private final int DEF_TRACE_LEVEL = 0;
    private final int HEX_SIZE = 22;
    private final int HEX_ASCII_SIZE = 16;
    private int traceLevel = 0;
    private String traceFile = null;
    private TraceOS dataOS;

    public Trace() {
        this.traceLevel = 0;
        this.traceFile = null;
    }

    public void resetTrace() {
        this.closeTraceFile();
        this.traceFile = null;
        this.traceLevel = 0;
    }

    public Trace(int n2, String string) {
        if (n2 == 0) {
            return;
        }
        if (string == null) {
            this.traceLevel = 0;
            System.err.println("Trace file is null, setting trace level to 0");
            return;
        }
        try {
            this.dataOS = new TraceOS(new PrintWriter((Writer)new BufferedWriter(new FileWriter(string, true)), true));
        }
        catch (Exception exception) {
            System.err.println("Cannot Open FileOutputStream for Trace" + exception.toString());
            System.err.println("No Tracing will be done");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (this.dataOS.checkError()) {
            this.resetTrace();
        } else {
            this.traceLevel = n2;
            this.traceFile = string;
        }
    }

    public void setTraceLevel(int n2) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        this.traceLevel = n2;
    }

    public synchronized void setNewTraceFile(int n2, String string) {
        this.closeTraceFile();
        if (n2 == 0) {
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (string == null) {
            System.err.println("Filename is null, resetting Trace\n");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        try {
            this.dataOS = new TraceOS(new PrintWriter((Writer)new BufferedWriter(new FileWriter(string, true)), true));
        }
        catch (Exception exception) {
            System.err.println("Cannot reOpen FileOutputStream for Trace" + exception.toString());
            System.err.println("No Tracing will be done");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (this.dataOS.checkError()) {
            this.resetTrace();
        } else {
            this.traceLevel = n2;
            this.traceFile = string;
        }
    }

    public String getTraceFile() {
        if (TraceFlag.compiletrace) {
            return this.traceFile;
        }
        return null;
    }

    public int getTraceLevel() {
        if (TraceFlag.compiletrace) {
            return this.traceLevel;
        }
        return 0;
    }

    public synchronized void setTraceOS(TraceOS traceOS) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.dataOS != null && !this.dataOS.equals(traceOS)) {
            this.closeTraceFile();
        }
        this.dataOS = traceOS;
    }

    public TraceOS getTraceOS() {
        if (TraceFlag.compiletrace) {
            return this.dataOS;
        }
        return null;
    }

    public void closeTraceFile() {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.flush();
            this.dataOS.close();
        }
    }

    public void writeTrace(int n2, String string) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n2) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(string);
        }
    }

    public void writeTrace(int n2, String string, String string2) {
        this.writeTrace(n2, string + string2);
    }

    public void writeTrace(int n2, String string, int n3) {
        this.writeTrace(n2, string + n3);
    }

    public void writeTrace(int n2, int n3) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n2) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(n3);
        }
    }

    public void writeTrace(int n2, String string, short s2) {
        this.writeTrace(n2, string + s2);
    }

    public void writeTrace(int n2, short s2) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n2) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(s2);
        }
    }

    public void writeTrace(int n2, String string, double d2) {
        this.writeTrace(n2, string + d2);
    }

    public void writeTrace(int n2, double d2) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n2) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(d2);
        }
    }

    public void writeTrace(int n2, String string, float f2) {
        this.writeTrace(n2, string + f2);
    }

    public void writeTrace(int n2, float f2) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n2) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(f2);
        }
    }

    public void writeTrace(int n2, String string, long l2) {
        this.writeTrace(n2, string + l2);
    }

    public void writeTrace(int n2, long l2) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n2) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(l2);
        }
    }

    public void writeTrace(int n2, String string, boolean bl) {
        this.writeTrace(n2, string + bl);
    }

    public void writeTrace(int n2, boolean bl) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n2) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(bl);
        }
    }

    public void writeTrace(int n2, byte[] byArray, char c2) {
        this.writeTrace(n2, byArray, c2, byArray.length);
    }

    public void writeTrace(int n2, byte[] byArray, char c2, int n3) {
        this.writeTrace(n2, byArray, 0, c2, n3);
    }

    public void writeTrace(int n2, byte[] byArray, int n3, char c2, int n4) {
        int n5 = 0;
        boolean bl = true;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        int n6 = 22;
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n2) {
            return;
        }
        if (c2 == 'b' || c2 == 'B') {
            bl = false;
            n6 = 16;
            stringBuffer = new StringBuffer(n6);
        }
        stringBuffer2 = new StringBuffer(n6 * 4);
        try {
            if (bl) {
                this.dataOS.println("=================================-========================================");
                this.dataOS.println("Index:   Hex:");
            } else {
                this.dataOS.println("========================================================      ================");
                this.dataOS.println("Index:   Hex:                                                 Ascii:\n");
            }
            if (this.dataOS == null) {
                this.dataOS.println("   ***** NULL data *****  ");
                return;
            }
            int n7 = 0;
            while (n7 < n4) {
                Byte by = new Byte(byArray[n7 + n3]);
                int n8 = by.intValue();
                if (n5 == 0) {
                    stringBuffer2.append("0x");
                    if (n7 < 16) {
                        stringBuffer2.append("000");
                    } else if (n7 < 256) {
                        stringBuffer2.append("00");
                    } else if (n7 < 4096) {
                        stringBuffer2.append("0");
                    }
                    stringBuffer2.append(Integer.toHexString(n7));
                    stringBuffer2.append(":  ");
                }
                if ((n8 &= 0xFF) < 16) {
                    stringBuffer2.append("0");
                }
                stringBuffer2.append(Integer.toHexString(n8));
                stringBuffer2.append(" ");
                if (!bl) {
                    if ((n8 &= 0xFF) >= 32 && n8 <= 126) {
                        Character c3 = new Character((char)n8);
                        stringBuffer.append(c3.toString());
                    } else {
                        stringBuffer.append(".");
                    }
                }
                if (n5 == n6 - 1) {
                    this.dataOS.print(stringBuffer2.toString());
                    stringBuffer2 = new StringBuffer(n6 * 4);
                    if (!bl) {
                        this.dataOS.print("     ");
                        this.dataOS.print(stringBuffer.toString());
                        stringBuffer = new StringBuffer(n6);
                    }
                    this.dataOS.println("");
                    n5 = -1;
                }
                ++n7;
                ++n5;
            }
            if (n5 > -1) {
                this.dataOS.print(stringBuffer2.toString());
                if (!bl) {
                    while (n5 < n6) {
                        this.dataOS.print("   ");
                        ++n5;
                    }
                    this.dataOS.print("     ");
                    this.dataOS.print(stringBuffer.toString());
                }
            }
            this.dataOS.println("");
            if (bl) {
                this.dataOS.println("==========================================================================");
            } else {
                this.dataOS.println("==============================================================================");
            }
            this.dataOS.println("");
        }
        catch (Exception exception) {
            System.out.println("Exception in writeTrace...");
            System.out.println("Trying to create a Table ...\n");
        }
    }
}

