/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.csm;

import com.gbasedbt.csm.IfxCSSException;
import com.gbasedbt.csm.IfxCsm;
import com.gbasedbt.csm.IfxCsmBuffer;
import com.gbasedbt.csm.IfxCsmDescriptor;
import com.gbasedbt.csm.IfxCsmException;
import com.gbasedbt.csm.IfxCsmReadBuffer;
import com.gbasedbt.csm.IfxCssInputStream;
import com.gbasedbt.csm.IfxCssOutputStream;
import com.gbasedbt.util.IfxErrMsg;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class IfxCsmContext {
    public static int CSM_SERVER = 262144;
    static int CSS_REQUEST_PENDING = 0;
    static int CSS_REQUEST_POSTED = 1;
    static int CSS_CSM_HAS_DATA = 0;
    static int CSS_CSM_NO_DATA = 1;
    static int CSS_CSM_FREE = 0;
    static int CSS_CSM_IN_USE = 1;
    static int CSS_CSM_DONE = 0;
    static int CSS_CSM_CALL = 1;
    IfxCsm.Status status;
    IfxCsm csm;
    IfxCsm.Credentials cred;
    IfxCsmDescriptor desc;
    String locale;
    int state_out = CSS_CSM_NO_DATA;
    int state_in = CSS_CSM_FREE;
    int state_obj = CSS_CSM_DONE;
    IfxCsmReadBuffer inHandShake;
    IfxCsmBuffer outHandShake;

    int createContext(IfxCsm.Credentials credentials) throws IfxCSSException {
        int n2 = CSS_REQUEST_PENDING;
        int n3 = 0;
        IfxCsm.Status status = new IfxCsm.Status();
        while ((n3 = this.csm.ifxCsmCreateContext(credentials, this.inHandShake, this.outHandShake, this.desc.getInitString(), status)) == 0) {
            this.setState(status);
            if (this.state_out != CSS_CSM_HAS_DATA) {
                if (this.state_obj == CSS_CSM_DONE) break;
                if (n2 == CSS_REQUEST_PENDING) {
                    throw IfxErrMsg.getLocIfxCSSException(-14513, this.locale);
                }
            }
            if (this.state_out == CSS_CSM_HAS_DATA) {
                this.putBytes(this.outHandShake.toByteArray());
                this.outHandShake.reset();
                n2 = CSS_REQUEST_POSTED;
            }
            if (this.state_in == CSS_CSM_IN_USE) continue;
            this.inHandShake = null;
            this.inHandShake = this.getBytes();
        }
        return n3;
    }

    private void putBytes(byte[] byArray) throws IfxCSSException {
        try {
            this.desc.getOutputStream().write(byArray);
            this.desc.getOutputStream().flush();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getLocIfxCSSException(-14563, this.locale);
        }
    }

    private IfxCsmReadBuffer getBytes() throws IfxCSSException {
        IfxCsmBuffer ifxCsmBuffer = new IfxCsmBuffer();
        byte[] byArray = new byte[4096];
        int n2 = -1;
        try {
            n2 = this.desc.getInputStream().read(byArray);
            if (n2 != -1) {
                ifxCsmBuffer.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getLocIfxCSSException(-14565, this.locale);
        }
        return new IfxCsmReadBuffer(ifxCsmBuffer);
    }

    private void setState(IfxCsm.Status status) {
        long l2 = status.getCsmCode();
        if (l2 == 1L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_DONE;
        } else if (l2 == 2L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_DONE;
        } else if (l2 == 3L) {
            this.state_out = CSS_CSM_HAS_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_CALL;
        } else if (l2 == 4L) {
            this.state_out = CSS_CSM_HAS_DATA;
            this.state_in = CSS_CSM_IN_USE;
            this.state_obj = CSS_CSM_CALL;
        } else if (l2 == 5L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_CALL;
        }
    }

    public IfxCsmContext(IfxCsmDescriptor ifxCsmDescriptor, String string) throws IfxCSSException {
        this.desc = ifxCsmDescriptor;
        this.locale = string;
        this.status = new IfxCsm.Status();
        this.outHandShake = new IfxCsmBuffer();
        this.csm = this.createCsmObject();
    }

    private IfxCsm createCsmObject() throws IfxCSSException {
        IfxCsm ifxCsm = null;
        Class<?> clazz = null;
        this.desc.setLoadState(0);
        try {
            Class<?> clazz2 = Class.forName("com.gbasedbt.csm.IfxCsm");
            clazz = Class.forName(this.desc.getClassName());
            if (!clazz2.isAssignableFrom(clazz)) {
                this.desc.setLoadState(2);
                throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n", this.locale);
            }
            Class[] classArray = new Class[]{this.desc.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.desc};
            ifxCsm = (IfxCsm)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + classNotFoundException.toString(), this.locale);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + illegalAccessException.toString(), this.locale);
        }
        catch (InstantiationException instantiationException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + instantiationException.toString(), this.locale);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + noSuchMethodException.toString(), this.locale);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + invocationTargetException.toString(), this.locale);
        }
        this.desc.setLoadState(1);
        return ifxCsm;
    }

    public void init() throws IfxCSSException {
        try {
            this.csm.ifxCsmInit(this.desc.getInitString(), 0L, this.status);
        }
        catch (IfxCsmException ifxCsmException) {
            this.desc.setLoadState(this.status.csmErr);
            throw ifxCsmException;
        }
    }

    public IfxCsm.Status getStatus() {
        return this.status;
    }

    public FilterInputStream getInputStream() {
        return new IfxCssInputStream(this.desc.getInputStream(), this.csm);
    }

    public FilterOutputStream getOutputStream() {
        return new IfxCssOutputStream(this.desc.getOutputStream(), this.csm);
    }
}

