/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.common.utils.CheckUtils;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.anno.TransDefaultSett;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.TransPojo;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.ds.DataSourceSetter;
import com.fhs.trans.listener.TransMessageListener;
import com.fhs.trans.service.impl.ITransTypeService;
import com.fhs.trans.service.impl.SimpleTrans;
import com.fhs.trans.service.impl.TransService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class SimpleTransService
implements ITransTypeService,
InitializingBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(SimpleTransService.class);
    private ThreadLocal<Map<String, Map<String, Object>>> threadLocalCache = new ThreadLocal();
    protected SimpleTransDiver transDiver;
    protected DataSourceSetter dataSourceSetter;
    protected Map<String, TransCacheSett> transCacheSettMap = new HashMap<String, TransCacheSett>();

    public void regsiterTransDiver(SimpleTransDiver transDiver) {
        this.transDiver = transDiver;
    }

    @Override
    public void transOne(VO obj, List<Field> toTransList) {
        SimpleTrans tempTrans = null;
        for (Field tempField : toTransList) {
            Map transMap;
            tempTrans = new SimpleTrans(tempField.getAnnotation(Trans.class));
            String alias = tempTrans.alias();
            String pkey = ConverterUtils.toString(ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
            if (StringUtils.isEmpty((Object)pkey)) continue;
            HashMap transCache = null;
            pkey = pkey.replace("[", "").replace("]", "");
            Map<String, Object> tempTransCache = null;
            boolean isMany = false;
            Object targetObject = null;
            if (pkey.contains(",")) {
                isMany = true;
                String[] pkeys = pkey.split(",");
                transCache = new LinkedHashMap();
                for (String tempPkey : pkeys) {
                    tempTransCache = this.getTempTransCacheMap(tempTrans, tempPkey);
                    if (tempTransCache == null || tempTransCache.isEmpty()) {
                        LOGGER.warn(this.getClass().getName() + "\u7ffb\u8bd1\u672a\u547d\u4e2d\u6570\u636e:" + tempTrans.target().getName() + "_" + tempPkey);
                        continue;
                    }
                    tempTransCache.remove("targetObject");
                    for (String key : tempTransCache.keySet()) {
                        transCache.put(key, transCache.containsKey(key) ? (String)transCache.get(key) + "," + tempTransCache.get(key) : StringUtil.toString(tempTransCache.get(key)));
                    }
                }
            } else {
                transCache = new LinkedHashMap(1);
                tempTransCache = this.getTempTransCacheMap(tempTrans, ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
                if (tempTransCache == null || tempTransCache.isEmpty()) {
                    LOGGER.warn(this.getClass().getName() + "\u7ffb\u8bd1\u672a\u547d\u4e2d\u6570\u636e:" + tempTrans.target().getName() + "_" + ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
                    continue;
                }
                LinkedHashMap finalTransCache = transCache;
                for (Map.Entry entry : tempTransCache.entrySet()) {
                    if (!"targetObject".equals(entry.getKey())) {
                        finalTransCache.put(entry.getKey(), StringUtil.toString(entry.getValue()));
                        continue;
                    }
                    targetObject = entry.getValue();
                }
            }
            if (tempTransCache != null) {
                this.setRef(tempTrans, obj, transCache, targetObject);
            }
            if ((transMap = obj.getTransMap()) == null) continue;
            if (!CheckUtils.isNullOrEmpty(alias)) {
                HashMap tempMap = new HashMap();
                Set set = transCache.keySet();
                for (String key : set) {
                    tempMap.put(alias + key.substring(0, 1).toUpperCase() + key.substring(1), transCache.get(key));
                }
                transCache = tempMap;
            }
            Set keys = transCache.keySet();
            for (String key : keys) {
                if (!CheckUtils.isNullOrEmpty(transMap.get(key))) continue;
                transMap.put(key, transCache.get(key));
            }
        }
    }

    @Override
    public void transMore(List<? extends VO> objList, List<Field> toTransList) {
        Set<String> targetFields;
        this.threadLocalCache.set(new HashMap());
        HashMap namespaceFieldsGroupMap = new HashMap();
        HashMap<String, Set<String>> namespaceTargetFieldsGroupMap = new HashMap<String, Set<String>>();
        for (Field tempField : toTransList) {
            tempField.setAccessible(true);
            Trans tempTrans = tempField.getAnnotation(Trans.class);
            String targetClassName = this.getTargetClassName(tempTrans);
            List<Field> fields = namespaceFieldsGroupMap.containsKey(targetClassName) ? (List)namespaceFieldsGroupMap.get(targetClassName) : new ArrayList();
            targetFields = namespaceTargetFieldsGroupMap.containsKey(targetClassName) ? (Set)namespaceTargetFieldsGroupMap.get(targetClassName) : new HashSet();
            targetFields.addAll(Arrays.asList(tempTrans.fields()));
            fields.add(tempField);
            namespaceFieldsGroupMap.put(targetClassName, fields);
            namespaceTargetFieldsGroupMap.put(targetClassName, targetFields);
        }
        for (String target : namespaceFieldsGroupMap.keySet()) {
            List fields = (List)namespaceFieldsGroupMap.get(target);
            SimpleTrans tempTrans = new SimpleTrans(((Field)fields.get(0)).getAnnotation(Trans.class));
            HashSet<Object> ids = new HashSet<Object>();
            targetFields = (Set)namespaceTargetFieldsGroupMap.get(target);
            targetFields.addAll(this.getTargetDefaultFields(tempTrans));
            objList.forEach(obj -> {
                for (Field field : fields) {
                    try {
                        Object tempId = field.get(obj);
                        if (!CheckUtils.isNotEmpty(tempId)) continue;
                        String pkey = ConverterUtils.toString(tempId).replace("[", "").replace("]", "");
                        if (pkey.contains(",")) {
                            String[] pkeys;
                            for (String id : pkeys = pkey.split(",")) {
                                ids.add(id);
                            }
                            continue;
                        }
                        ids.add(tempId);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (ids.isEmpty()) continue;
            if (this.transCacheSettMap.containsKey(this.getTargetClassName(tempTrans))) {
                targetFields = null;
                Set<Object> newIds = this.initLocalFromGlobalCache(this.threadLocalCache, ids, this.getTargetClassName(tempTrans), this.getClass() == SimpleTransService.class ? "simple" : "rpc");
                ids.clear();
                ids.addAll(newIds);
            }
            if (ids.isEmpty()) continue;
            List<? extends VO> dbDatas = this.findByIds(new ArrayList(ids), tempTrans, targetFields);
            for (VO vO : dbDatas) {
                this.threadLocalCache.get().put(this.getTargetClassName(tempTrans) + "_" + this.getUniqueKey(vO, tempTrans), this.createTempTransCacheMap(vO, tempTrans, targetFields));
            }
        }
        objList.forEach(obj -> this.transOne((VO)obj, toTransList));
        this.threadLocalCache.set(null);
    }

    private List<String> getTargetDefaultFields(Trans tempTrans) {
        if (tempTrans.target() != TransPojo.class && !this.transCacheSettMap.containsKey(tempTrans.target()) && tempTrans.target().isAnnotationPresent(TransDefaultSett.class)) {
            TransDefaultSett transDefaultSett = tempTrans.target().getAnnotation(TransDefaultSett.class);
            return Arrays.asList(transDefaultSett.defaultFields());
        }
        return new ArrayList<String>();
    }

    public Object getUniqueKey(VO vo, Trans tempTrans) {
        if (StringUtils.isEmpty((Object)tempTrans.uniqueField())) {
            return vo.getPkey();
        }
        return ReflectUtils.getValue((Object)vo, (String)tempTrans.uniqueField());
    }

    public List<? extends VO> findByIds(List ids, Trans tempTrans, Set<String> targetFields) {
        return this.findByIds(() -> this.transDiver.findByIds(ids, tempTrans.target(), tempTrans.uniqueField()), tempTrans.dataSource());
    }

    public VO findById(Object id, Trans tempTrans) {
        return this.findById(() -> {
            HashSet<String> fields = new HashSet<String>(Arrays.asList(tempTrans.fields()));
            if (this.transCacheSettMap.containsKey(this.getTargetClassName(tempTrans))) {
                fields = null;
            }
            return this.transDiver.findById((Serializable)id, tempTrans.target(), tempTrans.uniqueField(), fields);
        }, tempTrans.dataSource());
    }

    private Map<String, Object> getTempTransCacheMap(Trans tempTrans, Object pkey) {
        String className = this.getTargetClassName(tempTrans);
        String transType = this.getClass() == SimpleTransService.class ? "simple" : "rpc";
        Map<String, Object> voCacheMap = this.getFromGlobalCache(pkey, className, transType);
        if (this.transCacheSettMap.containsKey(className) && voCacheMap != null) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            for (String field : tempTrans.fields()) {
                resultMap.put(field, voCacheMap.get(field));
            }
            return resultMap;
        }
        if (this.threadLocalCache.get() == null) {
            if (CheckUtils.isNullOrEmpty(pkey)) {
                return new HashMap<String, Object>();
            }
            VO vo = this.findById(pkey, tempTrans);
            return this.createTempTransCacheMap(vo, tempTrans, null);
        }
        voCacheMap = this.threadLocalCache.get().get(this.getTargetClassName(tempTrans) + "_" + pkey);
        if (voCacheMap == null) {
            return null;
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        for (String field : tempTrans.fields()) {
            resultMap.put(field, voCacheMap.get(field));
        }
        return resultMap;
    }

    protected String getTargetClassName(Trans tempTrans) {
        TransDefaultSett transDefaultSett;
        if (tempTrans.target() != TransPojo.class && !this.transCacheSettMap.containsKey(tempTrans.target()) && tempTrans.target().isAnnotationPresent(TransDefaultSett.class) && (transDefaultSett = tempTrans.target().getAnnotation(TransDefaultSett.class)).isUseCache()) {
            TransCacheSett cacheSett = new TransCacheSett();
            cacheSett.setMaxCache(transDefaultSett.maxCache());
            cacheSett.setCacheSeconds(transDefaultSett.cacheSeconds());
            cacheSett.setAccess(transDefaultSett.isAccess());
            this.transCacheSettMap.put(tempTrans.target().getName(), cacheSett);
        }
        return tempTrans.target() == TransPojo.class ? tempTrans.targetClassName() : tempTrans.target().getName();
    }

    protected Map<String, Object> createTempTransCacheMap(VO po, Trans trans, Set<String> targetFields) {
        String fielVal = null;
        LinkedHashMap<String, Object> tempCacheTransMap = new LinkedHashMap<String, Object>();
        if (po == null) {
            return tempCacheTransMap;
        }
        List<String> tempFields = targetFields != null ? new ArrayList<String>(targetFields) : Arrays.asList(trans.fields());
        for (String field : tempFields) {
            fielVal = ConverterUtils.toString(ReflectUtils.getValue((Object)po, (String)field));
            tempCacheTransMap.put(field, fielVal);
        }
        tempCacheTransMap.put("targetObject", po);
        String className = this.getTargetClassName(trans);
        if (this.transCacheSettMap.get(className) != null) {
            TransCacheSett cacheSett = this.transCacheSettMap.get(className);
            LinkedHashMap<String, Object> voCacheMap = new LinkedHashMap<String, Object>();
            List fields = ReflectUtils.getAllField(po.getClass());
            for (Field field : fields) {
                voCacheMap.put(field.getName(), ReflectUtils.getValue((Object)po, (String)field.getName()));
            }
            voCacheMap.put("targetObject", po);
            this.put2GlobalCache(voCacheMap, cacheSett.isAccess(), cacheSett.getCacheSeconds(), cacheSett.getMaxCache(), po.getPkey(), className, this.getClass() == SimpleTransService.class ? "simple" : "rpc");
        }
        return tempCacheTransMap;
    }

    public void onMessage(Map<String, Object> messageMap) {
        String messageType;
        switch (messageType = ConverterUtils.toString(messageMap.get("messageType"))) {
            case "clear": {
                this.clearGlobalCache(ConverterUtils.toString(messageMap.get("pkey")), ConverterUtils.toString(messageMap.get("target")), ConverterUtils.toString(messageMap.get("transType")));
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        TransService.registerTransType("simple", this);
        TransMessageListener.regTransRefresher("simple", this::onMessage);
    }

    public void setTransCache(Object type, TransCacheSett cacheSett) {
        Class typeClass = (Class)type;
        this.transCacheSettMap.put(typeClass.getName(), cacheSett);
    }

    public static class TransCacheSett {
        private boolean isAccess = false;
        private long cacheSeconds = 5L;
        private int maxCache = 1000;

        public static TransCacheSettBuilder builder() {
            return new TransCacheSettBuilder();
        }

        public boolean isAccess() {
            return this.isAccess;
        }

        public long getCacheSeconds() {
            return this.cacheSeconds;
        }

        public int getMaxCache() {
            return this.maxCache;
        }

        public void setAccess(boolean isAccess) {
            this.isAccess = isAccess;
        }

        public void setCacheSeconds(long cacheSeconds) {
            this.cacheSeconds = cacheSeconds;
        }

        public void setMaxCache(int maxCache) {
            this.maxCache = maxCache;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransCacheSett)) {
                return false;
            }
            TransCacheSett other = (TransCacheSett)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAccess() != other.isAccess()) {
                return false;
            }
            if (this.getCacheSeconds() != other.getCacheSeconds()) {
                return false;
            }
            return this.getMaxCache() == other.getMaxCache();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransCacheSett;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAccess() ? 79 : 97);
            long $cacheSeconds = this.getCacheSeconds();
            result = result * 59 + (int)($cacheSeconds >>> 32 ^ $cacheSeconds);
            result = result * 59 + this.getMaxCache();
            return result;
        }

        public String toString() {
            return "SimpleTransService.TransCacheSett(isAccess=" + this.isAccess() + ", cacheSeconds=" + this.getCacheSeconds() + ", maxCache=" + this.getMaxCache() + ")";
        }

        public TransCacheSett() {
        }

        public TransCacheSett(boolean isAccess, long cacheSeconds, int maxCache) {
            this.isAccess = isAccess;
            this.cacheSeconds = cacheSeconds;
            this.maxCache = maxCache;
        }

        public static class TransCacheSettBuilder {
            private boolean isAccess;
            private long cacheSeconds;
            private int maxCache;

            TransCacheSettBuilder() {
            }

            public TransCacheSettBuilder isAccess(boolean isAccess) {
                this.isAccess = isAccess;
                return this;
            }

            public TransCacheSettBuilder cacheSeconds(long cacheSeconds) {
                this.cacheSeconds = cacheSeconds;
                return this;
            }

            public TransCacheSettBuilder maxCache(int maxCache) {
                this.maxCache = maxCache;
                return this;
            }

            public TransCacheSett build() {
                return new TransCacheSett(this.isAccess, this.cacheSeconds, this.maxCache);
            }

            public String toString() {
                return "SimpleTransService.TransCacheSett.TransCacheSettBuilder(isAccess=" + this.isAccess + ", cacheSeconds=" + this.cacheSeconds + ", maxCache=" + this.maxCache + ")";
            }
        }
    }

    public static interface SimpleTransDiver {
        public List<? extends VO> findByIds(List<? extends Serializable> var1, Class<? extends VO> var2, String var3);

        default public List<? extends VO> findByIds(List<? extends Serializable> ids, Class<? extends VO> targetClass, String uniqueField, Set<String> targetFields) {
            return this.findByIds(ids, targetClass, uniqueField);
        }

        public VO findById(Serializable var1, Class<? extends VO> var2, String var3);

        default public VO findById(Serializable id, Class<? extends VO> targetClass, String uniqueField, Set<String> targetFields) {
            return this.findById(id, targetClass, uniqueField);
        }
    }
}

