/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.extend;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.service.impl.SimpleTransService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;

public class MybatisPlusSimpleTransDiver
implements SimpleTransService.SimpleTransDiver {
    public List<? extends VO> findByIds(List<? extends Serializable> ids, Class<? extends VO> targetClass, String uniqueField) {
        return this.findByIds(ids, targetClass, uniqueField, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends VO> findByIds(List<? extends Serializable> ids, Class<? extends VO> targetClass, String uniqueField, Set<String> targetFields) {
        SqlSession sqlSession = this.sqlSession(targetClass);
        try {
            uniqueField = this.getUniqueField(targetClass, uniqueField);
            QueryWrapper queryWrapper = this.genWrapper(targetClass, targetFields, uniqueField);
            queryWrapper.in((Object)this.getColumn(targetClass, uniqueField), ids);
            List list = this.getMapper(targetClass, sqlSession).selectList((Wrapper)queryWrapper);
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession, targetClass);
        }
    }

    public VO findById(Serializable id, Class<? extends VO> targetClass, String uniqueField) {
        return this.findById(id, targetClass, uniqueField, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VO findById(Serializable id, Class<? extends VO> targetClass, String uniqueField, Set<String> targetFields) {
        SqlSession sqlSession = this.sqlSession(targetClass);
        try {
            uniqueField = this.getUniqueField(targetClass, uniqueField);
            QueryWrapper queryWrapper = this.genWrapper(targetClass, targetFields, uniqueField);
            queryWrapper.eq((Object)this.getColumn(targetClass, uniqueField), (Object)id);
            VO vO = (VO)this.getMapper(targetClass, sqlSession).selectOne((Wrapper)queryWrapper);
            return vO;
        }
        finally {
            this.closeSqlSession(sqlSession, targetClass);
        }
    }

    private QueryWrapper genWrapper(Class<? extends VO> targetClass, Set<String> targetFields, String uniqueField) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (targetFields != null && !targetFields.isEmpty()) {
            targetFields.add(this.getKeyProperty(targetClass));
            if (!StringUtil.isEmpty((String)uniqueField)) {
                targetFields.add(uniqueField);
            }
            boolean autoInitResultMap = this.isAutoInitResultMap(targetClass);
            queryWrapper.select((String[])targetFields.stream().map(column -> autoInitResultMap ? this.getColumn(targetClass, (String)column) : this.getColumn(targetClass, (String)column) + " AS " + column).toArray(String[]::new));
        }
        return queryWrapper;
    }

    public String getColumn(Class<? extends VO> targetClass, String field) {
        Map cacheMap = LambdaUtils.getColumnMap(targetClass);
        if (cacheMap == null) {
            throw ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{targetClass.getName()});
        }
        if (!cacheMap.containsKey(field.toUpperCase())) {
            throw ExceptionUtils.mpe((String)"Can not find field: \"%s\" in Class: \"%s\".", (Object[])new Object[]{field, targetClass.getName()});
        }
        return ((ColumnCache)cacheMap.get(field.toUpperCase())).getColumn();
    }

    private String getUniqueField(Class<? extends VO> targetClass, String uniqueField) {
        if (!StringUtil.isEmpty((String)uniqueField)) {
            return uniqueField;
        }
        return this.getKeyProperty(targetClass);
    }

    private String getKeyProperty(Class<? extends VO> targetClass) {
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(targetClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{targetClass.getName()}));
        return tableInfo.getKeyProperty();
    }

    private boolean isAutoInitResultMap(Class<? extends VO> targetClass) {
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(targetClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{targetClass.getName()}));
        return tableInfo.isAutoInitResultMap();
    }

    protected SqlSession sqlSession(Class<? extends VO> voClass) {
        return SqlHelper.sqlSession(voClass);
    }

    protected String sqlStatement(String sqlMethod, Class<? extends VO> voClass) {
        return SqlHelper.table(voClass).getSqlStatement(sqlMethod);
    }

    protected void closeSqlSession(SqlSession sqlSession, Class<? extends VO> voClass) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(voClass));
    }

    private BaseMapper<? extends VO> getMapper(Class<? extends VO> entityClass, SqlSession sqlSession) {
        Optional.ofNullable(entityClass).orElseThrow(() -> ExceptionUtils.mpe((String)"entityClass can't be null!", (Object[])new Object[0]));
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
        try {
            Configuration configuration = (Configuration)ReflectUtils.getValue((Object)tableInfo, (String)"configuration");
            return (BaseMapper)configuration.getMapper(Class.forName(tableInfo.getCurrentNamespace()), sqlSession);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
    }
}

