/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import thirdparty.org.bouncycastle.crypto.CryptoServicePurpose;
import thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import thirdparty.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import thirdparty.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import thirdparty.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("Ed448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters ed448PublicKeyParameters = ed448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed448PublicKeyParameters, ed448PrivateKeyParameters);
    }
}

