/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import thirdparty.org.bouncycastle.crypto.CryptoServicePurpose;
import thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import thirdparty.org.bouncycastle.crypto.constraints.ConstraintUtils;
import thirdparty.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import thirdparty.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import thirdparty.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import thirdparty.org.bouncycastle.crypto.params.DHParameters;
import thirdparty.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import thirdparty.org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("DHBasicKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

