/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.cms.bc;

import thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import thirdparty.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import thirdparty.org.bouncycastle.cms.SignerInformationVerifier;
import thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import thirdparty.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import thirdparty.org.bouncycastle.operator.OperatorCreationException;
import thirdparty.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import thirdparty.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;

public class BcRSASignerInfoVerifierBuilder {
    private BcRSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcRSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgIdFinder = signatureAlgorithmIdentifierFinder;
        this.contentVerifierProviderBuilder = new BcRSAContentVerifierProviderBuilder(digestAlgorithmIdentifierFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(x509CertificateHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(asymmetricKeyParameter), this.digestCalculatorProvider);
    }
}

