/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.asn1.cmp;

import thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import thirdparty.org.bouncycastle.asn1.ASN1Object;
import thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import thirdparty.org.bouncycastle.asn1.DERSequence;
import thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class DHBMParameter
extends ASN1Object {
    private final AlgorithmIdentifier owf;
    private final AlgorithmIdentifier mac;

    private DHBMParameter(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("expecting sequence size of 2");
        }
        this.owf = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.mac = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public DHBMParameter(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        this.owf = algorithmIdentifier;
        this.mac = algorithmIdentifier2;
    }

    public static DHBMParameter getInstance(Object object) {
        if (object instanceof DHBMParameter) {
            return (DHBMParameter)object;
        }
        if (object != null) {
            return new DHBMParameter(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AlgorithmIdentifier getOwf() {
        return this.owf;
    }

    public AlgorithmIdentifier getMac() {
        return this.mac;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{this.owf, this.mac});
    }
}

