/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.StreamEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedInputStream
extends InputStream {
    private InputStream father = null;
    private StreamEncoder encryptor = null;
    private ByteArrayInputStream memoryStream = null;

    public EncryptedInputStream(InputStream inputS) {
        this.father = inputS;
    }

    public void SetMemoryStream(InputStream mstream) {
        this.memoryStream = (ByteArrayInputStream)mstream;
    }

    public void SetEncryptor(StreamEncoder encryptor2) {
        this.encryptor = encryptor2;
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        this.read(tmp, 0, 1);
        return tmp[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (null != this.memoryStream && 0 < this.memoryStream.available()) {
            return this.memoryStream.read(b, off, len);
        }
        int ret = 0;
        int sret = 0;
        do {
            if ((sret = this.father.read(b, off + ret, len - ret)) >= 0) continue;
            ret = sret;
            break;
        } while ((ret += sret) < len && sret != 0);
        if (null == this.encryptor) {
            return ret;
        }
        if (ret > 0) {
            this.encryptor.DecryptBytes(b, off, ret);
        }
        return ret;
    }

    @Override
    public int available() throws IOException {
        if (null != this.memoryStream && 0 < this.memoryStream.available()) {
            return this.memoryStream.available();
        }
        return this.father.available();
    }

    @Override
    public void close() throws IOException {
        this.father.close();
        if (null != this.memoryStream) {
            this.memoryStream.close();
        }
    }
}

