/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAURLParser;
import com.exasol.jdbc.ParserResult;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class EXADriver
implements Driver {
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 64;
    public static final int MAX_CONNECTION_POOL_SIZE = 8192;
    public static int connectionPoolSize = 64;
    private DebugLog debug = null;
    private static EXADriver registeredDriver;

    public static void main(String[] args) throws Exception {
        System.out.println("Exasol JDBC driver, version 24.1.0");
        System.out.println("Build for JRE 8 or higher");
    }

    public static void debugError(String message, Throwable th, DebugLog debug) {
        String logMessage = "JDBC Exception - " + message;
        if (null == debug || null == th) {
            return;
        }
        if (null != message) {
            debug.log(logMessage);
        }
        if (null != th) {
            StackTraceElement[] traces = th.getStackTrace();
            if (null != traces && traces.length > 0) {
                debug.log(th.getClass() + ": " + th.getMessage());
                for (StackTraceElement trace : traces) {
                    debug.log("    at " + trace.getClassName() + '.' + trace.getMethodName() + '(' + trace.getFileName() + ':' + trace.getLineNumber() + ')');
                }
            }
            for (Throwable cause = th.getCause(); null != cause; cause = cause.getCause()) {
                StackTraceElement[] causeTraces = cause.getStackTrace();
                if (null == causeTraces || causeTraces.length <= 0) continue;
                debug.log("Caused by:");
                debug.log(cause.getClass() + ": " + cause.getMessage());
                for (StackTraceElement causeTrace : causeTraces) {
                    debug.log("    at " + causeTrace.getClassName() + '.' + causeTrace.getMethodName() + '(' + causeTrace.getFileName() + ':' + causeTrace.getLineNumber() + ')');
                }
            }
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:exa:") || url.startsWith("jdbc:exa-debug:") || url.startsWith("exa:") || url.startsWith("exa-debug:") || url.startsWith("jdbc:exa-worker:") || url.startsWith("jdbc:exa-worker-debug:") || url.startsWith("exa-worker:") || url.startsWith("exa-worker-debug:");
    }

    public static void register() throws SQLException {
        if (EXADriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        EXADriver registeredDriver = new EXADriver();
        DriverManager.registerDriver(registeredDriver);
        EXADriver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (!EXADriver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using EXADriver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Vector clusterNodes = null;
        if (null == url) {
            throw new SQLException(Translator.Driver_URL_can_t_be_null());
        }
        if (0 == url.length()) {
            throw new SQLException(Translator.Driver_URL_can_t_be_an_empty_string());
        }
        EXAConnection con = null;
        try {
            ParserResult parsedResult = this.parseURL8(url);
            if (parsedResult != null) {
                int connPoolSize = 0;
                try {
                    connPoolSize = Integer.parseInt(parsedResult.params.getProperty("connectionPoolSize"));
                }
                catch (Exception ex) {
                    connPoolSize = 0;
                }
                if (connPoolSize > 8192 || connPoolSize < 0) {
                    throw new SQLException("Connection pool size can be between 1 and 8192");
                }
                if (connPoolSize != 0) {
                    if (connectionPoolSize != 64 && connPoolSize != connectionPoolSize) {
                        throw new SQLException("Connection pool size can be changed only one time in the driver.");
                    }
                    connectionPoolSize = connPoolSize;
                }
                if ("1".equals(parsedResult.params.getProperty("TestConnectionStringOnly"))) {
                    parsedResult = this.expandDNSPool(parsedResult);
                }
                clusterNodes = new Vector();
                for (int i = 0; i < parsedResult.clusterNodes.size(); ++i) {
                    if (!((ClusterNode)parsedResult.clusterNodes.get(i)).isValid()) continue;
                    clusterNodes.add(parsedResult.clusterNodes.get(i));
                }
                if (clusterNodes.size() < 1) {
                    throw new SQLException(Translator.Error_in_connection_string_no_valid_hosts(), "HY000");
                }
                if (info != null) {
                    parsedResult.params.putAll((Map<?, ?>)info);
                }
                if ("1".equals(parsedResult.params.getProperty("debug"))) {
                    this.openLog(parsedResult.params.getProperty("logdir"));
                }
                String user = parsedResult.params.getProperty("user");
                String password = parsedResult.params.getProperty("password");
                String authMethod = parsedResult.params.getProperty("authmethod");
                String validateServerCertificate = parsedResult.params.getProperty("validateservercertificate");
                this.log("Java Version  : " + System.getProperty("java.version"));
                this.log("Driver Version: " + EXADriver.getVersionInfo());
                String urlDebug = url;
                if (urlDebug.contains("keystorepassword")) {
                    String keyStorePassword = parsedResult.params.getProperty("keystorepassword");
                    urlDebug = urlDebug.replace("keystorepassword=" + keyStorePassword, "keystorepassword=******");
                }
                this.log("Connection Url: " + urlDebug);
                for (int i = 0; i < clusterNodes.size(); ++i) {
                    if (0 == ((ClusterNode)clusterNodes.get(i)).GetPort()) {
                        ((ClusterNode)clusterNodes.get(i)).SetPort(8563);
                    }
                    this.log("Server:Port: " + ((ClusterNode)clusterNodes.get(i)).GetHostAndPort());
                }
                this.log("Username...: " + user);
                if (password != null && password != "") {
                    this.log("Password...: *****");
                }
                if (authMethod != null && authMethod != "") {
                    this.log("AuthMethod...: " + authMethod);
                }
                if (validateServerCertificate != null && validateServerCertificate != "") {
                    this.log("validateServerCertificate: " + validateServerCertificate);
                }
                if (clusterNodes.size() < 1) {
                    this.log(Translator.Error_in_connection_string_no_valid_hosts());
                    throw new SQLException(Translator.Error_in_connection_string_no_valid_hosts());
                }
                con = new EXAConnection(clusterNodes, user, password, this.debug, parsedResult.params);
                String onConnect = con.getParameter("onconnect");
                if (con.connected && null != onConnect && !onConnect.equals("")) {
                    Statement ocStmt = con.createStatement();
                    try {
                        ocStmt.execute(onConnect);
                    }
                    catch (SQLException ex) {
                        ocStmt.close();
                        con.close();
                        throw ex;
                    }
                    if (!con.getAutoCommit()) {
                        con.setAutoCommit(false);
                    }
                }
            }
            return con;
        }
        catch (SQLException e) {
            this.log(e);
            throw e;
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return EXAConnection.getDefaultProperties();
    }

    @Override
    public int getMajorVersion() {
        return Integer.valueOf("24");
    }

    @Override
    public int getMinorVersion() {
        return Integer.valueOf("1");
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private void openLog(String logdir) {
        try {
            System.setProperty("java.util.prefs.syncInterval", "2000000");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.debug = new DebugLog(logdir, "utf8");
        }
        catch (IOException e) {
            System.err.println("Cannot create logfile in " + logdir);
            this.debug = null;
        }
    }

    public static String getCompilationInfo() {
        try {
            Class<?> c = Class.forName("com.exasol.jdbc.EXADriver");
            ClassLoader cl = c.getClassLoader();
            InputStream in = cl.getResourceAsStream("com/exasol/jdbc/timestamp");
            StringBuffer buf = new StringBuffer();
            int ch = in.read();
            while (ch != -1) {
                buf.append((char)ch);
                ch = in.read();
            }
            Pattern rev = Pattern.compile("Revision:");
            String[] split = rev.split(buf.toString());
            if (split.length > 1) {
                return split[1].trim();
            }
            return Translator.No_info_available();
        }
        catch (Exception e) {
            return Translator.No_info_available();
        }
    }

    public ParserResult parseURL8(String url) throws SQLException {
        return new EXAURLParser().URLParser(url);
    }

    private ParserResult expandDNSPool(ParserResult inputHosts) {
        ParserResult outputHosts = new ParserResult();
        outputHosts.params = inputHosts.params;
        for (int i = 0; i < inputHosts.clusterNodes.size(); ++i) {
            ClusterNode icn = (ClusterNode)inputHosts.clusterNodes.get(i);
            try {
                InetAddress[] expandedHosts = InetAddress.getAllByName(icn.GetHost());
                if (expandedHosts.length > 1) {
                    ParserResult unsortedNodes = new ParserResult();
                    for (int j = 0; j < expandedHosts.length; ++j) {
                        ClusterNode cn = new ClusterNode(expandedHosts[j].getHostAddress(), icn.GetPort());
                        unsortedNodes.clusterNodes.add(cn);
                    }
                    ParserResult sortedNodes = this.sortNodesByHostAndPort(unsortedNodes);
                    int currSize = outputHosts.clusterNodes.size();
                    for (int j = 0; j < sortedNodes.clusterNodes.size(); ++j) {
                        outputHosts.clusterNodes.add(sortedNodes.clusterNodes.get(j));
                    }
                    continue;
                }
                outputHosts.clusterNodes.add(icn);
                continue;
            }
            catch (Exception e) {
                outputHosts.clusterNodes.add(icn);
            }
        }
        return outputHosts;
    }

    private ParserResult sortNodesByHostAndPort(ParserResult unsortedNodes) throws ConnectionException {
        Object[] strSortedNodes = new String[unsortedNodes.clusterNodes.size()];
        for (int i = 0; i < unsortedNodes.clusterNodes.size(); ++i) {
            strSortedNodes[i] = ((ClusterNode)unsortedNodes.clusterNodes.get(i)).GetHostAndPort();
        }
        Arrays.sort(strSortedNodes);
        ParserResult result = new ParserResult();
        result.params = unsortedNodes.params;
        for (int i = 0; i < unsortedNodes.clusterNodes.size(); ++i) {
            ClusterNode cn = new ClusterNode((String)strSortedNodes[i]);
            result.clusterNodes.add(cn);
        }
        return result;
    }

    private String FormatNumWithLeadingNulls(int length, int num) {
        String res = "";
        for (int i = 0; i < length - Integer.toString(num).length(); ++i) {
            res = res + "0";
        }
        res = res + Integer.toString(num);
        return res;
    }

    private void log(Object o) {
        if (this.debug != null) {
            this.debug.log(o.toString());
        }
    }

    public static int getProtocolVersion() {
        return EXAConnection.getProtocolVersion();
    }

    public static String getVersionInfo() {
        return "24.1.0";
    }

    public static String getRevisionInfo() {
        return "733704105dfbe3a0b5877ec13935e789281a9f11";
    }

    public static String getEXADriverName() {
        return "Exasol JDBC Driver";
    }

    static {
        try {
            DriverManager.registerDriver(new EXADriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

