/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.emc.atmos.AtmosException;
import com.emc.atmos.api.AbstractAtmosApi;
import com.emc.atmos.api.Acl;
import com.emc.atmos.api.AtmosConfig;
import com.emc.atmos.api.ChecksumValueImpl;
import com.emc.atmos.api.ObjectId;
import com.emc.atmos.api.ObjectIdentifier;
import com.emc.atmos.api.ObjectKey;
import com.emc.atmos.api.ObjectPath;
import com.emc.atmos.api.Range;
import com.emc.atmos.api.RestUtil;
import com.emc.atmos.api.bean.AccessToken;
import com.emc.atmos.api.bean.CreateAccessTokenResponse;
import com.emc.atmos.api.bean.CreateObjectResponse;
import com.emc.atmos.api.bean.GenericResponse;
import com.emc.atmos.api.bean.GetAccessTokenResponse;
import com.emc.atmos.api.bean.ListAccessTokensResponse;
import com.emc.atmos.api.bean.ListDirectoryResponse;
import com.emc.atmos.api.bean.ListObjectsResponse;
import com.emc.atmos.api.bean.ListVersionsResponse;
import com.emc.atmos.api.bean.Metadata;
import com.emc.atmos.api.bean.ObjectEntry;
import com.emc.atmos.api.bean.ObjectInfo;
import com.emc.atmos.api.bean.ObjectMetadata;
import com.emc.atmos.api.bean.ReadObjectResponse;
import com.emc.atmos.api.bean.ServiceInformation;
import com.emc.atmos.api.jersey.JerseyApacheUtil;
import com.emc.atmos.api.jersey.MeasuredInputStream;
import com.emc.atmos.api.multipart.MultipartEntity;
import com.emc.atmos.api.request.ContentRequest;
import com.emc.atmos.api.request.CreateAccessTokenRequest;
import com.emc.atmos.api.request.CreateObjectRequest;
import com.emc.atmos.api.request.CreateSubtenantRequest;
import com.emc.atmos.api.request.ListAccessTokensRequest;
import com.emc.atmos.api.request.ListDirectoryRequest;
import com.emc.atmos.api.request.ListObjectsRequest;
import com.emc.atmos.api.request.ListVersionsRequest;
import com.emc.atmos.api.request.PreSignedRequest;
import com.emc.atmos.api.request.ReadObjectRequest;
import com.emc.atmos.api.request.Request;
import com.emc.atmos.api.request.UpdateObjectRequest;
import com.emc.util.BasicResponse;
import com.emc.util.HttpUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.log4j.Logger;

public class AtmosApiClient
extends AbstractAtmosApi {
    private static final Logger l4j = Logger.getLogger(AtmosApiClient.class);
    protected Client client;
    protected Client client100;

    public AtmosApiClient(AtmosConfig config) {
        this(config, (List)null, null);
    }

    public AtmosApiClient(AtmosConfig config, List<Class<MessageBodyReader<?>>> readers, List<Class<MessageBodyWriter<?>>> writers) {
        this(config, JerseyApacheUtil.createApacheClient(config, false, readers, writers), JerseyApacheUtil.createApacheClient(config, true, readers, writers));
    }

    protected AtmosApiClient(AtmosConfig config, Client client, Client client100) {
        super(config);
        this.client = client;
        this.client100 = client100;
    }

    @Override
    protected Client createClient(AtmosConfig config) {
        return null;
    }

    public void addClientFilter(ClientFilter filter) {
        this.client.addFilter(filter);
        this.client100.addFilter(filter);
    }

    @Override
    public ServiceInformation getServiceInformation() {
        String utf8String;
        ClientResponse response = (ClientResponse)this.client.resource(((AtmosConfig)this.config).resolveHostAndPath("service", null)).get(ClientResponse.class);
        ServiceInformation serviceInformation = (ServiceInformation)response.getEntity(ServiceInformation.class);
        String featureString = (String)response.getHeaders().getFirst((Object)"x-emc-features");
        if (featureString != null) {
            for (String feature : featureString.split(",")) {
                serviceInformation.addFeatureFromHeaderName(feature.trim());
            }
        }
        if ((utf8String = (String)response.getHeaders().getFirst((Object)"x-emc-support-utf8")) != null && Boolean.valueOf(utf8String).booleanValue()) {
            serviceInformation.addFeature(ServiceInformation.Feature.Utf8);
        }
        response.close();
        return serviceInformation;
    }

    @Override
    public long calculateServerClockSkew() {
        WebResource resource = this.client.resource(((AtmosConfig)this.config).resolveHostAndPath("", null));
        resource.setProperty("ErrorFilter.noExceptions", (Object)true);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getResponseDate() == null) {
            throw new AtmosException("Response date is null", response.getStatus());
        }
        ((AtmosConfig)this.config).setServerClockSkew(System.currentTimeMillis() - response.getResponseDate().getTime());
        response.close();
        return ((AtmosConfig)this.config).getServerClockSkew();
    }

    @Override
    public CreateObjectResponse createObject(CreateObjectRequest request) {
        ClientResponse response = (ClientResponse)this.build(request).post(ClientResponse.class, this.getContent(request));
        response.close();
        return this.fillResponse(new CreateObjectResponse(), response);
    }

    @Override
    public <T> ReadObjectResponse<T> readObject(ReadObjectRequest request, Class<T> objectType) throws IOException {
        if (request.getRanges() != null && request.getRanges().size() > 1 && !MultipartEntity.class.isAssignableFrom(objectType)) {
            l4j.warn((Object)("multiple ranges imply a multi-part response. you should ask for MultipartEntity instead of " + objectType.getSimpleName()));
        }
        ClientResponse response = (ClientResponse)this.build(request).get(ClientResponse.class);
        ReadObjectResponse<Object> ret = new ReadObjectResponse<Object>(response.getEntity(objectType));
        response.close();
        return this.fillResponse(ret, response);
    }

    @Override
    public ReadObjectResponse<InputStream> readObjectStream(ObjectIdentifier identifier, Range range) {
        ClientResponse response = (ClientResponse)this.build(((ReadObjectRequest)new ReadObjectRequest().identifier(identifier)).ranges(range)).get(ClientResponse.class);
        return this.fillResponse(new ReadObjectResponse<InputStream>(response.getEntityInputStream()), response);
    }

    @Override
    public BasicResponse updateObject(UpdateObjectRequest request) {
        ClientResponse response = (ClientResponse)this.build(request).put(ClientResponse.class, this.getContent(request));
        response.close();
        return this.fillResponse(new BasicResponse(), response);
    }

    @Override
    public void delete(ObjectIdentifier identifier) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), null);
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        builder.delete();
    }

    @Override
    public ObjectId createDirectory(ObjectPath path) {
        if (!path.isDirectory()) {
            throw new AtmosException("Path must be a directory");
        }
        CreateObjectRequest request = (CreateObjectRequest)new CreateObjectRequest().identifier(path);
        ClientResponse response = (ClientResponse)this.build(request).post(ClientResponse.class);
        response.close();
        return RestUtil.parseObjectId(response.getLocation().getPath());
    }

    @Override
    public ObjectId createDirectory(ObjectPath path, Acl acl, Metadata ... metadata) {
        if (!path.isDirectory()) {
            throw new AtmosException("Path must be a directory");
        }
        CreateObjectRequest request = (CreateObjectRequest)((CreateObjectRequest)new CreateObjectRequest().identifier(path)).acl(acl);
        request.userMetadata(metadata);
        ClientResponse response = (ClientResponse)this.build(request).post(ClientResponse.class);
        response.close();
        return RestUtil.parseObjectId(response.getLocation().getPath());
    }

    @Override
    public ListDirectoryResponse listDirectory(ListDirectoryRequest request) {
        if (!request.getPath().isDirectory()) {
            throw new AtmosException("Path must be a directory");
        }
        ClientResponse response = (ClientResponse)this.build(request).get(ClientResponse.class);
        request.setToken((String)response.getHeaders().getFirst((Object)"x-emc-token"));
        if (request.getToken() != null) {
            l4j.info((Object)"Results truncated. Call listDirectory again for next page of results.");
        }
        ListDirectoryResponse ret = (ListDirectoryResponse)response.getEntity(ListDirectoryResponse.class);
        response.close();
        return this.fillResponse(ret, response);
    }

    @Override
    public void move(ObjectPath oldPath, ObjectPath newPath, boolean overwrite) {
        WebResource resource = this.client.resource(((AtmosConfig)this.config).resolveHostAndPath(oldPath.getRelativeResourcePath(), "rename"));
        WebResource.Builder builder = resource.getRequestBuilder();
        builder.header("x-emc-path", (Object)(((AtmosConfig)this.config).isEncodeUtf8() ? HttpUtil.encodeUtf8(newPath.getPath()) : newPath.getPath()));
        if (((AtmosConfig)this.config).isEncodeUtf8()) {
            builder.header("x-emc-utf8", (Object)"true");
        }
        if (overwrite) {
            builder.header("x-emc-force", (Object)"true");
        }
        builder.type("application/octet-stream");
        builder.post();
    }

    @Override
    public Map<String, Boolean> getUserMetadataNames(ObjectIdentifier identifier) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "metadata/tags");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        if (((AtmosConfig)this.config).isEncodeUtf8()) {
            builder.header("x-emc-utf8", (Object)"true");
        }
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        TreeMap<String, Boolean> metaNames = new TreeMap<String, Boolean>();
        String nameString = (String)response.getHeaders().getFirst((Object)"x-emc-tags");
        if (nameString != null) {
            for (String name : nameString.split(",")) {
                metaNames.put(((AtmosConfig)this.config).isEncodeUtf8() ? HttpUtil.decodeUtf8(name.trim()) : name.trim(), false);
            }
        }
        if ((nameString = (String)response.getHeaders().getFirst((Object)"x-emc-listable-tags")) != null) {
            for (String name : nameString.split(",")) {
                metaNames.put(((AtmosConfig)this.config).isEncodeUtf8() ? HttpUtil.decodeUtf8(name.trim()) : name.trim(), true);
            }
        }
        response.close();
        return metaNames;
    }

    @Override
    public Map<String, Metadata> getUserMetadata(ObjectIdentifier identifier, String ... metadataNames) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "metadata/user");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        if (metadataNames != null) {
            for (String name : metadataNames) {
                if (((AtmosConfig)this.config).isEncodeUtf8()) {
                    name = HttpUtil.encodeUtf8(name);
                }
                builder.header("x-emc-tags", (Object)name);
            }
        }
        if (((AtmosConfig)this.config).isEncodeUtf8()) {
            builder.header("x-emc-utf8", (Object)"true");
        }
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        TreeMap<String, Metadata> metaMap = new TreeMap<String, Metadata>();
        metaMap.putAll(RestUtil.parseMetadataHeader((String)response.getHeaders().getFirst((Object)"x-emc-meta"), false, ((AtmosConfig)this.config).isEncodeUtf8()));
        metaMap.putAll(RestUtil.parseMetadataHeader((String)response.getHeaders().getFirst((Object)"x-emc-listable-meta"), true, ((AtmosConfig)this.config).isEncodeUtf8()));
        response.close();
        return metaMap;
    }

    @Override
    public Map<String, Metadata> getSystemMetadata(ObjectIdentifier identifier, String ... metadataNames) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "metadata/system");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        if (metadataNames != null) {
            for (String name : metadataNames) {
                if (((AtmosConfig)this.config).isEncodeUtf8()) {
                    name = HttpUtil.encodeUtf8(name);
                }
                builder.header("x-emc-tags", (Object)name);
            }
        }
        if (((AtmosConfig)this.config).isEncodeUtf8()) {
            builder.header("x-emc-utf8", (Object)"true");
        }
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        response.close();
        return RestUtil.parseMetadataHeader((String)response.getHeaders().getFirst((Object)"x-emc-meta"), false, ((AtmosConfig)this.config).isEncodeUtf8());
    }

    @Override
    public boolean objectExists(ObjectIdentifier identifier) {
        try {
            this.getSystemMetadata(identifier, new String[0]);
            return true;
        }
        catch (AtmosException e) {
            if (e.getErrorCode() == 1003) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public ObjectMetadata getObjectMetadata(ObjectIdentifier identifier) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), null);
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        if (((AtmosConfig)this.config).isEncodeUtf8()) {
            builder.header("x-emc-utf8", (Object)"true");
        }
        ClientResponse response = builder.head();
        Acl acl = new Acl(RestUtil.parseAclHeader((String)response.getHeaders().getFirst((Object)"x-emc-useracl")), RestUtil.parseAclHeader((String)response.getHeaders().getFirst((Object)"x-emc-groupacl")));
        TreeMap<String, Metadata> metaMap = new TreeMap<String, Metadata>();
        metaMap.putAll(RestUtil.parseMetadataHeader((String)response.getHeaders().getFirst((Object)"x-emc-meta"), false, ((AtmosConfig)this.config).isEncodeUtf8()));
        metaMap.putAll(RestUtil.parseMetadataHeader((String)response.getHeaders().getFirst((Object)"x-emc-listable-meta"), true, ((AtmosConfig)this.config).isEncodeUtf8()));
        String wsChecksumHeader = (String)response.getHeaders().getFirst((Object)"x-emc-wschecksum");
        ChecksumValueImpl wsChecksum = wsChecksumHeader == null ? null : new ChecksumValueImpl(wsChecksumHeader);
        String serverChecksumHeader = (String)response.getHeaders().getFirst((Object)"x-emc-content-checksum");
        ChecksumValueImpl serverChecksum = serverChecksumHeader == null ? null : new ChecksumValueImpl(serverChecksumHeader);
        String retentionPeriod = (String)response.getHeaders().getFirst((Object)"x-emc-retention-period");
        response.close();
        ObjectMetadata metadata = new ObjectMetadata(metaMap, acl, response.getType().toString(), wsChecksum, serverChecksum);
        if (retentionPeriod != null) {
            metadata.setRetentionPeriod(Long.parseLong(retentionPeriod));
        }
        metadata.setRetentionPolicy((String)response.getHeaders().getFirst((Object)"x-emc-retention-policy"));
        metadata.setETag((String)response.getHeaders().getFirst((Object)"ETag"));
        return metadata;
    }

    @Override
    public void setUserMetadata(ObjectIdentifier identifier, Metadata ... metadata) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "metadata/user");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        for (Metadata oneMetadata : metadata) {
            if (oneMetadata.isListable()) {
                builder.header("x-emc-listable-meta", (Object)(((AtmosConfig)this.config).isEncodeUtf8() ? oneMetadata.toASCIIString() : oneMetadata.toString()));
                continue;
            }
            builder.header("x-emc-meta", (Object)(((AtmosConfig)this.config).isEncodeUtf8() ? oneMetadata.toASCIIString() : oneMetadata.toString()));
        }
        builder.type("application/octet-stream");
        if (((AtmosConfig)this.config).isEncodeUtf8()) {
            builder.header("x-emc-utf8", (Object)"true");
        }
        builder.post();
    }

    @Override
    public void deleteUserMetadata(ObjectIdentifier identifier, String ... names) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "metadata/user");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        for (String name : names) {
            if (((AtmosConfig)this.config).isEncodeUtf8()) {
                name = HttpUtil.encodeUtf8(name);
            }
            builder.header("x-emc-tags", (Object)name);
        }
        if (((AtmosConfig)this.config).isEncodeUtf8()) {
            builder.header("x-emc-utf8", (Object)"true");
        }
        builder.delete();
    }

    @Override
    public Set<String> listMetadata(String metadataName) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath("objects", "listabletags");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (metadataName != null) {
            builder.header("x-emc-tags", (Object)(((AtmosConfig)this.config).isEncodeUtf8() ? HttpUtil.encodeUtf8(metadataName) : metadataName));
        }
        if (((AtmosConfig)this.config).isEncodeUtf8()) {
            builder.header("x-emc-utf8", (Object)"true");
        }
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        String headerValue = (String)response.getHeaders().getFirst((Object)"x-emc-listable-tags");
        TreeSet<String> names = new TreeSet<String>();
        if (headerValue == null) {
            return names;
        }
        for (String name : headerValue.split(",")) {
            names.add(((AtmosConfig)this.config).isEncodeUtf8() ? HttpUtil.decodeUtf8(name.trim()) : name.trim());
        }
        response.close();
        return names;
    }

    @Override
    public ListObjectsResponse listObjects(ListObjectsRequest request) {
        ClientResponse response;
        if (request.getMetadataName() == null) {
            throw new AtmosException("You must specify the name of a listable piece of metadata");
        }
        try {
            response = (ClientResponse)this.build(request).get(ClientResponse.class);
        }
        catch (AtmosException e) {
            if (e.getErrorCode() != 1003) {
                throw e;
            }
            ListObjectsResponse lor = new ListObjectsResponse();
            lor.setEntries(new ArrayList<ObjectEntry>());
            return lor;
        }
        request.setToken((String)response.getHeaders().getFirst((Object)"x-emc-token"));
        if (request.getToken() != null) {
            l4j.info((Object)"Results truncated. Call listObjects again for next page of results.");
        }
        ListObjectsResponse ret = (ListObjectsResponse)response.getEntity(ListObjectsResponse.class);
        response.close();
        return this.fillResponse(ret, response);
    }

    @Override
    public Acl getAcl(ObjectIdentifier identifier) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "acl");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        Acl acl = new Acl();
        acl.setUserAcl(RestUtil.parseAclHeader((String)response.getHeaders().getFirst((Object)"x-emc-useracl")));
        acl.setGroupAcl(RestUtil.parseAclHeader((String)response.getHeaders().getFirst((Object)"x-emc-groupacl")));
        response.close();
        return acl;
    }

    @Override
    public void setAcl(ObjectIdentifier identifier, Acl acl) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "acl");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        if (acl != null) {
            for (Object value : acl.getUserAclHeader()) {
                builder.header("x-emc-useracl", value);
            }
            for (Object value : acl.getGroupAclHeader()) {
                builder.header("x-emc-groupacl", value);
            }
        }
        builder.type("application/octet-stream");
        builder.post();
    }

    @Override
    public ObjectInfo getObjectInfo(ObjectIdentifier identifier) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "info");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        return (ObjectInfo)builder.get(ObjectInfo.class);
    }

    @Override
    public ObjectId createVersion(ObjectIdentifier identifier) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), "versions");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        if (identifier instanceof ObjectKey) {
            builder.header("x-emc-pool", (Object)((ObjectKey)identifier).getBucket());
        }
        builder.type("application/octet-stream");
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class);
        response.close();
        return RestUtil.parseObjectId(response.getLocation().getPath());
    }

    @Override
    public ListVersionsResponse listVersions(ListVersionsRequest request) {
        ClientResponse response = (ClientResponse)this.build(request).get(ClientResponse.class);
        request.setToken((String)response.getHeaders().getFirst((Object)"x-emc-token"));
        if (request.getToken() != null) {
            l4j.info((Object)"Results truncated. Call listVersions again for next page of results.");
        }
        ListVersionsResponse ret = (ListVersionsResponse)response.getEntity(ListVersionsResponse.class);
        response.close();
        return this.fillResponse(ret, response);
    }

    @Override
    public void restoreVersion(ObjectId objectId, ObjectId versionId) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(objectId.getRelativeResourcePath(), "versions");
        WebResource.Builder builder = this.client.resource(uri).getRequestBuilder();
        ((WebResource.Builder)builder.header("x-emc-version-oid", (Object)versionId)).put();
    }

    @Override
    public void deleteVersion(ObjectId versionId) {
        this.client.resource(((AtmosConfig)this.config).resolveHostAndPath(versionId.getRelativeResourcePath(), "versions")).delete();
    }

    @Override
    public CreateAccessTokenResponse createAccessToken(CreateAccessTokenRequest request) throws MalformedURLException {
        ClientResponse response = (ClientResponse)this.build(request).post(ClientResponse.class, (Object)request.getPolicy());
        URI tokenUri = ((AtmosConfig)this.config).resolveHostAndPath(response.getLocation().getPath(), response.getLocation().getQuery());
        response.close();
        return this.fillResponse(new CreateAccessTokenResponse(tokenUri.toURL()), response);
    }

    @Override
    public GetAccessTokenResponse getAccessToken(String accessTokenId) {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath("accesstokens/" + accessTokenId, "info");
        ClientResponse response = (ClientResponse)this.client.resource(uri).get(ClientResponse.class);
        GetAccessTokenResponse ret = new GetAccessTokenResponse((AccessToken)response.getEntity(AccessToken.class));
        response.close();
        return this.fillResponse(ret, response);
    }

    @Override
    public void deleteAccessToken(String accessTokenId) {
        this.client.resource(((AtmosConfig)this.config).resolveHostAndPath("accesstokens/" + accessTokenId, null)).delete();
    }

    @Override
    public ListAccessTokensResponse listAccessTokens(ListAccessTokensRequest request) {
        ClientResponse response = (ClientResponse)this.build(request).get(ClientResponse.class);
        request.setToken((String)response.getHeaders().getFirst((Object)"x-emc-token"));
        if (request.getToken() != null) {
            l4j.info((Object)"Results truncated. Call listAccessTokens again for next page of results.");
        }
        ListAccessTokensResponse ret = (ListAccessTokensResponse)response.getEntity(ListAccessTokensResponse.class);
        response.close();
        return this.fillResponse(ret, response);
    }

    @Override
    public <T> GenericResponse<T> execute(PreSignedRequest request, Class<T> resultType, Object content) throws URISyntaxException {
        GenericResponse<Object> ret;
        WebResource.Builder builder = this.client.resource(request.getUrl().toURI()).getRequestBuilder();
        this.addHeaders(builder, request.getHeaders()).type(request.getContentType());
        ClientResponse response = (ClientResponse)builder.method(request.getMethod(), ClientResponse.class, content);
        if (InputStream.class.equals(resultType)) {
            ret = new GenericResponse<InputStream>(response.getEntityInputStream());
        } else {
            ret = new GenericResponse<Object>(response.getEntity(resultType));
            response.close();
        }
        return this.fillResponse(ret, response);
    }

    protected WebResource.Builder build(Request request) {
        WebResource resource;
        if (request.supports100Continue() && ((AtmosConfig)this.config).isEnableExpect100Continue() && this.client100 != null) {
            l4j.debug((Object)"Expect: 100-continue is enabled for this request");
            resource = this.client100.resource(((AtmosConfig)this.config).resolveHostAndPath(request.getServiceRelativePath(), request.getQuery()));
        } else {
            resource = this.client.resource(((AtmosConfig)this.config).resolveHostAndPath(request.getServiceRelativePath(), request.getQuery()));
        }
        WebResource.Builder builder = resource.getRequestBuilder();
        if (request instanceof ContentRequest) {
            ContentRequest contentRequest = (ContentRequest)((Object)request);
            if (contentRequest.getContentType() == null) {
                builder.type("application/octet-stream");
            } else {
                builder.type(contentRequest.getContentType());
            }
        } else if ("POST".equals(request.getMethod())) {
            builder.type("application/octet-stream");
        }
        return this.addHeaders(builder, request.generateHeaders(((AtmosConfig)this.config).isEncodeUtf8()));
    }

    protected WebResource.Builder addHeaders(WebResource.Builder builder, Map<String, List<Object>> headers) {
        for (String name : headers.keySet()) {
            for (Object value : headers.get(name)) {
                builder.header(name, value);
            }
        }
        return builder;
    }

    protected Object getContent(ContentRequest request) {
        Object content = request.getContent();
        if (content == null) {
            return new byte[0];
        }
        if (content instanceof InputStream) {
            if (request.getContentLength() < 0L) {
                throw new UnsupportedOperationException("Content request with input stream must provide content length");
            }
            if (request.getContentLength() == 0L) {
                l4j.info((Object)"Content request with input stream and zero-length will not send any data");
            }
            return new MeasuredInputStream((InputStream)content, request.getContentLength());
        }
        return content;
    }

    @Override
    public String createSubtenant(CreateSubtenantRequest request) {
        ClientResponse response = (ClientResponse)this.build(request).put(ClientResponse.class);
        return (String)((List)response.getHeaders().get((Object)"subtenantID")).get(0);
    }

    @Override
    public void deleteSubtenant(String subtenantId) {
        this.client.resource(((AtmosConfig)this.config).resolveHostAndPath("subtenant/" + subtenantId, null)).delete();
    }
}

