/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api;

import com.emc.atmos.ChecksumError;
import com.emc.atmos.api.ChecksumValue;
import com.emc.atmos.api.RunningChecksum;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class ChecksummedInputStream
extends InputStream {
    private InputStream delegate;
    private ChecksumValue referenceChecksum;
    private RunningChecksum runningChecksum;

    public ChecksummedInputStream(InputStream delegate, ChecksumValue checksum) throws NoSuchAlgorithmException {
        this.delegate = delegate;
        this.referenceChecksum = checksum;
        this.runningChecksum = new RunningChecksum(checksum.getAlgorithm());
    }

    @Override
    public int read() throws IOException {
        int value = this.delegate.read();
        if (value < 0) {
            this.finish();
        } else {
            this.update(new byte[]{(byte)value}, 0, 1);
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = this.delegate.read(b, off, len);
        if (value < 0) {
            this.finish();
        } else {
            this.update(b, off, value);
        }
        return value;
    }

    @Override
    public long skip(long n) throws IOException {
        int toSkip;
        long remaining;
        int skipped;
        for (remaining = n; remaining > 0L && (skipped = this.skip(toSkip = (int)Math.min(remaining, Integer.MAX_VALUE))) != 0; remaining -= (long)skipped) {
        }
        return n - remaining;
    }

    private int skip(int n) throws IOException {
        int total;
        int read;
        byte[] bytes = new byte[65536];
        for (total = 0; total < n; total += read) {
            int toRead = Math.min(n - total, bytes.length);
            read = this.delegate.read(bytes, 0, toRead);
            if (read < 0) {
                this.finish();
                break;
            }
            this.update(bytes, 0, read);
        }
        return total;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void update(byte[] bytes, int offset, int length) {
        this.runningChecksum.update(bytes, offset, length);
    }

    private void finish() {
        String calculatedValue;
        String referenceValue = this.referenceChecksum.getValue();
        if (!referenceValue.equals(calculatedValue = this.runningChecksum.getValue())) {
            throw new ChecksumError("Checksum failure while reading stream", referenceValue, calculatedValue);
        }
    }
}

