/*
 * Decompiled with CFR 0.152.
 */
package com.emc.acdp.api.jersey;

import com.emc.acdp.AcdpConfig;
import com.emc.acdp.AcdpException;
import com.emc.acdp.api.jersey.AuthFilter;
import com.emc.acdp.api.jersey.ErrorFilter;
import com.emc.util.SslUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;

public class JerseyUtil {
    public static Client createClient(AcdpConfig config) {
        try {
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            if (config.isDisableSslValidation() && "https".equals(config.getProto().toLowerCase())) {
                clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(SslUtil.gullibleVerifier, SslUtil.createGullibleSslContext()));
            }
            Client client = Client.create((ClientConfig)clientConfig);
            JerseyUtil.configureClient(client, config);
            return client;
        }
        catch (Exception e) {
            throw new AcdpException("Error configuring REST client", e);
        }
    }

    public static void configureClient(Client client, AcdpConfig config) {
        client.addFilter((ClientFilter)new ErrorFilter());
        client.addFilter((ClientFilter)new AuthFilter(config));
    }

    private JerseyUtil() {
    }
}

