/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.util.sign;

import com.egzosn.pay.common.util.str.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CertDescriptor {
    protected static final Log log = LogFactory.getLog(CertDescriptor.class);
    private KeyStore keyStore = null;
    private X509Certificate publicKeyCert = null;
    private X509Certificate rootKeyCert = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            in = new FileInputStream(path);
            encryptCertTemp = (X509Certificate)cf.generateCertificate(in);
            log.warn((Object)("[" + path + "][CertId=" + encryptCertTemp.getSerialNumber().toString() + "]"));
        }
        catch (CertificateException e) {
            log.error((Object)"InitCert Error", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"InitCert Error File Not Found", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)e.toString());
                }
            }
        }
        return encryptCertTemp;
    }

    public PrivateKey getSignCertPrivateKey(String pwd) {
        try {
            Enumeration<String> aliasenum = this.keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(keyAlias, pwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            log.error((Object)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            log.error((Object)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
    }

    public String getSignCertId() {
        try {
            Enumeration<String> aliasenum = this.keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            log.error((Object)"getSignCertId Error", (Throwable)e);
            return null;
        }
    }

    public void initPrivateSignCert(String signCertPath, String signCertPwd, String signCertType) {
        if (null != this.keyStore) {
            this.keyStore = null;
        }
        try {
            this.keyStore = this.getKeyInfo(signCertPath, signCertPwd, signCertType);
            log.info((Object)("InitSignCert Successful. CertId=[" + this.getSignCertId() + "]"));
        }
        catch (IOException e) {
            log.error((Object)"InitSignCert Error", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
        log.warn((Object)("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + pfxkeyfile));
        try (FileInputStream fis = new FileInputStream(pfxkeyfile);){
            KeyStore ks = KeyStore.getInstance(type);
            log.warn((Object)("Load RSA CertPath=[" + pfxkeyfile + "],Pwd=[" + keypwd + "],type=[" + type + "]"));
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            log.error((Object)"getKeyInfo Error", (Throwable)e);
            return null;
        }
    }

    private String getCertIdIdByStore(KeyStore keyStore) {
        Enumeration<String> aliasenum = null;
        try {
            aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (KeyStoreException e) {
            log.error((Object)"getCertIdIdByStore Error", (Throwable)e);
            return null;
        }
    }

    public void initPublicCert(String certPath) {
        if (!StringUtils.isEmpty(certPath)) {
            this.publicKeyCert = CertDescriptor.initCert(certPath);
            log.info((Object)"Load PublicKeyCert Successful");
        } else {
            log.info((Object)"PublicKeyCert is empty");
        }
    }

    public void initRootCert(String certPath) {
        if (!StringUtils.isEmpty(certPath)) {
            this.rootKeyCert = CertDescriptor.initCert(certPath);
            log.info((Object)"Load RootCert Successful");
        } else {
            log.info((Object)"RootCert is empty");
        }
    }

    public X509Certificate getPublicCert() {
        return this.publicKeyCert;
    }

    public X509Certificate getRootCert() {
        return this.rootKeyCert;
    }
}

