/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.http;

import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.HttpHeader;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.str.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;

public class HttpRequestTemplate {
    protected final Log log = LogFactory.getLog(HttpRequestTemplate.class);
    protected CloseableHttpClient httpClient;
    protected PoolingHttpClientConnectionManager connectionManager;
    protected HttpHost httpProxy;
    HttpConfigStorage configStorage;

    public HttpHost getHttpProxy() {
        return this.httpProxy;
    }

    public CloseableHttpClient getHttpClient() {
        if (null != this.httpClient) {
            return this.httpClient;
        }
        if (null == this.configStorage) {
            this.httpClient = HttpClients.createDefault();
            return this.httpClient;
        }
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider(this.createCredentialsProvider(this.configStorage)).setSSLSocketFactory((LayeredConnectionSocketFactory)this.createSSL(this.configStorage)).setConnectionManager((HttpClientConnectionManager)this.connectionManager(this.configStorage)).build();
        if (null == this.connectionManager) {
            this.httpClient = httpClient;
            return this.httpClient;
        }
        return httpClient;
    }

    public HttpRequestTemplate(HttpConfigStorage configStorage) {
        this.setHttpConfigStorage(configStorage);
    }

    public HttpRequestTemplate() {
        this.setHttpConfigStorage(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLConnectionSocketFactory createSSL(HttpConfigStorage configStorage) {
        if (StringUtils.isEmpty(configStorage.getKeystore())) {
            try {
                return new SSLConnectionSocketFactory(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        try (InputStream instream = configStorage.isPath() ? new FileInputStream(new File(configStorage.getKeystore())) : new ByteArrayInputStream(configStorage.getKeystore().getBytes());){
            SSLConnectionSocketFactory sslsf;
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            char[] password = configStorage.getStorePassword().toCharArray();
            keyStore.load(instream, password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, password);
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password).build();
            SSLConnectionSocketFactory sSLConnectionSocketFactory = sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
            return sSLConnectionSocketFactory;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CredentialsProvider createCredentialsProvider(HttpConfigStorage configStorage) {
        if (StringUtils.isBlank(configStorage.getAuthUsername())) {
            return null;
        }
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(configStorage.getAuthUsername(), configStorage.getAuthPassword()));
        return credsProvider;
    }

    public PoolingHttpClientConnectionManager connectionManager(HttpConfigStorage configStorage) {
        if (null != this.connectionManager) {
            return this.connectionManager;
        }
        if (0 == configStorage.getMaxTotal() || 0 == configStorage.getDefaultMaxPerRoute()) {
            return null;
        }
        this.log.info((Object)String.format("Initialize the PoolingHttpClientConnectionManager -- maxTotal:%s, defaultMaxPerRoute:%s", configStorage.getMaxTotal(), configStorage.getDefaultMaxPerRoute()));
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)this.createSSL(configStorage)).register("http", (Object)new PlainConnectionSocketFactory()).build();
        this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        this.connectionManager.setMaxTotal(configStorage.getMaxTotal());
        this.connectionManager.setDefaultMaxPerRoute(configStorage.getDefaultMaxPerRoute());
        return this.connectionManager;
    }

    public HttpRequestTemplate setHttpConfigStorage(HttpConfigStorage configStorage) {
        this.configStorage = configStorage;
        if (null != configStorage && StringUtils.isNotBlank(configStorage.getHttpProxyHost())) {
            this.httpProxy = new HttpHost(configStorage.getHttpProxyHost(), configStorage.httpProxyPort);
        }
        return this;
    }

    public <T> T postForObject(String uri, Object request, Class<T> responseType, Object ... uriVariables) {
        return this.doExecute(URI.create(UriVariables.getUri(uri, uriVariables)), request, responseType, MethodType.POST);
    }

    public <T> T postForObject(String uri, Object request, Class<T> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(URI.create(UriVariables.getUri(uri, uriVariables)), request, responseType, MethodType.POST);
    }

    public <T> T postForObject(URI uri, Object request, Class<T> responseType) {
        return this.doExecute(uri, request, responseType, MethodType.POST);
    }

    public <T> T getForObject(String uri, Class<T> responseType, Object ... uriVariables) {
        return this.doExecute(URI.create(UriVariables.getUri(uri, uriVariables)), null, responseType, MethodType.GET);
    }

    public <T> T getForObject(String uri, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.doExecute(URI.create(UriVariables.getUri(uri, new Object[]{uriVariables})), null, responseType, MethodType.GET);
    }

    public <T> T getForObject(String uri, HttpHeader header, Class<T> responseType, Object ... uriVariables) {
        return this.doExecute(URI.create(UriVariables.getUri(uri, uriVariables)), (Object)header, responseType, MethodType.GET);
    }

    public <T> T getForObject(String uri, HttpHeader header, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.doExecute(URI.create(UriVariables.getUri(uri, new Object[]{uriVariables})), (Object)header, responseType, MethodType.GET);
    }

    /*
     * Exception decompiling
     */
    public <T> T doExecute(URI uri, Object request, Class<T> responseType, MethodType method) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> T doExecute(String uri, Object request, Class<T> responseType, MethodType method) {
        return this.doExecute(URI.create(uri), request, responseType, method);
    }
}

