/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpHeader;
import com.egzosn.pay.common.http.HttpStringEntity;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.XML;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class ClientHttpRequest<T>
extends HttpEntityEnclosingRequestBase
implements ResponseHandler<T> {
    protected final Log log = LogFactory.getLog(ClientHttpRequest.class);
    public static final ContentType APPLICATION_FORM_URLENCODED_UTF_8 = ContentType.create((String)"application/x-www-form-urlencoded", (Charset)Consts.UTF_8);
    private MethodType method;
    private Class<T> responseType;

    public ClientHttpRequest<T> setResponseType(Class<T> responseType) {
        this.responseType = responseType;
        return this;
    }

    public ClientHttpRequest() {
    }

    public ClientHttpRequest(URI uri, MethodType method, Object request) {
        this(uri, method);
        this.setParameters(request);
    }

    public ClientHttpRequest(URI uri, MethodType method) {
        this.setURI(uri);
        this.method = method;
    }

    public ClientHttpRequest(URI uri) {
        this.setURI(uri);
    }

    public ClientHttpRequest(String uri) {
        this.setURI(URI.create(uri));
    }

    public ClientHttpRequest(String uri, MethodType method) {
        this.setURI(URI.create(uri));
        this.method = method;
    }

    public ClientHttpRequest(String uri, MethodType method, Object request) {
        this(uri, method);
        this.setParameters(request);
    }

    public void setMethod(MethodType method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method.name();
    }

    public ClientHttpRequest setProxy(HttpHost httpProxy) {
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            this.setConfig(config);
        }
        return this;
    }

    public ClientHttpRequest setParameters(Object request) {
        if (null == request) {
            return this;
        }
        if (request instanceof HttpHeader) {
            HttpHeader entity = (HttpHeader)request;
            if (null != entity.getHeaders()) {
                this.log.debug((Object)("header : " + JSON.toJSONString(entity.getHeaders())));
                for (Header header : entity.getHeaders()) {
                    this.addHeader(header);
                }
            }
        } else if (request instanceof HttpStringEntity) {
            HttpStringEntity entity = (HttpStringEntity)((Object)request);
            if (!entity.isEmpty()) {
                this.setEntity((HttpEntity)entity);
            }
            if (null != entity.getHeaders()) {
                this.log.debug((Object)("header : " + JSON.toJSONString(entity.getHeaders())));
                for (Header header : entity.getHeaders()) {
                    this.addHeader(header);
                }
            }
        } else if (request instanceof HttpEntity) {
            this.setEntity((HttpEntity)request);
        } else if (request instanceof Map) {
            String parameters = UriVariables.getMapToParameters((Map)request);
            this.log.debug((Object)("Parameter : " + parameters));
            StringEntity entity = new StringEntity(parameters, APPLICATION_FORM_URLENCODED_UTF_8);
            this.setEntity((HttpEntity)entity);
        } else if (request instanceof String) {
            this.log.debug((Object)("Parameter : " + request));
            StringEntity entity = new StringEntity((String)request, APPLICATION_FORM_URLENCODED_UTF_8);
            this.setEntity((HttpEntity)entity);
        } else {
            String body = JSON.toJSONString((Object)request);
            this.log.debug((Object)("body : " + request));
            StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
            this.setEntity((HttpEntity)entity);
        }
        return this;
    }

    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        String[] value = null;
        value = null == entity.getContentType() ? new String[]{"application/x-www-form-urlencoded"} : entity.getContentType().getValue().split(";");
        if (statusLine.getStatusCode() >= 300 && statusLine.getStatusCode() != 304) {
            if (this.isJson(value[0], "") || this.isXml(value[0], "")) {
                return this.toBean(entity, value);
            }
            EntityUtils.consume((HttpEntity)entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        if (null == this.responseType) {
            this.responseType = String.class;
        }
        return this.toBean(entity, value);
    }

    private T toBean(HttpEntity entity, String[] contentType) throws IOException {
        if (this.isText(contentType[0])) {
            String charset = "UTF-8";
            if (null != contentType && 2 == charset.length()) {
                charset = contentType[1].substring(contentType[1].indexOf("=") + 1);
            }
            String result = EntityUtils.toString((HttpEntity)entity, (String)charset);
            if (this.responseType.isAssignableFrom(String.class)) {
                return (T)result;
            }
            String first = result.substring(0, 1);
            if (this.isJson(contentType[0], first)) {
                try {
                    return (T)JSON.parseObject((String)result, this.responseType);
                }
                catch (JSONException e) {
                    throw new PayErrorException(new PayException("failure", String.format("\u7c7b\u578b\u8f6c\u5316\u5f02\u5e38,contentType: %s\n%s", entity.getContentType().getValue(), e.getMessage()), result));
                }
            }
            if (this.isXml(contentType[0], first)) {
                return (T)XML.toJSONObject(result).toJavaObject(this.responseType);
            }
            throw new PayErrorException(new PayException("failure", "\u7c7b\u578b\u8f6c\u5316\u5f02\u5e38,contentType:" + entity.getContentType().getValue(), result));
        }
        if (InputStream.class.isAssignableFrom(this.responseType)) {
            return (T)entity.getContent();
        }
        if (OutputStream.class.isAssignableFrom(this.responseType)) {
            try {
                T t = this.responseType.newInstance();
                entity.writeTo((OutputStream)t);
                return t;
            }
            catch (InstantiationException e) {
                throw new PayErrorException(new PayException("InstantiationException", e.getMessage()));
            }
            catch (IllegalAccessException e) {
                throw new PayErrorException(new PayException("IllegalAccessException", e.getMessage()));
            }
        }
        throw new PayErrorException(new PayException("failure", "\u7c7b\u578b\u8f6c\u5316\u5f02\u5e38,contentType:" + entity.getContentType().getValue()));
    }

    private boolean isJson(String contentType, String textFirst) {
        return ContentType.APPLICATION_JSON.getMimeType().equals(contentType) || "{[".indexOf(textFirst) >= 0;
    }

    private boolean isText(String contentType) {
        return contentType.contains("xml") || contentType.contains("json") || contentType.contains("text") || contentType.contains("form-data") || contentType.contains("x-www-form-urlencoded");
    }

    private boolean isXml(String contentType, String textFirst) {
        return ContentType.APPLICATION_XML.getMimeType().equals(contentType) || "<".indexOf(textFirst) >= 0;
    }
}

