/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.resolver.Visitor;
import com.deepoove.poi.util.RegexUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;

public abstract class AbstractVisitor
implements Visitor {
    protected final Configure config;
    protected Pattern templatePattern;
    protected Pattern gramerPattern;
    private static final String FORMAT_TEMPLATE = "{0}{1}{2}{3}";
    private static final String FORMAT_GRAMER = "({0})|({1})";

    public AbstractVisitor(Configure config) {
        this.config = config;
        this.patternCreated();
    }

    private void patternCreated() {
        String sign = this.getGramarRegex(this.config);
        String prefix = RegexUtils.escapeExprSpecialWord(this.config.getGramerPrefix());
        String suffix = RegexUtils.escapeExprSpecialWord(this.config.getGramerSuffix());
        this.templatePattern = Pattern.compile(MessageFormat.format(FORMAT_TEMPLATE, prefix, sign, this.config.getGrammerRegex(), suffix));
        this.gramerPattern = Pattern.compile(MessageFormat.format(FORMAT_GRAMER, prefix, suffix));
    }

    private String getGramarRegex(Configure config) {
        String word;
        ArrayList<Character> gramerChar = new ArrayList<Character>(config.getGramerChars());
        StringBuilder reg = new StringBuilder("(");
        int i = 0;
        while (true) {
            Character chara = (Character)gramerChar.get(i);
            word = RegexUtils.escapeExprSpecialWord(chara.toString());
            if (i == gramerChar.size() - 1) break;
            reg.append(word).append("|");
            ++i;
        }
        reg.append(word).append(")?");
        return reg.toString();
    }
}

