/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.el;

import com.deepoove.poi.el.ELObject;
import com.deepoove.poi.el.FieldFinder;
import com.deepoove.poi.exception.ExpressionEvalException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class Dot {
    private String el;
    private Dot target;
    private String key;
    static final Pattern EL_PATTERN = Pattern.compile("^[^\\.]+(\\.[^\\.]+)*$");

    public Dot(String el) {
        Objects.requireNonNull(el, "EL cannot be null.");
        if (!EL_PATTERN.matcher(el).matches()) {
            throw new ExpressionEvalException("Error EL fomart: " + el);
        }
        this.el = el;
        int dotIndex = el.lastIndexOf(".");
        if (-1 == dotIndex) {
            this.key = el;
        } else {
            this.key = el.substring(dotIndex + 1);
            this.target = new Dot(el.substring(0, dotIndex));
        }
    }

    public Object eval(ELObject elObject) {
        Object result;
        if (elObject.cache.containsKey(this.el)) {
            return elObject.cache.get(this.el);
        }
        Object object = result = null != this.target ? (result = this.evalKey(this.target.eval(elObject))) : this.evalKey(elObject.model);
        if (null != result) {
            elObject.cache.put(this.el, result);
        }
        return result;
    }

    private Object evalKey(Object obj) {
        Objects.requireNonNull(obj, "Cannot read value from null Prefix-Model, Prefix-Model EL: " + this.target);
        Class<?> objClass = obj.getClass();
        if (obj instanceof String || obj instanceof Number || obj instanceof Date || obj instanceof Collection || objClass.isArray() || objClass.isPrimitive()) {
            throw new ExpressionEvalException("Prefix-Model must be JavaBean or Map, Prefix-Model EL: " + this.target + ", Prefix-Model type: " + objClass);
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(this.key);
        }
        Field field = FieldFinder.find(objClass, this.key);
        if (null == field) {
            throw new ExpressionEvalException("Cannot find the key:" + this.key + " from Prefix-Model EL:" + this.target);
        }
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            throw new ExpressionEvalException("Error read the property:" + this.key + " from " + objClass);
        }
    }

    public String getEl() {
        return this.el;
    }

    public Dot getTarget() {
        return this.target;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return null == this.el ? "[root el]" : this.el;
    }
}

