/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.resolver.RunningRunParagraph;
import com.deepoove.poi.resolver.TemplateFactory;
import com.deepoove.poi.resolver.Visitor;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.util.RegexUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateVisitor
implements Visitor {
    private static Logger logger = LoggerFactory.getLogger(TemplateVisitor.class);
    private Configure config;
    private List<ElementTemplate> eleTemplates;
    private Pattern templatePattern;
    private Pattern gramerPattern;
    static final String FORMAT_TEMPLATE = "{0}{1}{2}{3}";
    static final String FORMAT_GRAMER = "({0})|({1})";

    public TemplateVisitor(Configure config) {
        this.config = config;
        this.initPattern();
    }

    @Override
    public List<ElementTemplate> visitDocument(XWPFDocument doc) {
        if (null == doc) {
            return null;
        }
        this.eleTemplates = new ArrayList<ElementTemplate>();
        logger.info("Visit the document start...");
        this.visitParagraphs(doc.getParagraphs());
        this.visitTables(doc.getTables());
        this.visitHeaders(doc.getHeaderList());
        this.visitFooters(doc.getFooterList());
        logger.info("Visit the document end, resolve and create {} ElementTemplates.", (Object)this.eleTemplates.size());
        return this.eleTemplates;
    }

    void visitHeaders(List<XWPFHeader> headers) {
        if (null == headers) {
            return;
        }
        for (XWPFHeader header : headers) {
            this.visitParagraphs(header.getParagraphs());
            this.visitTables(header.getTables());
        }
    }

    void visitFooters(List<XWPFFooter> footers) {
        if (null == footers) {
            return;
        }
        for (XWPFFooter footer : footers) {
            this.visitParagraphs(footer.getParagraphs());
            this.visitTables(footer.getTables());
        }
    }

    void visitParagraphs(List<XWPFParagraph> paragraphs) {
        if (null == paragraphs) {
            return;
        }
        for (XWPFParagraph paragraph : paragraphs) {
            this.visitParagraph(paragraph);
        }
    }

    void visitTables(List<XWPFTable> tables) {
        if (null == tables) {
            return;
        }
        for (XWPFTable tb : tables) {
            this.visitTable(tb);
        }
    }

    void visitTable(XWPFTable table) {
        if (null == table) {
            return;
        }
        List rows = table.getRows();
        if (null == rows) {
            return;
        }
        for (XWPFTableRow row : rows) {
            List cells = row.getTableCells();
            if (null == cells) continue;
            for (XWPFTableCell cell : cells) {
                this.visitParagraphs(cell.getParagraphs());
                this.visitTables(cell.getTables());
            }
        }
    }

    void visitParagraph(XWPFParagraph paragraph) {
        if (null == paragraph) {
            return;
        }
        RunningRunParagraph runningRun = new RunningRunParagraph(paragraph, this.templatePattern);
        List<XWPFRun> refactorRun = runningRun.refactorRun();
        if (null == refactorRun) {
            return;
        }
        for (XWPFRun run : refactorRun) {
            this.visitRun(run);
        }
    }

    void visitRun(XWPFRun run) {
        String text = null;
        if (null == run || StringUtils.isBlank((CharSequence)(text = run.getText(0)))) {
            return;
        }
        ElementTemplate elementTemplate = this.parseTemplateFactory(text, run);
        if (null != elementTemplate) {
            this.eleTemplates.add(elementTemplate);
        }
    }

    private <T> ElementTemplate parseTemplateFactory(String text, T obj) {
        logger.debug("Resolve text: {}, and create ElementTemplate", (Object)text);
        if (this.templatePattern.matcher(text).matches()) {
            String tag = this.gramerPattern.matcher(text).replaceAll("").trim();
            if (obj.getClass() == XWPFRun.class) {
                return TemplateFactory.createRunTemplate(tag, this.config, (XWPFRun)obj);
            }
            if (obj.getClass() == XWPFTableCell.class) {
                return null;
            }
        }
        return null;
    }

    private void initPattern() {
        String signRegex = this.getGramarRegex(this.config);
        String prefixRegex = RegexUtils.escapeExprSpecialWord(this.config.getGramerPrefix());
        String suffixRegex = RegexUtils.escapeExprSpecialWord(this.config.getGramerSuffix());
        this.templatePattern = Pattern.compile(MessageFormat.format(FORMAT_TEMPLATE, prefixRegex, signRegex, this.config.getGrammerRegex(), suffixRegex));
        this.gramerPattern = Pattern.compile(MessageFormat.format(FORMAT_GRAMER, prefixRegex, suffixRegex));
    }

    private String getGramarRegex(Configure config) {
        String escapeExprSpecialWord;
        ArrayList<Character> gramerChar = new ArrayList<Character>(config.getGramerChars());
        StringBuilder reg = new StringBuilder("(");
        int i = 0;
        while (true) {
            Character chara = (Character)gramerChar.get(i);
            escapeExprSpecialWord = RegexUtils.escapeExprSpecialWord(chara.toString());
            if (i == gramerChar.size() - 1) break;
            reg.append(escapeExprSpecialWord).append("|");
            ++i;
        }
        reg.append(escapeExprSpecialWord).append(")?");
        return reg.toString();
    }
}

