/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.config;

import com.deepoove.poi.config.ELMode;
import com.deepoove.poi.config.GramerSymbol;
import com.deepoove.poi.policy.DocxRenderPolicy;
import com.deepoove.poi.policy.MiniTableRenderPolicy;
import com.deepoove.poi.policy.NumbericRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.util.RegexUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Configure {
    private static final String DEFAULT_GRAMER_REGEX = "[\\w\\u4e00-\\u9fa5]+(\\.[\\w\\u4e00-\\u9fa5]+)*";
    private Map<String, RenderPolicy> customPolicys = new HashMap<String, RenderPolicy>();
    private Map<Character, RenderPolicy> defaultPolicys = new HashMap<Character, RenderPolicy>();
    private String gramerPrefix = "{{";
    private String gramerSuffix = "}}";
    private String grammerRegex = "[\\w\\u4e00-\\u9fa5]+(\\.[\\w\\u4e00-\\u9fa5]+)*";
    private ELMode elMode = ELMode.POI_TL_STANDARD_MODE;
    private boolean nullToBlank = true;

    private Configure() {
        this.plugin(GramerSymbol.TEXT, (RenderPolicy)new TextRenderPolicy());
        this.plugin(GramerSymbol.IMAGE, (RenderPolicy)new PictureRenderPolicy());
        this.plugin(GramerSymbol.TABLE, (RenderPolicy)new MiniTableRenderPolicy());
        this.plugin(GramerSymbol.NUMBERIC, (RenderPolicy)new NumbericRenderPolicy());
        this.plugin(GramerSymbol.DOCX_TEMPLATE, (RenderPolicy)new DocxRenderPolicy());
    }

    public static Configure createDefault() {
        return Configure.newBuilder().build();
    }

    public static ConfigureBuilder newBuilder() {
        return new ConfigureBuilder();
    }

    public Configure plugin(char c, RenderPolicy policy) {
        this.defaultPolicys.put(Character.valueOf(c), policy);
        return this;
    }

    Configure plugin(GramerSymbol symbol, RenderPolicy policy) {
        this.defaultPolicys.put(Character.valueOf(symbol.getSymbol()), policy);
        return this;
    }

    public void customPolicy(String tagName, RenderPolicy policy) {
        this.customPolicys.put(tagName, policy);
    }

    public RenderPolicy getPolicy(String tagName, Character sign) {
        RenderPolicy policy = this.getCustomPolicy(tagName);
        return null == policy ? this.getDefaultPolicy(sign) : policy;
    }

    public Map<Character, RenderPolicy> getDefaultPolicys() {
        return this.defaultPolicys;
    }

    public Map<String, RenderPolicy> getCustomPolicys() {
        return this.customPolicys;
    }

    public Set<Character> getGramerChars() {
        return this.defaultPolicys.keySet();
    }

    public String getGramerPrefix() {
        return this.gramerPrefix;
    }

    public String getGramerSuffix() {
        return this.gramerSuffix;
    }

    private RenderPolicy getCustomPolicy(String tagName) {
        return this.customPolicys.get(tagName);
    }

    private RenderPolicy getDefaultPolicy(Character sign) {
        return this.defaultPolicys.get(sign);
    }

    public String getGrammerRegex() {
        return this.grammerRegex;
    }

    public ELMode getElMode() {
        return this.elMode;
    }

    public boolean isNullToBlank() {
        return this.nullToBlank;
    }

    public static class ConfigureBuilder {
        private static String regexForAllPattern = "((?!{0})(?!{1}).)*";
        private boolean regexForAll;
        private Configure config = new Configure();

        public ConfigureBuilder buildGramer(String prefix, String suffix) {
            this.config.gramerPrefix = prefix;
            this.config.gramerSuffix = suffix;
            return this;
        }

        public ConfigureBuilder setElMode(ELMode mode) {
            this.config.elMode = mode;
            return this;
        }

        public ConfigureBuilder buildGrammerRegex(String reg) {
            this.config.grammerRegex = reg;
            return this;
        }

        public ConfigureBuilder supportGrammerRegexForAll() {
            this.regexForAll = true;
            return this;
        }

        public ConfigureBuilder supportNullToBlank(boolean nullToBlank) {
            this.config.nullToBlank = nullToBlank;
            return this;
        }

        public ConfigureBuilder addPlugin(char c, RenderPolicy policy) {
            this.config.plugin(c, policy);
            return this;
        }

        public ConfigureBuilder customPolicy(String tagName, RenderPolicy policy) {
            this.config.customPolicy(tagName, policy);
            return this;
        }

        public Configure build() {
            if (this.config.elMode == ELMode.SPEL_MODE) {
                this.supportGrammerRegexForAll();
            }
            if (this.regexForAll) {
                this.buildGrammerRegex(MessageFormat.format(regexForAllPattern, RegexUtils.escapeExprSpecialWord(this.config.gramerPrefix), RegexUtils.escapeExprSpecialWord(this.config.gramerSuffix)));
            }
            return this.config;
        }
    }
}

