/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.http;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.common.ParamValidEnum;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.exception.BusinessException;
import com.dahuatech.icc.oauth.http.IccHttpHttpRequest;
import com.dahuatech.icc.oauth.http.IccResponse;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigBaseInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigUserPwdInfo;
import com.dahuatech.icc.oauth.profile.GrantType;
import com.dahuatech.icc.util.StringUtils;
import java.util.Map;

public abstract class AbstractIccRequest<T extends IccResponse>
extends IccHttpHttpRequest {
    protected OauthConfigBaseInfo oauthConfigBaseInfo;

    public OauthConfigBaseInfo getOauthConfigBaseInfo() {
        return this.oauthConfigBaseInfo;
    }

    public void setOauthConfigBaseInfo(OauthConfigBaseInfo oauthConfigBaseInfo) {
        this.oauthConfigBaseInfo = oauthConfigBaseInfo;
    }

    public AbstractIccRequest() {
    }

    public void valid() {
        this.baseCheck();
    }

    public void baseCheck() {
        if (this == null) {
            throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u8bf7\u6c42\u5bf9\u8c61\u4e3a\u7a7a", "GroupInfoAddRequest");
        }
        if (this.oauthConfigBaseInfo == null) {
            throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u9274\u6743\u4fe1\u606f\u4e3a\u7a7a", "oauthConfigBaseInfo");
        }
        if (this.oauthConfigBaseInfo.getGrantType() == null) {
            throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u9274\u6743\u7c7b\u578b\u4e3a\u7a7a", "grantType");
        }
        if (StringUtils.isEmpty((String)this.oauthConfigBaseInfo.getClientId())) {
            throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u7533\u8bf7\u8bbf\u95ee\u51ed\u8bc1id\u4e3a\u7a7a", "clientId");
        }
        if (StringUtils.isEmpty((String)this.oauthConfigBaseInfo.getClientSecret())) {
            throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u7533\u8bf7\u8bbf\u95ee\u51ed\u8bc1\u5bc6\u94a5\u4e3a\u7a7a", "clientSecret");
        }
        if (this.oauthConfigBaseInfo.getHttpConfigInfo() == null) {
            throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u5e73\u53f0\u4fe1\u606f\u4e3a\u7a7a", "httpConfigInfo");
        }
        if (StringUtils.isEmpty((String)this.oauthConfigBaseInfo.getHttpConfigInfo().getHost())) {
            throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u5e73\u53f0\u4fe1\u606f|host\u4e3a\u7a7a", "host");
        }
        if (this.oauthConfigBaseInfo.getGrantType() == GrantType.password) {
            OauthConfigUserPwdInfo oauthConfigUserPwdInfo = (OauthConfigUserPwdInfo)this.oauthConfigBaseInfo;
            if (StringUtils.isEmpty((String)oauthConfigUserPwdInfo.getPassword())) {
                throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u5e73\u53f0\u4fe1\u606f|\u5bc6\u7801\u4e3a\u7a7a", "password");
            }
            if (StringUtils.isEmpty((String)oauthConfigUserPwdInfo.getUsername())) {
                throw new BusinessException(ParamValidEnum.OAUTH_PARAM_NOT_EMPTY_ERROR.getCode(), "\u5e73\u53f0\u4fe1\u606f|\u7528\u6237\u540d\u4e3a\u7a7a", "username");
            }
        }
    }

    public AbstractIccRequest(String url, Method method) {
        super(url, method, Boolean.TRUE);
    }

    public AbstractIccRequest(String url, Method method, boolean needAuth) {
        super(url, method, needAuth);
    }

    public AbstractIccRequest(String url, Method method, boolean needAuth, String body) throws ClientException {
        super(url, method, needAuth, body);
    }

    protected void putBodyParameter(String name, Object value) {
        this.setParameter(this.bodyParameters, name, value);
    }

    protected void setParameter(Map<String, Object> map, String name, Object value) {
        if (null == map || name == null || value == null) {
            return;
        }
        map.put(name, value);
    }

    public abstract Class<T> getResponseClass();
}

