/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.handle;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.exception.ServerException;
import com.dahuatech.icc.oauth.constant.OauthConstant;
import com.dahuatech.icc.oauth.http.IccClient;
import com.dahuatech.icc.oauth.http.IccHttpHttpRequest;
import com.dahuatech.icc.oauth.http.IccTokenResponse;
import com.dahuatech.icc.oauth.model.v202010.BrmKeepAliveRequest;
import com.dahuatech.icc.oauth.model.v202010.BrmKeepAliveResponse;
import com.dahuatech.icc.oauth.model.v202010.HttpConfigInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigBaseInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigClientInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigUserPwdInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthPublicKeyResponse;
import com.dahuatech.icc.oauth.model.v202010.OauthRefreshTokenRequest;
import com.dahuatech.icc.oauth.model.v202010.OauthRefreshTokenResponse;
import com.dahuatech.icc.oauth.profile.GrantType;
import com.dahuatech.icc.oauth.profile.IccProfile;
import com.dahuatech.icc.util.BeanUtil;
import com.dahuatech.icc.util.SignUtil;
import java.util.HashMap;
import java.util.Map;

public class OauthProcessor {
    private static final Log logger = LogFactory.get();

    public IccTokenResponse.IccToken oauth(OauthConfigBaseInfo oauthConfigBaseInfo) throws ClientException {
        if (oauthConfigBaseInfo.getGrantType() == GrantType.password) {
            return this.password((OauthConfigUserPwdInfo)oauthConfigBaseInfo);
        }
        return this.clientCredentials((OauthConfigClientInfo)oauthConfigBaseInfo);
    }

    private IccTokenResponse.IccToken password(OauthConfigUserPwdInfo oauthConfigUserPwdInfo) throws ClientException, ServerException {
        IccHttpHttpRequest pubRequest = new IccHttpHttpRequest(OauthConstant.url(oauthConfigUserPwdInfo.getHttpConfigInfo(), "/evo-apigw/evo-oauth/%s/oauth/public-key"), Method.GET);
        String pubBody = pubRequest.execute();
        OauthPublicKeyResponse keyResp = (OauthPublicKeyResponse)BeanUtil.toBean((String)pubBody, OauthPublicKeyResponse.class);
        if (keyResp.getData() == null) {
            logger.error("get public key faiure [{}]", new Object[]{"/evo-apigw/evo-oauth/%s/oauth/public-key"});
            throw new ServerException("get public key faiure");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("grant_type", oauthConfigUserPwdInfo.getGrantType().name());
        map.put("username", oauthConfigUserPwdInfo.getUsername());
        map.put("password", SignUtil.encryptRSANew((String)oauthConfigUserPwdInfo.getPassword(), (String)keyResp.getData().getPublicKey()));
        map.put("client_id", oauthConfigUserPwdInfo.getClientId());
        map.put("client_secret", oauthConfigUserPwdInfo.getClientSecret());
        map.put("public_key", keyResp.getData().getPublicKey());
        return this.oauth(map, oauthConfigUserPwdInfo.getHttpConfigInfo());
    }

    private IccTokenResponse.IccToken clientCredentials(OauthConfigClientInfo oauthConfigClientInfo) throws ClientException, ServerException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("grant_type", "client_credentials");
        map.put("client_id", oauthConfigClientInfo.getClientId());
        map.put("client_secret", oauthConfigClientInfo.getClientSecret());
        return this.oauth(map, oauthConfigClientInfo.getHttpConfigInfo());
    }

    private IccTokenResponse.IccToken oauth(Map<String, Object> map, HttpConfigInfo httpConfigInfo) throws ClientException {
        IccHttpHttpRequest pr = new IccHttpHttpRequest(OauthConstant.url(httpConfigInfo, "/evo-apigw/evo-oauth/%s/oauth/extend/token"), Method.POST, JSONUtil.toJsonStr(map));
        String prBody = pr.execute();
        IccTokenResponse token = (IccTokenResponse)BeanUtil.toBean((String)prBody, IccTokenResponse.class);
        if (token == null || !token.isSuccess()) {
            logger.error(" auth failure [{}] reason [{}]", new Object[]{OauthConstant.url(httpConfigInfo, "/evo-apigw/evo-oauth/%s/oauth/extend/token"), token == null ? "" : token.getErrMsg()});
            throw new ClientException("GrantType [password] username=[" + IccProfile.username + "],password=[" + IccProfile.password + "] get access_token failure");
        }
        IccTokenResponse.IccToken iccToken = token.getData();
        iccToken.setTtl(System.currentTimeMillis() + iccToken.getExpires_in() * 1000L);
        return iccToken;
    }

    public BrmKeepAliveResponse keepAlive(OauthConfigBaseInfo oauthConfigBaseInfo, String magicId, OauthConstant.ClientType type) throws ClientException {
        IccClient iClient = new IccClient(oauthConfigBaseInfo);
        BrmKeepAliveRequest request = new BrmKeepAliveRequest(oauthConfigBaseInfo.getHttpConfigInfo());
        request.setMagicId(magicId);
        request.setClientType(type.getClientType());
        BrmKeepAliveResponse brmKeepAliveResponse = iClient.doAction(request, request.getResponseClass());
        return brmKeepAliveResponse;
    }

    public OauthRefreshTokenResponse refreshToken(OauthConfigBaseInfo oauthConfigBaseInfo, String refreshToken) throws ClientException {
        IccClient iClient = new IccClient(oauthConfigBaseInfo);
        OauthRefreshTokenRequest oauthRefreshTokenRequest = new OauthRefreshTokenRequest(oauthConfigBaseInfo.getHttpConfigInfo());
        oauthRefreshTokenRequest.setClient_id(oauthConfigBaseInfo.getClientId());
        oauthRefreshTokenRequest.setClient_secret(oauthConfigBaseInfo.getClientSecret());
        oauthRefreshTokenRequest.setGrant_type(GrantType.refresh_token.name());
        oauthRefreshTokenRequest.setRefresh_token(refreshToken);
        OauthRefreshTokenResponse oauthRefreshTokenResponse = iClient.doAction(oauthRefreshTokenRequest, oauthRefreshTokenRequest.getResponseClass());
        return oauthRefreshTokenResponse;
    }

    public static synchronized OauthProcessor getIntance() {
        return SingleHolder.INSTANCE;
    }

    private static class SingleHolder {
        private static final OauthProcessor INSTANCE = new OauthProcessor();

        private SingleHolder() {
        }
    }
}

