/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.map;

import com.dahuatech.hutool.core.collection.CollectionUtil;
import com.dahuatech.hutool.core.convert.Convert;
import com.dahuatech.hutool.core.lang.Editor;
import com.dahuatech.hutool.core.lang.Filter;
import com.dahuatech.hutool.core.lang.TypeReference;
import com.dahuatech.hutool.core.map.CamelCaseLinkedMap;
import com.dahuatech.hutool.core.map.CamelCaseMap;
import com.dahuatech.hutool.core.map.MapBuilder;
import com.dahuatech.hutool.core.map.MapProxy;
import com.dahuatech.hutool.core.map.MapWrapper;
import com.dahuatech.hutool.core.util.ArrayUtil;
import com.dahuatech.hutool.core.util.ObjectUtil;
import com.dahuatech.hutool.core.util.ReflectUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static <K, V> Map<K, V> emptyIfNull(Map<K, V> set) {
        return null == set ? Collections.emptyMap() : set;
    }

    public static <T extends Map<K, V>, K, V> T defaultIfEmpty(T map, T defaultMap) {
        return MapUtil.isEmpty(map) ? defaultMap : map;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isOrder ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isOrder) {
        return MapUtil.newHashMap(16, isOrder);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (!MapUtil.isEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K, V> Map<K, V> newIdentityMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap(16);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int size) {
        int initCapacity = size <= 0 ? 16 : size;
        return new ConcurrentHashMap(initCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> map) {
        if (MapUtil.isEmpty(map)) {
            return new ConcurrentHashMap(16);
        }
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        return (Map)ReflectUtil.newInstance(mapType, new Object[0]);
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return MapUtil.of(key, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        HashMap<K, V> map = MapUtil.newHashMap(isOrder);
        map.put(key, value);
        return map;
    }

    public static HashMap<Object, Object> of(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object value;
            Object key;
            Iterator iter;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            if (object instanceof Iterator) {
                iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, object));
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        HashMap<K, ArrayList<Object>> resultMap = new HashMap<K, ArrayList<Object>>();
        if (CollectionUtil.isEmpty(mapList)) {
            return resultMap;
        }
        for (Map<K, V> map : mapList) {
            Set<Map.Entry<K, V>> entrySet = map.entrySet();
            for (Map.Entry<K, V> entry : entrySet) {
                K key = entry.getKey();
                ArrayList<Object> valueList = (ArrayList<Object>)resultMap.get(key);
                if (null == valueList) {
                    valueList = CollectionUtil.newArrayList(entry.getValue());
                    resultMap.put(key, valueList);
                    continue;
                }
                valueList.add(entry.getValue());
            }
        }
        return resultMap;
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        boolean isEnd;
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        if (MapUtil.isEmpty(listMap)) {
            return resultList;
        }
        int index = 0;
        do {
            isEnd = true;
            HashMap map = new HashMap();
            for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
                ArrayList<V> vList = CollectionUtil.newArrayList(entry.getValue());
                int vListSize = vList.size();
                if (index >= vListSize) continue;
                map.put(entry.getKey(), vList.get(index));
                if (index == vListSize - 1) continue;
                isEnd = false;
            }
            if (!map.isEmpty()) {
                resultList.add(map);
            }
            ++index;
        } while (!isEnd);
        return resultList;
    }

    public static <K, V> Map<K, V> toCamelCaseMap(Map<K, V> map) {
        return map instanceof LinkedHashMap ? new CamelCaseLinkedMap<K, V>(map) : new CamelCaseMap<K, V>(map);
    }

    public static Object[][] toObjectArray(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Object[][] result = new Object[map.size()][2];
        if (map.isEmpty()) {
            return result;
        }
        int index = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result[index][0] = entry.getKey();
            result[index][1] = entry.getValue();
            ++index;
        }
        return result;
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator) {
        return MapUtil.join(map, separator, keyValueSeparator, false);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator) {
        return MapUtil.join(map, separator, keyValueSeparator, true);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull) {
        StringBuilder strBuilder = StrUtil.builder();
        boolean isFirst = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (isIgnoreNull && (entry.getKey() == null || entry.getValue() == null)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                strBuilder.append(separator);
            }
            strBuilder.append(Convert.toStr(entry.getKey())).append(keyValueSeparator).append(Convert.toStr(entry.getValue()));
        }
        return strBuilder.toString();
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        if (null == map || null == editor) {
            return map;
        }
        Map<K, V> map2 = ObjectUtil.clone(map);
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry<K, V> modified = editor.edit(entry);
            if (null == modified) continue;
            map2.put(modified.getKey(), modified.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        if (null == map || null == filter) {
            return map;
        }
        Map<K, V> map2 = ObjectUtil.clone(map);
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.accept(entry)) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, K ... keys) {
        Map<K, V> map2 = ObjectUtil.clone(map);
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (K key : keys) {
            if (!map.containsKey(key)) continue;
            map2.put(key, map.get(key));
        }
        return map2;
    }

    public static <T> Map<T, T> reverse(Map<T, T> map) {
        return MapUtil.filter(map, new Editor<Map.Entry<T, T>>(){

            @Override
            public Map.Entry<T, T> edit(final Map.Entry<T, T> t) {
                return new Map.Entry<T, T>(){

                    @Override
                    public T getKey() {
                        return t.getValue();
                    }

                    @Override
                    public T getValue() {
                        return t.getKey();
                    }

                    @Override
                    public T setValue(T value) {
                        throw new UnsupportedOperationException("Unsupported setValue method !");
                    }
                };
            }
        });
    }

    @Deprecated
    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        AbstractMap inverseMap = map instanceof LinkedHashMap ? new LinkedHashMap(map.size()) : (map instanceof TreeMap ? new TreeMap() : new HashMap(map.size()));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverseMap.put(entry.getValue(), entry.getKey());
        }
        return inverseMap;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map) {
        return MapUtil.sort(map, null);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result;
        if (map instanceof TreeMap) {
            result = (TreeMap<K, V>)map;
            if (null == comparator || comparator.equals(result.comparator())) {
                return result;
            }
        } else {
            result = MapUtil.newTreeMap(map, comparator);
        }
        return result;
    }

    public static MapProxy createProxy(Map<?, ?> map) {
        return MapProxy.create(map);
    }

    public static <K, V> MapWrapper<K, V> wrap(Map<K, V> map) {
        return new MapWrapper<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapUtil.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        return MapUtil.builder(new HashMap()).put(k, v);
    }

    public static <K, V> Map<K, V> getAny(Map<K, V> map, final K ... keys) {
        return MapUtil.filter(map, new Filter<Map.Entry<K, V>>(){

            @Override
            public boolean accept(Map.Entry<K, V> entry) {
                return ArrayUtil.contains(keys, entry.getKey());
            }
        });
    }

    public static String getStr(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, String.class);
    }

    public static Integer getInt(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Integer.class);
    }

    public static Double getDouble(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Double.class);
    }

    public static Float getFloat(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Float.class);
    }

    public static Short getShort(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Short.class);
    }

    public static Boolean getBool(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Boolean.class);
    }

    public static Character getChar(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Character.class);
    }

    public static Long getLong(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Long.class);
    }

    public static Date getDate(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Date.class);
    }

    public static <T> T get(Map<?, ?> map, Object key, Class<T> type) {
        return null == map ? null : (T)Convert.convert(type, map.get(key));
    }

    public static <T> T get(Map<?, ?> map, Object key, TypeReference<T> type) {
        return null == map ? null : (T)Convert.convert(type, map.get(key));
    }

    public static <K, V> Map<K, V> renameKey(Map<K, V> map, K oldKey, K newKey) {
        if (MapUtil.isNotEmpty(map) && map.containsKey(oldKey)) {
            if (map.containsKey(newKey)) {
                throw new IllegalArgumentException(StrUtil.format((CharSequence)"The key '{}' exist !", newKey));
            }
            map.put(newKey, map.remove(oldKey));
        }
        return map;
    }

    public static <K, V> Map<K, V> removeNullValue(Map<K, V> map) {
        if (MapUtil.isEmpty(map)) {
            return map;
        }
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            if (null != entry.getValue()) continue;
            iter.remove();
        }
        return map;
    }
}

