/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.convert;

import com.dahuatech.hutool.core.util.StrUtil;

public class NumberWordFormater {
    private static final String[] NUMBER = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
    private static final String[] NUMBER_TEEN = new String[]{"TEN", "ELEVEN", "TWELEVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
    private static final String[] NUMBER_TEN = new String[]{"TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
    private static final String[] NUMBER_MORE = new String[]{"", "THOUSAND", "MILLION", "BILLION"};

    public static String format(Object x) {
        if (x != null) {
            return NumberWordFormater.format(x.toString());
        }
        return "";
    }

    private static String format(String x) {
        int z = x.indexOf(".");
        String lstr = "";
        String rstr = "";
        if (z > -1) {
            lstr = x.substring(0, z);
            rstr = x.substring(z + 1);
        } else {
            lstr = x;
        }
        String lstrrev = StrUtil.reverse(lstr);
        String[] a = new String[5];
        switch (lstrrev.length() % 3) {
            case 1: {
                lstrrev = lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = lstrrev + "0";
            }
        }
        String lm = "";
        for (int i = 0; i < lstrrev.length() / 3; ++i) {
            a[i] = StrUtil.reverse(lstrrev.substring(3 * i, 3 * i + 3));
            if (!a[i].equals("000")) {
                if (i != 0) {
                    lm = NumberWordFormater.transThree(a[i]) + " " + NumberWordFormater.parseMore(String.valueOf(i)) + " " + lm;
                    continue;
                }
                lm = NumberWordFormater.transThree(a[i]);
                continue;
            }
            lm = lm + NumberWordFormater.transThree(a[i]);
        }
        String xs = "";
        if (z > -1) {
            xs = "AND CENTS " + NumberWordFormater.transTwo(rstr) + " ";
        }
        return lm.trim() + " " + xs + "ONLY";
    }

    private static String parseFirst(String s) {
        return NUMBER[Integer.parseInt(s.substring(s.length() - 1))];
    }

    private static String parseTeen(String s) {
        return NUMBER_TEEN[Integer.parseInt(s) - 10];
    }

    private static String parseTen(String s) {
        return NUMBER_TEN[Integer.parseInt(s.substring(0, 1)) - 1];
    }

    private static String parseMore(String s) {
        return NUMBER_MORE[Integer.parseInt(s)];
    }

    private static String transTwo(String s) {
        String value = "";
        if (s.length() > 2) {
            s = s.substring(0, 2);
        } else if (s.length() < 2) {
            s = "0" + s;
        }
        value = s.startsWith("0") ? NumberWordFormater.parseFirst(s) : (s.startsWith("1") ? NumberWordFormater.parseTeen(s) : (s.endsWith("0") ? NumberWordFormater.parseTen(s) : NumberWordFormater.parseTen(s) + " " + NumberWordFormater.parseFirst(s)));
        return value;
    }

    private static String transThree(String s) {
        String value = "";
        value = s.startsWith("0") ? NumberWordFormater.transTwo(s.substring(1)) : (s.substring(1).equals("00") ? NumberWordFormater.parseFirst(s.substring(0, 1)) + " HUNDRED" : NumberWordFormater.parseFirst(s.substring(0, 1)) + " HUNDRED AND " + NumberWordFormater.transTwo(s.substring(1)));
        return value;
    }
}

