/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.AbstractCondition;
import com.conversantmedia.util.concurrent.AbstractSpinningCondition;
import com.conversantmedia.util.concurrent.AbstractWaitingCondition;
import com.conversantmedia.util.concurrent.Condition;
import com.conversantmedia.util.concurrent.MultithreadConcurrentQueue;
import com.conversantmedia.util.concurrent.SpinPolicy;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public final class DisruptorBlockingQueue<E>
extends MultithreadConcurrentQueue<E>
implements Serializable,
Iterable<E>,
Collection<E>,
BlockingQueue<E>,
Queue<E> {
    protected final Condition queueNotFullCondition;
    protected final Condition queueNotEmptyCondition;

    public DisruptorBlockingQueue(int capacity) {
        this(capacity, SpinPolicy.WAITING);
    }

    public DisruptorBlockingQueue(int capacity, SpinPolicy spinPolicy) {
        super(capacity);
        switch (spinPolicy) {
            case BLOCKING: {
                this.queueNotFullCondition = new QueueNotFull();
                this.queueNotEmptyCondition = new QueueNotEmpty();
                break;
            }
            case SPINNING: {
                this.queueNotFullCondition = new SpinningQueueNotFull();
                this.queueNotEmptyCondition = new SpinningQueueNotEmpty();
                break;
            }
            default: {
                this.queueNotFullCondition = new WaitingQueueNotFull();
                this.queueNotEmptyCondition = new WaitingQueueNotEmpty();
            }
        }
    }

    public DisruptorBlockingQueue(int capacity, Collection<? extends E> c) {
        this(capacity);
        for (E e : c) {
            this.offer(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean offer(E e) {
        try {
            boolean bl = super.offer(e);
            return bl;
        }
        finally {
            this.queueNotEmptyCondition.signal();
        }
    }

    @Override
    public final E poll() {
        Object e = super.poll();
        this.queueNotFullCondition.signal();
        return e;
    }

    @Override
    public int remove(E[] e) {
        int n = super.remove(e);
        this.queueNotFullCondition.signal();
        return n;
    }

    @Override
    public E remove() {
        return this.poll();
    }

    @Override
    public E element() {
        Object val = this.peek();
        if (val != null) {
            return val;
        }
        throw new NoSuchElementException("No element found.");
    }

    @Override
    public void put(E e) throws InterruptedException {
        while (!this.offer(e)) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.queueNotFullCondition.await();
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        do {
            if (!this.offer(e)) continue;
            return true;
        } while (AbstractCondition.waitStatus(timeout, unit, this.queueNotFullCondition));
        return false;
    }

    @Override
    public E take() throws InterruptedException {
        E pollObj;
        while ((pollObj = this.poll()) == null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.queueNotEmptyCondition.await();
        }
        return pollObj;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        do {
            E pollObj;
            if ((pollObj = this.poll()) == null) continue;
            return pollObj;
        } while (AbstractCondition.waitStatus(timeout, unit, this.queueNotEmptyCondition));
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.queueNotFullCondition.signal();
    }

    @Override
    public int remainingCapacity() {
        return this.size - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, this.size());
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (this == c) {
            throw new IllegalArgumentException("Can not drain to self.");
        }
        Object[] pollObj = new Object[Math.min(this.size(), maxElements)];
        int nEle = this.remove(pollObj);
        int nRead = 0;
        for (int i = 0; i < nEle; ++i) {
            if (!c.add(pollObj[i])) continue;
            ++nRead;
        }
        return nRead;
    }

    @Override
    public Object[] toArray() {
        Object[] e = new Object[this.size()];
        this.toArray(e);
        return e;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.remove(a);
        return a;
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("queue is full");
    }

    @Override
    public boolean remove(Object o) {
        long tail;
        long head;
        while (!this.headCursor.compareAndSet(head = this.head.get(), head + 1L)) {
        }
        while (!this.tailCursor.compareAndSet(tail = this.tail.get(), tail + 1L)) {
        }
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            int slot = (int)(this.head.get() + (long)i & this.mask);
            if (this.buffer[slot] == null || !this.buffer[slot].equals(o)) continue;
            ++n;
            for (int j = i; j > 0; --j) {
                int cSlot = (int)(this.head.get() + (long)j - 1L & this.mask);
                int nextSlot = (int)(this.head.get() + (long)j & this.mask);
                this.buffer[nextSlot] = this.buffer[cSlot];
            }
        }
        if (n > 0) {
            this.headCursor.set(head + (long)n);
            this.tailCursor.set(tail);
            this.head.set(head + (long)n);
            this.queueNotFullCondition.signal();
            return true;
        }
        this.tailCursor.set(tail);
        this.headCursor.set(head);
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean rc = false;
        for (E e : c) {
            if (!this.offer(e)) continue;
            rc = true;
        }
        return rc;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean isChanged = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean isChanged = false;
        for (int i = 0; i < this.size(); ++i) {
            int headSlot = (int)(this.head.get() + (long)i & this.mask);
            if (this.buffer[headSlot] == null || c.contains(this.buffer[headSlot]) || !this.remove(this.buffer[headSlot])) continue;
            --i;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public Iterator<E> iterator() {
        return new RingIter();
    }

    private boolean isFull() {
        long queueStart = this.tail.get() - (long)this.size;
        return this.head.get() == queueStart;
    }

    private final class SpinningQueueNotEmpty
    extends AbstractSpinningCondition {
        private SpinningQueueNotEmpty() {
        }

        @Override
        public final boolean test() {
            return DisruptorBlockingQueue.this.isEmpty();
        }
    }

    private final class SpinningQueueNotFull
    extends AbstractSpinningCondition {
        private SpinningQueueNotFull() {
        }

        @Override
        public final boolean test() {
            return DisruptorBlockingQueue.this.isFull();
        }
    }

    private final class WaitingQueueNotEmpty
    extends AbstractWaitingCondition {
        private WaitingQueueNotEmpty() {
        }

        @Override
        public final boolean test() {
            return DisruptorBlockingQueue.this.isEmpty();
        }
    }

    private final class WaitingQueueNotFull
    extends AbstractWaitingCondition {
        private WaitingQueueNotFull() {
        }

        @Override
        public final boolean test() {
            return DisruptorBlockingQueue.this.isFull();
        }
    }

    private final class QueueNotEmpty
    extends AbstractCondition {
        private QueueNotEmpty() {
        }

        @Override
        public final boolean test() {
            return DisruptorBlockingQueue.this.isEmpty();
        }
    }

    private final class QueueNotFull
    extends AbstractCondition {
        private QueueNotFull() {
        }

        @Override
        public final boolean test() {
            return DisruptorBlockingQueue.this.isFull();
        }
    }

    private final class RingIter
    implements Iterator<E> {
        int dx = 0;
        E lastObj = null;

        private RingIter() {
        }

        @Override
        public boolean hasNext() {
            return this.dx < DisruptorBlockingQueue.this.size();
        }

        @Override
        public E next() {
            long pollPos = DisruptorBlockingQueue.this.head.get();
            int slot = (int)(pollPos + (long)this.dx++ & DisruptorBlockingQueue.this.mask);
            this.lastObj = DisruptorBlockingQueue.this.buffer[slot];
            return this.lastObj;
        }

        @Override
        public void remove() {
            DisruptorBlockingQueue.this.remove(this.lastObj);
        }
    }
}

