/*
 * Decompiled with CFR 0.152.
 */
package com.connect_group.thymeleaf.testing.hamcrest;

import com.connect_group.thymesheet.query.HtmlElement;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;

public class HasComment
extends TypeSafeMatcher<HtmlElement> {
    private final String expectedText;

    public HasComment() {
        this.expectedText = null;
    }

    public HasComment(String expectedText) {
        this.expectedText = expectedText;
    }

    public void describeTo(Description description) {
        if (this.expectedText == null) {
            description.appendText("has at least one comment");
        } else {
            description.appendText("has a comment <!--").appendValue((Object)this.expectedText).appendText("-->");
        }
    }

    protected boolean matchesSafely(HtmlElement item) {
        Element element = item.getElement();
        if (element != null && element.hasChildren()) {
            List children = element.getChildren();
            for (Node child : children) {
                if (!(child instanceof Comment)) continue;
                if (this.expectedText == null) {
                    return true;
                }
                if (!this.expectedText.equals(((Comment)child).getContent())) continue;
                return true;
            }
        }
        return false;
    }
}

