/*
 * Decompiled with CFR 0.152.
 */
package com.connect_group.thymeleaf.testing.hamcrest;

import com.connect_group.thymesheet.query.HtmlElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.thymeleaf.dom.Element;

public class HasClass
extends TypeSafeMatcher<HtmlElement> {
    private final Set<String> expectedClassNames;

    public HasClass(String className) {
        this.expectedClassNames = this.toSet(className);
    }

    public boolean matchesSafely(HtmlElement item) {
        Element element = item.getElement();
        String classes = element.getAttributeValue("class");
        Set<String> classNames = this.toSet(classes);
        return classNames.containsAll(this.expectedClassNames);
    }

    private Set<String> toSet(String classNames) {
        Set<Object> set = new HashSet();
        if (classNames == null || classNames.length() == 0) {
            set = Collections.emptySet();
        } else {
            String[] names;
            set = new HashSet();
            for (String name : names = classNames.split("\\s+")) {
                set.add(name);
            }
        }
        return set;
    }

    public void describeTo(Description description) {
        if (this.expectedClassNames.size() > 1) {
            description.appendText("has classes ");
        } else {
            description.appendText("has class ");
        }
        for (String className : this.expectedClassNames) {
            description.appendText(" ").appendValue((Object)className);
        }
    }
}

