/*
 * Decompiled with CFR 0.152.
 */
package com.connect_group.thymeleaf.testing.config;

import com.connect_group.thymeleaf.testing.ThymeleafTestEngine;
import com.connect_group.thymesheet.templatemode.IThymesheetTemplateModeHandler;
import com.connect_group.thymesheet.templatemode.ThymesheetStandardTemplateModeHandlers;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.cache.StandardCacheManager;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring3.SpringTemplateEngine;
import org.thymeleaf.spring3.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.ITemplateModeHandler;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;

@Configuration
public class ThymesheetConfig {
    @Value(value="${thymeleaf.template.cache.enabled:true}")
    protected boolean templateCacheEnabled;
    @Value(value="${thymeleaf.template.mode:LEGACYHTML5}")
    protected String templateMode;
    @Value(value="${thymeleaf.template.characterEncoding:UTF-8}")
    protected String characterEncoding;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    ServletContext servletContext;

    @Bean
    public StandardCacheManager thymeleafCacheManager() {
        return new StandardCacheManager();
    }

    public Set<ITemplateModeHandler> templateModeHandlers() {
        HashSet<ITemplateModeHandler> set = new HashSet<ITemplateModeHandler>();
        ITemplateModeHandler handler = this.getHandler();
        set.add(handler);
        return set;
    }

    @Bean
    @DependsOn(value={"propertyConfigurer"})
    public ThymeleafViewResolver thymeleafViewResolver() {
        ThymeleafViewResolver viewResolver = new ThymeleafViewResolver();
        viewResolver.setCharacterEncoding(this.characterEncoding);
        viewResolver.setTemplateEngine((SpringTemplateEngine)this.testEngine());
        viewResolver.setOrder(0);
        return viewResolver;
    }

    @Bean
    public UrlBasedViewResolver urlBasedViewResolver() {
        UrlBasedViewResolver viewResolver = new UrlBasedViewResolver();
        viewResolver.setOrder(2);
        viewResolver.setViewClass(InternalResourceView.class);
        return viewResolver;
    }

    @Bean
    @DependsOn(value={"propertyConfigurer"})
    public ThymeleafTestEngine testEngine() {
        ThymeleafTestEngine engine = new ThymeleafTestEngine();
        engine.setCacheManager((ICacheManager)this.thymeleafCacheManager());
        engine.setTemplateModeHandlers(this.templateModeHandlers());
        engine.setAdditionalDialects(this.additionalDialects());
        HashSet<Object> templateResolvers = new HashSet<Object>();
        templateResolvers.add(this.servletContextTemplateResolver());
        templateResolvers.add(this.fileTemplateResolver());
        engine.setTemplateResolvers(templateResolvers);
        engine.setServletContext(this.servletContext);
        engine.setApplicationContext(this.applicationContext);
        return engine;
    }

    protected Set<IDialect> additionalDialects() {
        HashSet<IDialect> additionalDialects = new HashSet<IDialect>();
        return additionalDialects;
    }

    protected ITemplateModeHandler getHandler() {
        IThymesheetTemplateModeHandler handler = ThymesheetStandardTemplateModeHandlers.LEGACYHTML5;
        for (ITemplateModeHandler stdHandler : ThymesheetStandardTemplateModeHandlers.ALL_TEMPLATE_MODE_HANDLERS) {
            if (!stdHandler.getTemplateModeName().equals(this.templateMode)) continue;
            handler = stdHandler;
        }
        return handler;
    }

    private FileTemplateResolver fileTemplateResolver() {
        FileTemplateResolver resolver = new FileTemplateResolver();
        resolver.setCharacterEncoding("UTF-8");
        resolver.setTemplateMode("LEGACYHTML5");
        resolver.setCacheable(this.templateCacheEnabled);
        resolver.setOrder(Integer.valueOf(2));
        return resolver;
    }

    private ServletContextTemplateResolver servletContextTemplateResolver() {
        ServletContextTemplateResolver resolver = new ServletContextTemplateResolver();
        resolver.setCharacterEncoding(this.characterEncoding);
        resolver.setTemplateMode(this.templateMode);
        resolver.setCacheable(this.templateCacheEnabled);
        resolver.setOrder(Integer.valueOf(1));
        return resolver;
    }
}

