/*
 * Decompiled with CFR 0.152.
 */
package com.connect_group.thymeleaf.testing;

import com.connect_group.thymesheet.query.HtmlElements;
import com.connect_group.thymesheet.spring3.SpringThymesheetTemplateEngine;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.spring3.context.SpringWebContext;
import org.thymeleaf.templateparser.html.LegacyHtml5TemplateParser;

public class ThymeleafTestEngine
extends SpringThymesheetTemplateEngine {
    private ServletContext servletContext;
    private ApplicationContext applicationContext;
    private final LegacyHtml5TemplateParser parser = new LegacyHtml5TemplateParser("LEGACYHTML5", 1);

    public void setServletContext(ServletContext ctx) {
        super.setServletContext(ctx);
        this.servletContext = ctx;
    }

    public MockHttpServletRequest getHttpServletRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest(this.servletContext);
        request.setMethod("GET");
        return request;
    }

    public HtmlElements process(String path) {
        MockHttpServletRequest request = this.getHttpServletRequest();
        return this.process(path, request);
    }

    public HtmlElements process(String path, MockHttpServletRequest request) {
        String fragment = this.toString(path, request);
        return this.convertResultIntoDom(path, fragment);
    }

    public HtmlElements process(String path, Map<String, Object> model) {
        MockHttpServletRequest request = this.getHttpServletRequest();
        if (model != null && !model.isEmpty()) {
            for (String key : model.keySet()) {
                request.setAttribute(key, model.get(key));
            }
        }
        return this.process(path, request);
    }

    private HtmlElements convertResultIntoDom(String path, String htmlString) {
        List nodes;
        if (this.isFragment(htmlString)) {
            nodes = this.parser.parseFragment(this.getConfiguration(), htmlString);
        } else {
            Document doc = this.parser.parseTemplate(this.getConfiguration(), path, (Reader)new StringReader(htmlString));
            nodes = doc.getChildren();
        }
        Element root = new Element("#document");
        root.setChildren(nodes);
        return new HtmlElements(root);
    }

    private boolean isFragment(String htmlString) {
        return htmlString != null && !htmlString.contains("<!DOCTYPE") && !htmlString.contains("<!doctype") && !htmlString.contains("<html") && !htmlString.contains("<!HTML");
    }

    public String toString(String path, MockHttpServletRequest request) {
        MockHttpServletResponse response = new MockHttpServletResponse();
        HashMap<String, Object> model = new HashMap<String, Object>();
        Enumeration enumerator = request.getAttributeNames();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            Object obj = request.getAttribute(key);
            model.put(key, obj);
        }
        String fragment = this.process(path, (IContext)this.getSpringWebContext((HttpServletRequest)request, (HttpServletResponse)response, Locale.UK, model));
        return fragment;
    }

    public String toString(String path) {
        MockHttpServletRequest request = this.getHttpServletRequest();
        return this.toString(path, request);
    }

    public String toString(String path, Map<String, Object> model) {
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = this.getHttpServletRequest();
        for (String key : model.keySet()) {
            request.setAttribute(key, model.get(key));
        }
        String fragment = this.process(path, (IContext)this.getSpringWebContext((HttpServletRequest)request, (HttpServletResponse)response, Locale.UK, model));
        return fragment;
    }

    private IWebContext getSpringWebContext(HttpServletRequest request, HttpServletResponse response, Locale locale, Map<String, ?> model) {
        return new SpringWebContext(request, response, this.servletContext, locale, model, this.applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

