/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicates;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$ClassOwnership;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$JavaVersion;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$ParameterizedTypeImpl;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$TypeVariableImpl;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import javax.annotation.Nullable;

final class Types {
    private static final Function TYPE_TO_STRING = new Types$1();
    private static final Joiner COMMA_JOINER = Joiner.on(", ").useForNull("null");

    static Type newArrayType(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getLowerBounds();
            Preconditions.checkArgument(typeArray.length <= 1, "Wildcard cannot have more than one lower bounds.");
            if (typeArray.length == 1) {
                return Types.supertypeOf(Types.newArrayType(typeArray[0]));
            }
            Type[] typeArray2 = wildcardType.getUpperBounds();
            Preconditions.checkArgument(typeArray2.length == 1, "Wildcard should have only one upper bound.");
            return Types.subtypeOf(Types.newArrayType(typeArray2[0]));
        }
        return Types$JavaVersion.CURRENT.newArrayType(type);
    }

    static ParameterizedType newParameterizedTypeWithOwner(@Nullable Type type, Class clazz, Type ... typeArray) {
        if (type == null) {
            return Types.newParameterizedType(clazz, typeArray);
        }
        Preconditions.checkNotNull(typeArray);
        Preconditions.checkArgument(clazz.getEnclosingClass() != null, "Owner type for unenclosed %s", clazz);
        return new Types$ParameterizedTypeImpl(type, clazz, typeArray);
    }

    static ParameterizedType newParameterizedType(Class clazz, Type ... typeArray) {
        return new Types$ParameterizedTypeImpl(Types$ClassOwnership.JVM_BEHAVIOR.getOwnerType(clazz), clazz, typeArray);
    }

    static TypeVariable newTypeVariable(GenericDeclaration genericDeclaration, String string, Type ... typeArray) {
        Type[] typeArray2;
        if (typeArray.length == 0) {
            Type[] typeArray3 = new Type[1];
            typeArray2 = typeArray3;
            typeArray3[0] = Object.class;
        } else {
            typeArray2 = typeArray;
        }
        return new Types$TypeVariableImpl(genericDeclaration, string, typeArray2);
    }

    static WildcardType subtypeOf(Type type) {
        return new Types$WildcardTypeImpl(new Type[0], new Type[]{type});
    }

    static WildcardType supertypeOf(Type type) {
        return new Types$WildcardTypeImpl(new Type[]{type}, new Type[]{Object.class});
    }

    static String toString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    private static Type[] toArray(Collection collection) {
        return collection.toArray(new Type[collection.size()]);
    }

    private static Iterable filterUpperBounds(Iterable iterable) {
        return Iterables.filter(iterable, Predicates.not(Predicates.equalTo(Object.class)));
    }

    private static void disallowPrimitiveType(Type[] typeArray, String string) {
        for (Type type : typeArray) {
            if (!(type instanceof Class)) continue;
            Class clazz = (Class)type;
            Preconditions.checkArgument(!clazz.isPrimitive(), "Primitive type '%s' used as %s", clazz, string);
        }
    }

    static Class getArrayClass(Class clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    static /* synthetic */ void access$100(Type[] typeArray, String string) {
        Types.disallowPrimitiveType(typeArray, string);
    }

    static /* synthetic */ Type[] access$200(Collection collection) {
        return Types.toArray(collection);
    }

    static /* synthetic */ Function access$300() {
        return TYPE_TO_STRING;
    }

    static /* synthetic */ Joiner access$400() {
        return COMMA_JOINER;
    }

    static /* synthetic */ Iterable access$500(Iterable iterable) {
        return Types.filterUpperBounds(iterable);
    }
}

