/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.context.InternalContextAdapter;
import bboss.org.apache.velocity.context.InternalContextAdapterImpl;
import bboss.org.apache.velocity.exception.MethodInvocationException;
import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.exception.TemplateInitException;
import bboss.org.apache.velocity.exception.VelocityException;
import bboss.org.apache.velocity.runtime.directive.Scope;
import bboss.org.apache.velocity.runtime.directive.StopCommand;
import bboss.org.apache.velocity.runtime.parser.ParseException;
import bboss.org.apache.velocity.runtime.parser.node.ASTText;
import bboss.org.apache.velocity.runtime.parser.node.Node;
import bboss.org.apache.velocity.runtime.parser.node.SimpleNode;
import bboss.org.apache.velocity.runtime.resource.Resource;
import com.frameworkset.velocity.BBossVelocityUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.soa.BBossStringReader;

public class ESTemplate
extends Resource {
    private String scopeName = "template";
    private ESInfo esInfo;
    private boolean provideScope = false;
    private String template;
    private boolean processed;
    private VelocityException errorCondition = null;

    public ESTemplate(ESInfo esInfo) {
        this.esInfo = esInfo;
        this.template = this.esInfo.getTemplate();
        this.setName(esInfo.getTemplateName());
        this.setType(4);
    }

    private void rechecksqlistpl() {
        Node[] childrens;
        if (this.data != null && (childrens = ((SimpleNode)this.data).getChildren()) != null && childrens.length > 0) {
            boolean switchcase = true;
            for (Node node : childrens) {
                if (node instanceof ASTText) continue;
                switchcase = false;
                break;
            }
            if (switchcase) {
                this.esInfo.setTpl(false);
            } else {
                this.esInfo.setTpl(true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process() throws ResourceNotFoundException, ParseErrorException {
        if (this.processed) {
            return true;
        }
        ESTemplate eSTemplate = this;
        synchronized (eSTemplate) {
            if (this.processed) {
                return true;
            }
            this.data = null;
            this.errorCondition = null;
            BBossStringReader is = null;
            try {
                is = new BBossStringReader(this.template);
            }
            catch (ResourceNotFoundException rnfe) {
                this.errorCondition = rnfe;
                this.processed = true;
                throw rnfe;
            }
            if (is == null) {
                this.errorCondition = new ResourceNotFoundException("Unknown resource error for resource " + this.name);
                this.processed = true;
                throw this.errorCondition;
            }
            try {
                BufferedReader br = new BufferedReader((Reader)is);
                this.data = this.rsvc.parse((Reader)br, this.name);
                this.initDocument();
                this.processed = true;
                try {
                    this.rechecksqlistpl();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = true;
                return bl;
            }
            catch (ParseException pex) {
                this.errorCondition = new ParseErrorException(pex, this.name);
                this.processed = true;
                throw this.errorCondition;
            }
            catch (TemplateInitException pex) {
                this.errorCondition = new ParseErrorException((VelocityException)pex, this.name);
                this.processed = true;
                throw this.errorCondition;
            }
            catch (RuntimeException e) {
                this.errorCondition = new VelocityException("Exception thrown processing Template " + this.getName(), (Throwable)e);
                this.processed = true;
                throw this.errorCondition;
            }
            finally {
                block20: {
                    this.processed = true;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (this.errorCondition != null) break block20;
                        throw new VelocityException((Throwable)e);
                    }
                }
            }
        }
    }

    public void initDocument() throws TemplateInitException {
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl((Context)new VelocityContext());
        try {
            ica.pushCurrentTemplateName(this.name);
            ica.setCurrentResource((Resource)this);
            ((SimpleNode)this.data).init((InternalContextAdapter)ica, (Object)this.rsvc);
            String property = this.scopeName + '.' + "provide.scope.control";
            this.provideScope = this.rsvc.getBoolean(property, this.provideScope);
        }
        finally {
            ica.popCurrentTemplateName();
            ica.setCurrentResource(null);
        }
    }

    public void merge(Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        this.merge(context, writer, null);
    }

    public String evaluate(Map variablevalues) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        StringWriter writer = new StringWriter();
        this.merge((Context)BBossVelocityUtil.buildVelocityContext((Map)variablevalues), writer, null);
        return writer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void merge(Context context, Writer writer, List macroLibraries) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        this.process();
        if (this.errorCondition != null) {
            throw this.errorCondition;
        }
        if (this.data != null) {
            InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
            ica.setMacroLibraries(macroLibraries);
            if (macroLibraries != null) {
                for (int i = 0; i < macroLibraries.size(); ++i) {
                    try {
                        this.rsvc.getTemplate((String)macroLibraries.get(i));
                        continue;
                    }
                    catch (ResourceNotFoundException re) {
                        this.rsvc.getLog().error((Object)("template.merge(): cannot find template " + (String)macroLibraries.get(i)));
                        throw re;
                    }
                    catch (ParseErrorException pe) {
                        this.rsvc.getLog().error((Object)("template.merge(): syntax error in template " + (String)macroLibraries.get(i) + "."));
                        throw pe;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Template.merge(): parse failed in template  " + (String)macroLibraries.get(i) + ".", e);
                    }
                }
            }
            if (this.provideScope) {
                ica.put(this.scopeName, (Object)new Scope((Object)this, ica.get(this.scopeName)));
            }
            try {
                ica.pushCurrentTemplateName(this.name);
                ica.setCurrentResource((Resource)this);
                ((SimpleNode)this.data).render((InternalContextAdapter)ica, writer);
                return;
            }
            catch (StopCommand stop) {
                if (!stop.isFor((Object)this)) {
                    throw stop;
                }
                if (!this.rsvc.getLog().isDebugEnabled()) return;
                this.rsvc.getLog().debug((Object)stop.getMessage());
                return;
            }
            catch (IOException e) {
                throw new VelocityException("IO Error rendering template '" + this.name + "'", (Throwable)e);
            }
            finally {
                Object obj;
                ica.popCurrentTemplateName();
                ica.setCurrentResource(null);
                if (this.provideScope && (obj = ica.get(this.scopeName)) instanceof Scope) {
                    Scope scope = (Scope)obj;
                    if (scope.getParent() != null) {
                        ica.put(this.scopeName, (Object)scope.getParent());
                    } else if (scope.getReplaced() != null) {
                        ica.put(this.scopeName, scope.getReplaced());
                    } else {
                        ica.remove((Object)this.scopeName);
                    }
                }
            }
        } else {
            String msg = "Template.merge() failure. The document is null, most likely due to parsing error.";
            throw new RuntimeException(msg);
        }
    }
}

