/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.MSearchRestResponse;
import org.frameworkset.elasticsearch.handler.BaseResponsehandler;
import org.frameworkset.elasticsearch.serial.ESClass;
import org.frameworkset.elasticsearch.serial.ESClassType;
import org.frameworkset.elasticsearch.serial.ESSerialThreadLocal;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticMSearchResponseHandler
extends BaseResponsehandler
implements URLResponseHandler<MSearchRestResponse> {
    private static Logger logger = LoggerFactory.getLogger(ElasticMSearchResponseHandler.class);

    public ElasticMSearchResponseHandler() {
    }

    public ElasticMSearchResponseHandler(JavaType javaType) {
        super(javaType);
    }

    public ElasticMSearchResponseHandler(ESTypeReferences<?, ?> types) {
        super(types);
    }

    public ElasticMSearchResponseHandler(ESClassType type) {
        super(type);
    }

    public ElasticMSearchResponseHandler(Class<?> types) {
        super(types);
    }

    public MSearchRestResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = this.initStatus(response);
        if (ResponseUtil.isHttpStatusOK((int)status)) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    ESSerialThreadLocal.setESTypeReferences((ESClass)this.types);
                    MSearchRestResponse mSearchRestResponse = (MSearchRestResponse)super.converJson(entity, MSearchRestResponse.class);
                    return mSearchRestResponse;
                }
                catch (Exception e) {
                    throw new ElasticSearchException("Request url:" + this.url, e, status);
                }
                finally {
                    ESSerialThreadLocal.clean();
                }
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        return (MSearchRestResponse)super.handleException(this.url, entity, status);
    }
}

