/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.entity.suggest;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.suggest.PhraseRestResponse;
import org.frameworkset.spi.remote.http.BaseResponseHandler;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchPhraseResponseHandler
extends BaseResponseHandler
implements URLResponseHandler<PhraseRestResponse> {
    private static Logger logger = LoggerFactory.getLogger(ElasticSearchPhraseResponseHandler.class);

    public PhraseRestResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (ResponseUtil.isHttpStatusOK((int)status)) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    return (PhraseRestResponse)super.converJson(entity, PhraseRestResponse.class);
                }
                catch (Exception e) {
                    throw new ElasticSearchException("Request url:" + this.url, e);
                }
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            throw new ElasticSearchException("Request url:" + this.url + "," + EntityUtils.toString((HttpEntity)entity));
        }
        throw new ElasticSearchException("Request url:" + this.url + ",Unexpected response status: " + status);
    }
}

