/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import com.frameworkset.util.BaseSimpleStringUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticsearchParseException;
import org.frameworkset.elasticsearch.boot.ElasticsearchBootResult;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ConfigHolder;
import org.frameworkset.elasticsearch.template.AOPTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.ESSOAFileApplicationContext;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchHelper {
    private static final Logger logger;
    protected static DefaultApplicationContext context;
    public static final String DEFAULT_SEARCH = "elasticSearch";
    protected static ElasticSearch elasticSearchSink;
    private static final Map<String, Object> geoipConfig;
    private static boolean inited;
    private static long dslfileRefreshInterval;
    private static String dslfileMappingDir;
    private static Method bootMethod;
    public static final ConfigHolder configHolder;
    private static final Map<String, ElasticSearch> elasticSearchMap;
    private static final Map<String, String> referElasticSearchMap;

    public static Map<String, Object> getGeoipConfig() {
        return geoipConfig;
    }

    public static long getDslfileRefreshInterval() {
        return dslfileRefreshInterval;
    }

    public static String getDslfileMappingDir() {
        return dslfileMappingDir;
    }

    public static void setDslfileRefreshInterval(long dslfileRefreshInterval) {
        ElasticSearchHelper.dslfileRefreshInterval = dslfileRefreshInterval;
    }

    public static Map<String, ElasticSearch> getAllElasticSearches() {
        LinkedHashMap<String, ElasticSearch> temp = new LinkedHashMap<String, ElasticSearch>();
        temp.putAll(elasticSearchMap);
        return temp;
    }

    public static Map<String, String> getAllReferElasticSearches() {
        LinkedHashMap<String, String> temp = new LinkedHashMap<String, String>();
        temp.putAll(referElasticSearchMap);
        return temp;
    }

    public static List<String> booter(String[] elasticsearchServerNames, GetProperties configContext, boolean forceBoot) {
        return ElasticSearchHelper.booter(elasticsearchServerNames, configContext, forceBoot, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> booter(String[] elasticsearchServerNames, GetProperties configContext, boolean forceBoot, boolean fromspringboot) {
        if (inited && !forceBoot) {
            return null;
        }
        inited = true;
        ElasticSearch elasticSearchSink = null;
        ElasticSearch firstElasticSearch = null;
        ElasticSearchHelper.initDslFileRefreshInterval(configContext);
        LinkedHashMap<String, ElasticSearch> elasticSearchMap = new LinkedHashMap<String, ElasticSearch>();
        ArrayList<String> initedElasticsearchs = new ArrayList<String>();
        LinkedHashMap<String, String> referElasticSearchMap = new LinkedHashMap<String, String>();
        for (String serverName : elasticsearchServerNames) {
            if (ElasticSearchHelper.elasticSearchMap.containsKey(serverName) || ElasticSearchHelper.referElasticSearchMap.containsKey(serverName) || serverName.equals("default") && (ElasticSearchHelper.elasticSearchMap.containsKey(DEFAULT_SEARCH) || ElasticSearchHelper.referElasticSearchMap.containsKey(DEFAULT_SEARCH))) continue;
            String referExternal = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.referExternal", configContext, null);
            if (referExternal == null || referExternal.equals("")) {
                String sqlRestapi;
                String useHttps;
                String logDslCallback;
                String slowDslCallback;
                Properties elasticsearchPropes = new Properties();
                elasticsearchPropes.put("elasticsearch.client", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.client", configContext, "restful"));
                elasticsearchPropes.put("elasticUser", ElasticSearchHelper._getStringValue(serverName, "elasticUser", configContext, ""));
                elasticsearchPropes.put("elasticPassword", ElasticSearchHelper._getStringValue(serverName, "elasticPassword", configContext, ""));
                elasticsearchPropes.put("elasticsearch.rest.hostNames", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.rest.hostNames", configContext, "127.0.0.1:9200"));
                elasticsearchPropes.put("elasticsearch.dateFormat", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.dateFormat", configContext, "yyyy.MM.dd"));
                elasticsearchPropes.put("elasticsearch.timeZone", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.timeZone", configContext, "Asia/Shanghai"));
                elasticsearchPropes.put("elasticsearch.ttl", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.ttl", configContext, "2d"));
                elasticsearchPropes.put("elasticsearch.showTemplate", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.showTemplate", configContext, "false"));
                elasticsearchPropes.put("elasticsearch.healthPath", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.healthPath", configContext, "/"));
                elasticsearchPropes.put("elasticsearch.httpPool", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.httpPool", configContext, serverName));
                elasticsearchPropes.put("elasticsearch.discoverHost", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.discoverHost", configContext, "false"));
                elasticsearchPropes.put("elasticsearch.version", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.version", configContext, "7.0.0"));
                elasticsearchPropes.put("elasticsearch.sliceScrollThreadCount", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.sliceScrollThreadCount", configContext, "50"));
                elasticsearchPropes.put("elasticsearch.sliceScrollThreadQueue", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.sliceScrollThreadQueue", configContext, "100"));
                elasticsearchPropes.put("elasticsearch.sliceScrollBlockedWaitTimeout", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.sliceScrollBlockedWaitTimeout", configContext, "0"));
                elasticsearchPropes.put("elasticsearch.includeTypeName", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.includeTypeName", configContext, "false"));
                elasticsearchPropes.put("elasticsearch.scrollThreadCount", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.scrollThreadCount", configContext, "50"));
                elasticsearchPropes.put("elasticsearch.scrollThreadQueue", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.scrollThreadQueue", configContext, "200"));
                elasticsearchPropes.put("elasticsearch.scrollBlockedWaitTimeout", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.scrollBlockedWaitTimeout", configContext, "0"));
                elasticsearchPropes.put("elasticsearch.healthCheckInterval", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.healthCheckInterval", configContext, "3000"));
                elasticsearchPropes.put("elasticsearch.failAllContinue", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.failAllContinue", configContext, "true"));
                String slowDslThreshold = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.slowDslThreshold", configContext, null);
                if (slowDslThreshold != null) {
                    elasticsearchPropes.put("elasticsearch.slowDslThreshold", slowDslThreshold);
                }
                if ((slowDslCallback = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.slowDslCallback", configContext, null)) != null) {
                    elasticsearchPropes.put("elasticsearch.slowDslCallback", slowDslCallback);
                }
                if ((logDslCallback = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.logDslCallback", configContext, null)) != null) {
                    elasticsearchPropes.put("elasticsearch.logDslCallback", logDslCallback);
                }
                if ((useHttps = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.useHttps", configContext, null)) != null) {
                    elasticsearchPropes.put("elasticsearch.useHttps", useHttps);
                }
                if ((sqlRestapi = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.sqlRestapi", configContext, null)) != null) {
                    elasticsearchPropes.put("elasticsearch.sqlRestapi", sqlRestapi);
                }
                ElasticSearch elasticSearch = new ElasticSearch();
                if (firstElasticSearch == null) {
                    firstElasticSearch = elasticSearch;
                }
                elasticSearch.setFromspringboot(fromspringboot);
                elasticSearch.setElasticSearchName(serverName);
                elasticSearch.setElasticsearchPropes(elasticsearchPropes);
                elasticSearch.configureWithConfigContext(configContext);
                if (!serverName.equals("default")) {
                    elasticSearchMap.put(serverName, elasticSearch);
                } else {
                    elasticSearchMap.put(DEFAULT_SEARCH, elasticSearch);
                    elasticSearchSink = elasticSearch;
                }
                initedElasticsearchs.add(serverName);
                continue;
            }
            if (!serverName.equals("default")) {
                referElasticSearchMap.put(serverName, referExternal);
                continue;
            }
            referElasticSearchMap.put(DEFAULT_SEARCH, referExternal);
        }
        Map<String, Object> map = geoipConfig;
        synchronized (map) {
            if (SimpleStringUtil.isEmpty((Object)geoipConfig.get("ip.database"))) {
                geoipConfig.put("ip.database", ElasticSearchHelper._getStringValue("", "ip.database", configContext, ""));
            }
            if (SimpleStringUtil.isEmpty((Object)geoipConfig.get("ip.asnDatabase"))) {
                geoipConfig.put("ip.asnDatabase", ElasticSearchHelper._getStringValue("", "ip.asnDatabase", configContext, ""));
            }
            if (SimpleStringUtil.isEmpty((Object)geoipConfig.get("ip.ispConverter"))) {
                geoipConfig.put("ip.ispConverter", ElasticSearchHelper._getStringValue("", "ip.ispConverter", configContext, ""));
            }
            if (SimpleStringUtil.isEmpty((Object)geoipConfig.get("ip.ip2regionDatabase"))) {
                geoipConfig.put("ip.ip2regionDatabase", ElasticSearchHelper._getStringValue("", "ip.ip2regionDatabase", configContext, ""));
            }
            if (SimpleStringUtil.isEmpty((Object)geoipConfig.get("ip.cachesize"))) {
                geoipConfig.put("ip.cachesize", ElasticSearchHelper._getStringValue("", "ip.cachesize", configContext, "10000"));
            }
            if (SimpleStringUtil.isEmpty((Object)geoipConfig.get("ip.serviceUrl"))) {
                geoipConfig.put("ip.serviceUrl", ElasticSearchHelper._getStringValue("", "ip.serviceUrl", configContext, ""));
            }
            if (logger.isInfoEnabled()) {
                try {
                    logger.info("Geo ipinfo config {},from springboot:{}", (Object)SimpleStringUtil.object2json(geoipConfig), (Object)fromspringboot);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (elasticSearchSink != null) {
            ElasticSearchHelper.elasticSearchSink = elasticSearchSink;
        } else if (ElasticSearchHelper.elasticSearchSink == null) {
            ElasticSearchHelper.elasticSearchSink = elasticSearchSink = firstElasticSearch;
        }
        if (elasticSearchMap.size() > 0) {
            for (Map.Entry entry : elasticSearchMap.entrySet()) {
                ElasticSearch elasticSearch = (ElasticSearch)((Object)entry.getValue());
                elasticSearch.start();
            }
            Map<String, ElasticSearch> map2 = ElasticSearchHelper.elasticSearchMap;
            synchronized (map2) {
                ElasticSearchHelper.elasticSearchMap.putAll(elasticSearchMap);
            }
        }
        if (referElasticSearchMap.size() > 0) {
            LinkedHashMap<String, String> linkedHashMap = referElasticSearchMap;
            synchronized (linkedHashMap) {
                ElasticSearchHelper.referElasticSearchMap.putAll(referElasticSearchMap);
            }
        }
        return initedElasticsearchs;
    }

    private static long _getLongValue(String poolName, String propertyName, GetProperties context, long defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        long ret = Long.parseLong(_value.trim());
        return ret;
    }

    private static int _getIntValue(String poolName, String propertyName, BaseApplicationContext context, int defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        int ret = Integer.parseInt(_value);
        return ret;
    }

    public static String _getStringValue(String poolName, String propertyName, GetProperties context, String defaultValue) {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = !poolName.equals("") ? context.getExternalProperty(poolName + "." + propertyName) : context.getExternalProperty(propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        return _value;
    }

    private static void initDslFileRefreshInterval(GetProperties context) {
        try {
            long _dslfileRefreshInterval;
            dslfileRefreshInterval = _dslfileRefreshInterval = ElasticSearchHelper._getLongValue("default", "dslfile.refreshInterval", context, 5000L);
        }
        catch (Exception _dslfileRefreshInterval) {
            // empty catch block
        }
        String _dslfileMappingDir = ElasticSearchHelper._getStringValue("default", "dslfile.dslMappingDir", context, null);
        if (_dslfileMappingDir != null && !_dslfileMappingDir.trim().equals("")) {
            dslfileMappingDir = _dslfileMappingDir;
        }
        if (logger.isInfoEnabled()) {
            logger.info("dslfile.refreshInterval {} ms", (Object)dslfileRefreshInterval);
            logger.info("dslfile.dslMappingDir {}", (Object)dslfileMappingDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (inited) {
            return;
        }
        Map<String, ElasticSearch> map = elasticSearchMap;
        synchronized (map) {
            ElasticSearch _elasticSearchSink;
            if (inited) {
                return;
            }
            if (elasticSearchSink == null && (_elasticSearchSink = elasticSearchMap.get(DEFAULT_SEARCH)) == null && !(context = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch.xml")).isEmptyContext()) {
                ElasticSearchHelper.initDslFileRefreshInterval((GetProperties)context);
                _elasticSearchSink = (ElasticSearch)((Object)context.getTBeanObject(DEFAULT_SEARCH, ElasticSearch.class));
                if (_elasticSearchSink != null) {
                    elasticSearchMap.put(DEFAULT_SEARCH, _elasticSearchSink);
                    elasticSearchSink = _elasticSearchSink;
                }
            }
            if (context.isEmptyContext()) {
                if (bootMethod != null) {
                    try {
                        bootMethod.invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new ElasticsearchParseException("ElasticSearch load from Boot failed:", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ElasticsearchParseException("ElasticSearch load from Boot failed:", e);
                    }
                } else if (logger.isWarnEnabled()) {
                    logger.warn("ElasticSearch load from Boot warn: No booter found and bootMethod is null!");
                }
            }
            inited = true;
        }
    }

    public static synchronized void stopElasticsearch(String esname) {
        ElasticSearch elasticSearch = ElasticSearchHelper.getElasticSearchSinkOnly(esname, true);
        if (elasticSearch != null) {
            elasticSearch.stop();
            if (elasticSearch == null || ((Object)((Object)elasticSearch)).equals("") || ((Object)((Object)elasticSearch)).equals("default")) {
                elasticSearchSink = null;
                elasticSearchMap.remove(DEFAULT_SEARCH);
                referElasticSearchMap.remove(DEFAULT_SEARCH);
            } else {
                elasticSearchMap.remove(esname);
            }
        }
        referElasticSearchMap.remove(esname);
    }

    public static synchronized void stopElasticsearchs(Map<String, Object> esnames) {
        if (esnames == null || esnames.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> esname : esnames.entrySet()) {
            ElasticSearchHelper.stopElasticsearch(esname.getKey());
        }
    }

    public static synchronized void stopElasticsearchs(ElasticsearchBootResult elasticsearchBootResult) {
        Map initedElasticsearch = elasticsearchBootResult.getResourceStartResult();
        if (BaseSimpleStringUtil.isNotEmpty((Object)initedElasticsearch)) {
            ElasticSearchHelper.stopElasticsearchs(initedElasticsearch);
        }
    }

    public static ElasticSearch getElasticSearchSinkOnly(String elasticSearch) {
        return ElasticSearchHelper.getElasticSearchSinkOnly(elasticSearch, false);
    }

    public static ElasticSearch getElasticSearchSinkOnly(String elasticSearch, boolean direct) {
        if (elasticSearch == null || elasticSearch.equals("") || elasticSearch.equals("default")) {
            return elasticSearchSink;
        }
        if (!direct && ((elasticSearch = ElasticSearchHelper.getRealElasticserachName(elasticSearch)) == null || elasticSearch.equals("") || elasticSearch.equals("default"))) {
            return elasticSearchSink;
        }
        ElasticSearch elasticSearchSink = elasticSearchMap.get(elasticSearch);
        return elasticSearchSink;
    }

    public static String getRealElasticserachName(String elasticSearch) {
        String name_;
        if (elasticSearch == null || elasticSearch.equals("") || elasticSearch.equals("default")) {
            return DEFAULT_SEARCH;
        }
        String name = referElasticSearchMap.get(elasticSearch);
        if (name == null) {
            return elasticSearch;
        }
        while ((name_ = referElasticSearchMap.get(name)) != null) {
            if (name_.equals(name)) {
                throw new ElasticSearchException("Elasticsearch\u6570\u636e\u6e90\u4e0d\u80fd\u76f4\u63a5\u6216\u8005\u95f4\u63a5\u5f15\u7528\u81ea\u5df1\uff1a" + name);
            }
            name = name_;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElasticSearch getElasticSearchSink(String elasticSearch) {
        ElasticSearchHelper.init();
        if (elasticSearch == null || elasticSearch.equals("") || elasticSearch.equals("default")) {
            return elasticSearchSink;
        }
        if ((elasticSearch = ElasticSearchHelper.getRealElasticserachName(elasticSearch)) == null || elasticSearch.equals("") || elasticSearch.equals("default")) {
            return elasticSearchSink;
        }
        ElasticSearch elasticSearchSink = elasticSearchMap.get(elasticSearch);
        if (elasticSearchSink == null) {
            Map<String, ElasticSearch> map = elasticSearchMap;
            synchronized (map) {
                elasticSearchSink = elasticSearchMap.get(elasticSearch);
                if (elasticSearchSink != null) {
                    return elasticSearchSink;
                }
                try {
                    context = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch.xml");
                    elasticSearchSink = (ElasticSearch)((Object)context.getTBeanObject(elasticSearch, ElasticSearch.class));
                }
                catch (Exception e) {
                    throw new ElasticSearchException("Elasticsearh Datasource[" + elasticSearch + "] is not configured. please check your configs.", e);
                }
                if (elasticSearchSink != null) {
                    elasticSearchMap.put(elasticSearch, elasticSearchSink);
                }
            }
        }
        return elasticSearchSink;
    }

    public static ElasticSearch getElasticSearchSink() {
        ElasticSearchHelper.init();
        return elasticSearchSink;
    }

    public static ClientInterface getRestClientUtil() {
        ElasticSearchHelper.init();
        return elasticSearchSink.getRestClientUtil();
    }

    public static ClientInterface getRestClientUtil(String elasticSearch) {
        ElasticSearch elasticSearchSink = null;
        try {
            elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        }
        catch (ElasticSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ElasticSearchException("Elasticsearh Datasource[" + elasticSearch + "] is not configured. please check your configs.", e);
        }
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsearh Datasource[" + elasticSearch + "] is not configured. please check your configs.");
        }
        return elasticSearchSink.getRestClientUtil();
    }

    public static ClientInterface getConfigRestClientUtil(String configFile) {
        ElasticSearchHelper.init();
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsearh Datasource[default] is not configured. please check your configs.");
        }
        return elasticSearchSink.getConfigRestClientUtil(configFile);
    }

    public static AOPTemplateContainerImpl getAOPTemplateContainerImpl(String dslpath) {
        ElasticSearchHelper.init();
        ESSOAFileApplicationContext essoaFileApplicationContext = new ESSOAFileApplicationContext(configHolder, dslfileMappingDir, dslpath);
        essoaFileApplicationContext.initProviderManager();
        AOPTemplateContainerImpl aopTemplateContainer = new AOPTemplateContainerImpl(configHolder, dslfileMappingDir, (BaseApplicationContext)essoaFileApplicationContext);
        return aopTemplateContainer;
    }

    public static List<String> getTemplateFiles() {
        return configHolder.getTemplateFiles();
    }

    public static ClientInterface getConfigRestClientUtil(BaseTemplateContainerImpl templateContainer) {
        ElasticSearchHelper.init();
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsearh Datasource[default] is not configured. please check your configs.");
        }
        return elasticSearchSink.getConfigRestClientUtil(templateContainer);
    }

    public static ClientInterface getConfigRestClientUtil(String elasticSearch, String configFile) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsear Datasource[" + elasticSearch + "] is not configured. please check your configs.");
        }
        return elasticSearchSink.getConfigRestClientUtil(configFile);
    }

    public static ClientInterface getConfigRestClientUtil(String elasticSearch, BaseTemplateContainerImpl templateContainer) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsear Datasource[" + elasticSearch + "] is not configured. please check your configs.");
        }
        return elasticSearchSink.getConfigRestClientUtil(templateContainer);
    }

    public static void addHttpServer(List<String> hosts) {
    }

    public static ConfigHolder getConfigHolder() {
        return configHolder;
    }

    static {
        block4: {
            logger = LoggerFactory.getLogger(ElasticSearchHelper.class);
            context = null;
            elasticSearchSink = null;
            geoipConfig = new LinkedHashMap<String, Object>();
            dslfileRefreshInterval = 5000L;
            configHolder = new ConfigHolder("Elasticsearch");
            ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    configHolder.stopmonitor();
                    configHolder.destory();
                }
            });
            try {
                Class<?> booterClass = Class.forName("org.frameworkset.elasticsearch.boot.ElasticSearchConfigBoot");
                bootMethod = booterClass.getMethod("boot", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("ElasticSearch load from Boot ignore: org.frameworkset.elasticsearch.boot.ElasticSearchConfigBoot Not found!");
                }
            }
            catch (NoSuchMethodException e) {
                if (!logger.isWarnEnabled()) break block4;
                logger.warn("ElasticSearch load from Boot ignore: boot method Not found in org.frameworkset.elasticsearch.boot.ElasticSearchConfigBoot!");
            }
        }
        elasticSearchMap = new LinkedHashMap<String, ElasticSearch>();
        referElasticSearchMap = new LinkedHashMap<String, String>();
    }
}

