/*
 * Decompiled with CFR 0.152.
 */
package com.battcn.boot.swagger.web;

import com.battcn.boot.swagger.properties.SwaggerSecurityProperties;
import com.battcn.boot.swagger.utils.RequestUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ConditionalOnProperty(name={"spring.swagger.enabled"}, havingValue="true", matchIfMissing=true)
@RestController
@ApiIgnore
public class CustomSwagger2Controller {
    private static final String SWAGGER_SECURITY_URL = "/v2/swagger-security";
    private static final String SWAGGER_SECURITY_LOGIN_URL = "/v2/swagger-login";
    private final SwaggerSecurityProperties swaggerSecurityProperties;

    public CustomSwagger2Controller(SwaggerSecurityProperties swaggerSecurityProperties) {
        this.swaggerSecurityProperties = swaggerSecurityProperties;
    }

    @GetMapping(value={"/v2/swagger-security"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Map<String, Boolean>> getCustomDocumentation() {
        HashMap<String, Boolean> meteData = new HashMap<String, Boolean>(2);
        meteData.put("security", this.swaggerSecurityProperties.isFilterPlugin());
        return new ResponseEntity(meteData, HttpStatus.OK);
    }

    @PostMapping(value={"/v2/swagger-login"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Void> loginSwagger(HttpSession session, HttpServletResponse response, String username, String password) throws IOException {
        if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password)) {
            RequestUtils.writeForbidden(response);
        }
        if (!username.equals(this.swaggerSecurityProperties.getUsername()) || !password.equals(this.swaggerSecurityProperties.getPassword())) {
            RequestUtils.writeForbidden(response);
        }
        if (this.swaggerSecurityProperties.getUsername().equals(username) && password.equals(this.swaggerSecurityProperties.getPassword())) {
            String sessionId = session.getId();
            session.setAttribute(sessionId, (Object)sessionId);
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }
}

