/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.query;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.querys.DbQueryDecorator;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.jdbc.DatabaseMetaDataWrapper;
import com.baomidou.mybatisplus.generator.query.AbstractDatabaseQuery;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SQLQuery
extends AbstractDatabaseQuery {
    protected final DbQueryDecorator dbQuery;
    protected final DatabaseMetaDataWrapper databaseMetaDataWrapper;

    public SQLQuery(@NotNull ConfigBuilder configBuilder) {
        super(configBuilder);
        this.dbQuery = new DbQueryDecorator(this.dataSourceConfig, this.strategyConfig);
        this.databaseMetaDataWrapper = new DatabaseMetaDataWrapper(this.dbQuery.getConnection(), this.dataSourceConfig.getSchemaName());
    }

    @Override
    @NotNull
    public List<TableInfo> queryTables() {
        boolean isInclude = !this.strategyConfig.getInclude().isEmpty();
        boolean isExclude = !this.strategyConfig.getExclude().isEmpty();
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> includeTableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> excludeTableList = new ArrayList<TableInfo>();
        try {
            this.dbQuery.execute(this.dbQuery.tablesSql(), result -> {
                String tableName = result.getStringResult(this.dbQuery.tableName());
                if (StringUtils.isNotBlank((CharSequence)tableName)) {
                    TableInfo tableInfo = new TableInfo(this.configBuilder, tableName);
                    String tableComment = result.getTableComment();
                    if (!this.strategyConfig.isSkipView() || !tableComment.toUpperCase().contains("VIEW")) {
                        tableInfo.setComment(tableComment);
                        if (isInclude && this.strategyConfig.matchIncludeTable(tableName)) {
                            includeTableList.add(tableInfo);
                        } else if (isExclude && this.strategyConfig.matchExcludeTable(tableName)) {
                            excludeTableList.add(tableInfo);
                        }
                        tableList.add(tableInfo);
                    }
                }
            });
            this.filter(tableList, includeTableList, excludeTableList);
            tableList.forEach(this::convertTableFields);
            ArrayList<TableInfo> arrayList = tableList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.dbQuery.closeConnection();
        }
    }

    protected void convertTableFields(@NotNull TableInfo tableInfo) {
        String tableName = tableInfo.getName();
        try {
            Map<String, DatabaseMetaDataWrapper.Column> columnsInfoMap = this.databaseMetaDataWrapper.getColumnsInfo(tableName, false);
            String tableFieldsSql = this.dbQuery.tableFieldsSql(tableName);
            HashSet pkColumns = new HashSet();
            String primaryKeySql = this.dbQuery.primaryKeySql(this.dataSourceConfig, tableName);
            boolean selectPk = StringUtils.isNotBlank((CharSequence)primaryKeySql);
            if (selectPk) {
                this.dbQuery.execute(primaryKeySql, result -> {
                    String primaryKey = result.getStringResult(this.dbQuery.fieldKey());
                    if (Boolean.parseBoolean(primaryKey)) {
                        pkColumns.add(result.getStringResult(this.dbQuery.fieldName()));
                    }
                });
            }
            Entity entity = this.strategyConfig.entity();
            this.dbQuery.execute(tableFieldsSql, result -> {
                boolean isId;
                String columnName = result.getStringResult(this.dbQuery.fieldName());
                TableField field = new TableField(this.configBuilder, columnName);
                DatabaseMetaDataWrapper.Column columnInfo = (DatabaseMetaDataWrapper.Column)columnsInfoMap.get(columnName.toLowerCase());
                TableField.MetaInfo metaInfo = new TableField.MetaInfo(columnInfo, tableInfo);
                boolean bl = isId = selectPk ? pkColumns.contains(columnName) : result.isPrimaryKey();
                if (isId) {
                    field.primaryKey(this.dbQuery.isKeyIdentity(result.getResultSet()));
                    tableInfo.setHavePrimaryKey(true);
                    if (field.isKeyIdentityFlag() && entity.getIdType() != null) {
                        this.LOGGER.warn("The primary key of the current table [{}] is configured as auto-incrementing, which will override the global primary key ID type strategy.", (Object)tableName);
                    }
                }
                field.setColumnName(columnName).setType(result.getStringResult(this.dbQuery.fieldType())).setComment(result.getFiledComment()).setCustomMap(this.dbQuery.getCustomFields(result.getResultSet()));
                String propertyName = entity.getNameConvert().propertyNameConvert(field);
                IColumnType columnType = this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, field);
                field.setPropertyName(propertyName, columnType);
                field.setMetaInfo(metaInfo);
                tableInfo.addField(field);
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        tableInfo.processTable();
    }
}

