/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.web.filter;

import com.baomidou.kisso.common.util.HttpUtil;
import com.baomidou.kisso.web.waf.request.WafRequestWrapper;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class WafFilter
implements Filter {
    private static final Logger logger = Logger.getLogger("WafFilter");
    private static String OVER_URL = null;
    private static boolean FILTER_XSS = true;
    private static boolean FILTER_SQL = true;

    public void init(FilterConfig config) throws ServletException {
        OVER_URL = config.getInitParameter("over.url");
        FILTER_XSS = this.getParamConfig(config.getInitParameter("filter_xss"));
        FILTER_SQL = this.getParamConfig(config.getInitParameter("filter_sql_injection"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        boolean isOver = HttpUtil.inContainURL(req, OVER_URL);
        if (!isOver) {
            try {
                chain.doFilter((ServletRequest)new WafRequestWrapper(req, FILTER_XSS, FILTER_SQL), response);
            }
            catch (Exception e) {
                logger.severe(" wafxx.jar WafFilter exception , requestURL: " + req.getRequestURL());
            }
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        logger.warning(" WafFilter destroy .");
    }

    private boolean getParamConfig(String value) {
        if (value == null || "".equals(value.trim())) {
            return true;
        }
        return new Boolean(value);
    }
}

