/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.Token;
import com.baomidou.kisso.common.IpHelper;
import com.baomidou.kisso.common.encrypt.RSA;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.exception.KissoException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class AuthToken
extends Token {
    private static final Logger logger = Logger.getLogger("AuthToken");
    private String uuid;
    private String sign;
    private String data;

    protected AuthToken() {
    }

    public AuthToken(HttpServletRequest request, String privateKey) {
        this.uuid = RandomUtil.get32UUID();
        this.setIp(IpHelper.getIpAddr(request));
        this.sign(privateKey);
        this.setApp(SSOConfig.getInstance().getRole());
    }

    public byte[] signByte() {
        StringBuffer sb = new StringBuffer(this.getUuid());
        sb.append("-").append(this.getIp());
        return sb.toString().getBytes();
    }

    public void sign(String privateKey) {
        try {
            this.sign = RSA.sign(this.signByte(), privateKey);
        }
        catch (Exception e) {
            logger.severe("sign error.");
            e.printStackTrace();
            throw new KissoException(" AuthToken RSA sign error. ");
        }
    }

    public AuthToken verify(String publicKey) {
        try {
            if (RSA.verify(this.signByte(), publicKey, this.getSign())) {
                return this;
            }
        }
        catch (Exception e) {
            logger.severe("verify error.");
            e.printStackTrace();
            throw new KissoException(" AuthToken RSA verify error. ");
        }
        return null;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

