/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.VectorSearchVectorizer;
import com.azure.search.documents.indexes.models.VectorSearchVectorizerKind;
import com.azure.search.documents.indexes.models.WebApiVectorizerParameters;
import java.io.IOException;

public final class WebApiVectorizer
extends VectorSearchVectorizer {
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.CUSTOM_WEB_API;
    private WebApiVectorizerParameters webApiParameters;

    public WebApiVectorizer(String vectorizerName) {
        super(vectorizerName);
    }

    @Override
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    public WebApiVectorizerParameters getWebApiParameters() {
        return this.webApiParameters;
    }

    public WebApiVectorizer setWebApiParameters(WebApiVectorizerParameters webApiParameters) {
        this.webApiParameters = webApiParameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getVectorizerName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("customWebApiParameters", (JsonSerializable)this.webApiParameters);
        return jsonWriter.writeEndObject();
    }

    public static WebApiVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return (WebApiVectorizer)jsonReader.readObject(reader -> {
            boolean vectorizerNameFound = false;
            String vectorizerName = null;
            VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.CUSTOM_WEB_API;
            WebApiVectorizerParameters webApiParameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    vectorizerNameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchVectorizerKind.fromString(reader.getString());
                    continue;
                }
                if ("customWebApiParameters".equals(fieldName)) {
                    webApiParameters = WebApiVectorizerParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (vectorizerNameFound) {
                WebApiVectorizer deserializedWebApiVectorizer = new WebApiVectorizer(vectorizerName);
                deserializedWebApiVectorizer.kind = kind;
                deserializedWebApiVectorizer.webApiParameters = webApiParameters;
                return deserializedWebApiVectorizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

