/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import com.azure.search.documents.indexes.models.MicrosoftStemmingTokenizerLanguage;
import java.io.IOException;

public final class MicrosoftLanguageStemmingTokenizer
extends LexicalTokenizer {
    private String odataType = "#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer";
    private Integer maxTokenLength;
    private Boolean isSearchTokenizerUsed;
    private MicrosoftStemmingTokenizerLanguage language;

    public MicrosoftLanguageStemmingTokenizer(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public MicrosoftLanguageStemmingTokenizer setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    public Boolean isSearchTokenizer() {
        return this.isSearchTokenizerUsed;
    }

    public MicrosoftLanguageStemmingTokenizer setIsSearchTokenizerUsed(Boolean isSearchTokenizerUsed) {
        this.isSearchTokenizerUsed = isSearchTokenizerUsed;
        return this;
    }

    public MicrosoftStemmingTokenizerLanguage getLanguage() {
        return this.language;
    }

    public MicrosoftLanguageStemmingTokenizer setLanguage(MicrosoftStemmingTokenizerLanguage language) {
        this.language = language;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("maxTokenLength", (Number)this.maxTokenLength);
        jsonWriter.writeBooleanField("isSearchTokenizer", this.isSearchTokenizerUsed);
        jsonWriter.writeStringField("language", this.language == null ? null : this.language.toString());
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftLanguageStemmingTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftLanguageStemmingTokenizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer";
            Integer maxTokenLength = null;
            Boolean isSearchTokenizerUsed = null;
            MicrosoftStemmingTokenizerLanguage language = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isSearchTokenizer".equals(fieldName)) {
                    isSearchTokenizerUsed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("language".equals(fieldName)) {
                    language = MicrosoftStemmingTokenizerLanguage.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                MicrosoftLanguageStemmingTokenizer deserializedMicrosoftLanguageStemmingTokenizer = new MicrosoftLanguageStemmingTokenizer(name);
                deserializedMicrosoftLanguageStemmingTokenizer.odataType = odataType;
                deserializedMicrosoftLanguageStemmingTokenizer.maxTokenLength = maxTokenLength;
                deserializedMicrosoftLanguageStemmingTokenizer.isSearchTokenizerUsed = isSearchTokenizerUsed;
                deserializedMicrosoftLanguageStemmingTokenizer.language = language;
                return deserializedMicrosoftLanguageStemmingTokenizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

