/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AnalyzedTokenInfo;
import java.io.IOException;
import java.util.List;

public final class AnalyzeResult
implements JsonSerializable<AnalyzeResult> {
    private final List<AnalyzedTokenInfo> tokens;

    public AnalyzeResult(List<AnalyzedTokenInfo> tokens) {
        this.tokens = tokens;
    }

    public List<AnalyzedTokenInfo> getTokens() {
        return this.tokens;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tokens", this.tokens, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeResult fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeResult)jsonReader.readObject(reader -> {
            boolean tokensFound = false;
            List tokens = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tokens".equals(fieldName)) {
                    tokens = reader.readArray(reader1 -> AnalyzedTokenInfo.fromJson(reader1));
                    tokensFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (tokensFound) {
                return new AnalyzeResult(tokens);
            }
            throw new IllegalStateException("Missing required property: tokens");
        });
    }
}

