/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit.data;

import com.astamuse.asta4d.data.DefaultDataTypeTransformer;
import com.astamuse.asta4d.data.convertor.DataValueConvertor;
import com.astamuse.asta4d.data.convertor.UnsupportedValueException;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import java.time.Instant;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.LinkedList;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DefaultDataTypeTransformerTest
extends BaseTest {
    private DefaultDataTypeTransformer invoker;

    @BeforeClass
    public void prepareInvoker() {
        this.invoker = new DefaultDataTypeTransformer();
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(new String2PB());
        list.add(new PA2String());
        list.add(new String2LongArray());
        list.add(new StringArray2Long());
        list.add(new String2LongSpecial());
        this.invoker.setDataTypeConvertorList(list);
    }

    @DataProvider(name="test-data")
    public Object[][] getTestData() throws Exception {
        return new Object[][]{{String.class, TestEnum.class, "OK", TestEnum.OK}, {String[].class, TestEnum[].class, new String[]{"OK", "OK", "NG"}, new TestEnum[]{TestEnum.OK, TestEnum.OK, TestEnum.NG}}, {String.class, Integer.class, "123", 123}, {String.class, Integer[].class, "123", new Integer[]{123}}, {String[].class, Integer[].class, new String[]{"123", "456"}, new Integer[]{123, 456}}, {String[].class, Integer.class, new String[]{"123", "456"}, 123}, {String[].class, Date.class, new String[]{"2014-11-10"}, new Date(114, 10, 10)}, {String[].class, Instant.class, new String[]{"2014-11-10"}, ZonedDateTime.of(java.time.LocalDateTime.of(2014, 11, 10, 0, 0), ZoneId.systemDefault()).toInstant()}, {String[].class, LocalDate.class, new String[]{"2014-11-10"}, LocalDate.of(2014, 11, 10)}, {String[].class, java.time.LocalDateTime.class, new String[]{"2014-11-10T12:00:00"}, java.time.LocalDateTime.of(2014, 11, 10, 12, 0, 0)}, {String[].class, java.time.LocalTime.class, new String[]{"12:00:00"}, java.time.LocalTime.of(12, 0, 0)}, {String[].class, YearMonth.class, new String[]{"2014-11"}, YearMonth.of(2014, 11)}, {String[].class, DateTime.class, new String[]{"2014-11-10"}, new DateTime(2014, 11, 10, 0, 0)}, {String[].class, org.joda.time.LocalDate.class, new String[]{"2014-11-10"}, new org.joda.time.LocalDate(2014, 11, 10)}, {String[].class, LocalDateTime.class, new String[]{"2014-11-10T12:00:00"}, new LocalDateTime(2014, 11, 10, 12, 0, 0)}, {String[].class, LocalTime.class, new String[]{"12:00:00"}, new LocalTime(12, 0, 0)}, {String[].class, org.joda.time.YearMonth.class, new String[]{"2014-11"}, new org.joda.time.YearMonth(2014, 11)}, {String.class, Long[].class, "123,456", new Long[]{123L, 456L}}, {String[].class, Long.class, new String[]{"123", "456"}, 456L}, {String.class, Integer[][].class, "123", null}, {String[].class, Integer[][].class, new String[]{"123", "456"}, null}, {String.class, Long[][].class, "123,456", new Long[][]{{123L, 456L}}}, {String[][].class, Integer.class, new String[][]{{"123", "456"}}, 123}, {String[][][].class, Integer.class, new String[][][]{{{"123", "456"}}}, 123}, {String.class, PA.class, "123", new PB("123")}, {PB.class, String.class, new PB("123"), "123"}, {String.class, Long.class, "special:398", 498L}};
    }

    @Test(dataProvider="test-data")
    public void testTransforming(Class srcType, Class targetType, Object data, Object expectedData) throws UnsupportedValueException {
        Object ret = this.invoker.transform(srcType, targetType, data);
        if (expectedData != null) {
            Assert.assertTrue((boolean)expectedData.getClass().isAssignableFrom(ret.getClass()));
        }
        Assert.assertEquals((Object)ret, (Object)expectedData);
    }

    public static class String2LongSpecial
    implements DataValueConvertor<String, Long> {
        public Long convert(String obj) {
            if (obj.startsWith("special:")) {
                Long value = Long.parseLong(obj.substring("special:".length()));
                return value + 100L;
            }
            return null;
        }
    }

    public static class StringArray2Long
    implements DataValueConvertor<String[], Long> {
        public Long convert(String[] obj) {
            if (obj.length == 1) {
                return Long.parseLong(obj[0]);
            }
            return Long.parseLong(obj[1]);
        }
    }

    public static class String2LongArray
    implements DataValueConvertor<String, Long[]> {
        public Long[] convert(String obj) {
            String[] array = obj.split(",");
            Long[] ret = new Long[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = Long.parseLong(array[i]);
            }
            return ret;
        }
    }

    public static class PA2String
    implements DataValueConvertor<PA, String> {
        public String convert(PA obj) {
            return obj.value.substring(0, obj.value.indexOf("-PA"));
        }
    }

    public static class String2PB
    implements DataValueConvertor<String, PB> {
        public PB convert(String obj) {
            PB ret = new PB(obj);
            return ret;
        }
    }

    public static class PB
    extends PA {
        String otherValue;

        PB(String v) {
            super(v);
            this.otherValue = v + "-PB";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PB other = (PB)obj;
            return !(this.otherValue == null ? other.otherValue != null : !this.otherValue.equals(other.otherValue));
        }
    }

    public static class PA {
        String value;

        PA(String v) {
            this.value = v + "-PA";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PA other = (PA)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static enum TestEnum {
        OK,
        NG;

    }
}

